
/*
 * Copyright (c) 2017 Dmitry Avtonomov
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package umich.ms.fileio.filetypes.mzidentml.jaxb.standard;

import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlSchemaType;
import javax.xml.bind.annotation.XmlSeeAlso;
import javax.xml.bind.annotation.XmlType;
import javax.xml.datatype.XMLGregorianCalendar;


/**
 * The use of a protocol with the requisite Parameters and ParameterValues. ProtocolApplications can
 * take Material or Data (or both) as input and produce Material or Data (or both) as output.
 *
 * <p>Java class for ProtocolApplicationType complex type.
 *
 * <p>The following schema fragment specifies the expected content contained within this class.
 *
 * <pre>
 * &lt;complexType name="ProtocolApplicationType">
 *   &lt;complexContent>
 *     &lt;extension base="{http://psidev.info/psi/pi/mzIdentML/1.2}IdentifiableType">
 *       &lt;attribute name="activityDate" type="{http://www.w3.org/2001/XMLSchema}dateTime" />
 *     &lt;/extension>
 *   &lt;/complexContent>
 * &lt;/complexType>
 * </pre>
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "ProtocolApplicationType")
@XmlSeeAlso({
    ProteinDetectionType.class,
    SpectrumIdentificationType.class
})
public abstract class ProtocolApplicationType
    extends IdentifiableType {

  @XmlAttribute(name = "activityDate")
  @XmlSchemaType(name = "dateTime")
  protected XMLGregorianCalendar activityDate;

  /**
   * Gets the value of the activityDate property.
   *
   * @return possible object is {@link XMLGregorianCalendar }
   */
  public XMLGregorianCalendar getActivityDate() {
    return activityDate;
  }

  /**
   * Sets the value of the activityDate property.
   *
   * @param value allowed object is {@link XMLGregorianCalendar }
   */
  public void setActivityDate(XMLGregorianCalendar value) {
    this.activityDate = value;
  }

}
