
/*
 * Copyright (c) 2017 Dmitry Avtonomov
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package umich.ms.fileio.filetypes.mzidentml.jaxb.standard;

import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlType;


/**
 * The parameters and settings of a ProteinDetection process.
 *
 * <p>Java class for ProteinDetectionProtocolType complex type.
 *
 * <p>The following schema fragment specifies the expected content contained within this class.
 *
 * <pre>
 * &lt;complexType name="ProteinDetectionProtocolType">
 *   &lt;complexContent>
 *     &lt;extension base="{http://psidev.info/psi/pi/mzIdentML/1.2}IdentifiableType">
 *       &lt;sequence>
 *         &lt;element name="AnalysisParams" type="{http://psidev.info/psi/pi/mzIdentML/1.2}ParamListType" minOccurs="0"/>
 *         &lt;element name="Threshold" type="{http://psidev.info/psi/pi/mzIdentML/1.2}ParamListType"/>
 *       &lt;/sequence>
 *       &lt;attribute name="analysisSoftware_ref" use="required" type="{http://www.w3.org/2001/XMLSchema}string" />
 *     &lt;/extension>
 *   &lt;/complexContent>
 * &lt;/complexType>
 * </pre>
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "ProteinDetectionProtocolType", propOrder = {
    "analysisParams",
    "threshold"
})
public class ProteinDetectionProtocolType
    extends IdentifiableType {

  @XmlElement(name = "AnalysisParams")
  protected ParamListType analysisParams;
  @XmlElement(name = "Threshold", required = true)
  protected ParamListType threshold;
  @XmlAttribute(name = "analysisSoftware_ref", required = true)
  protected String analysisSoftwareRef;

  /**
   * Gets the value of the analysisParams property.
   *
   * @return possible object is {@link ParamListType }
   */
  public ParamListType getAnalysisParams() {
    return analysisParams;
  }

  /**
   * Sets the value of the analysisParams property.
   *
   * @param value allowed object is {@link ParamListType }
   */
  public void setAnalysisParams(ParamListType value) {
    this.analysisParams = value;
  }

  /**
   * Gets the value of the threshold property.
   *
   * @return possible object is {@link ParamListType }
   */
  public ParamListType getThreshold() {
    return threshold;
  }

  /**
   * Sets the value of the threshold property.
   *
   * @param value allowed object is {@link ParamListType }
   */
  public void setThreshold(ParamListType value) {
    this.threshold = value;
  }

  /**
   * Gets the value of the analysisSoftwareRef property.
   *
   * @return possible object is {@link String }
   */
  public String getAnalysisSoftwareRef() {
    return analysisSoftwareRef;
  }

  /**
   * Sets the value of the analysisSoftwareRef property.
   *
   * @param value allowed object is {@link String }
   */
  public void setAnalysisSoftwareRef(String value) {
    this.analysisSoftwareRef = value;
  }

}
