/*
 * Decompiled with CFR 0.152.
 */
package umich.ms.fileio.filetypes.pepxml;

import java.io.InputStream;
import java.nio.file.Path;
import java.util.Iterator;
import javax.xml.bind.JAXBException;
import javax.xml.stream.XMLStreamReader;
import umich.ms.fileio.exceptions.FileParsingException;
import umich.ms.fileio.filetypes.pepxml.PepXmlStreamIterator;
import umich.ms.fileio.filetypes.pepxml.jaxb.standard.MsmsPipelineAnalysis;
import umich.ms.fileio.filetypes.pepxml.jaxb.standard.MsmsRunSummary;
import umich.ms.util.jaxb.JaxbUtils;

public class PepXmlParser {
    protected static final String TAG_MSMS_RUN_SUMMARY = "msms_run_summary";
    protected static final String TAG_MSMS_PIPELINE_ANALYSIS = "msms_pipeline_analysis";

    private PepXmlParser() {
    }

    public static MsmsPipelineAnalysis parse(Path path) throws FileParsingException {
        try {
            XMLStreamReader xsr = JaxbUtils.createXmlStreamReader(path, false);
            MsmsPipelineAnalysis msmsPipelineAnalysis = JaxbUtils.unmarshal(MsmsPipelineAnalysis.class, xsr);
            return msmsPipelineAnalysis;
        }
        catch (JAXBException e) {
            throw new FileParsingException(String.format("JAXB parsing of PepXML file failed (%s)", path.toAbsolutePath().toString()), e);
        }
    }

    public static Iterator<MsmsRunSummary> parse(InputStream is) throws FileParsingException {
        return PepXmlStreamIterator.create(is);
    }
}

