/*
 * Decompiled with CFR 0.152.
 */
package umich.ms.fileio.filetypes.mzxml;

import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.zip.DataFormatException;
import javolution.text.CharArray;
import javolution.xml.internal.stream.XMLStreamReaderImpl;
import javolution.xml.sax.Attributes;
import javolution.xml.stream.XMLStreamException;
import javolution.xml.stream.XMLUnexpectedEndOfDocumentException;
import javolution.xml.stream.XMLUnexpectedEndTagException;
import org.apache.commons.pool2.ObjectPool;
import umich.ms.datatypes.LCMSDataSubset;
import umich.ms.datatypes.lcmsrun.LCMSRunInfo;
import umich.ms.datatypes.scan.IScan;
import umich.ms.datatypes.scan.PeaksCompression;
import umich.ms.datatypes.scan.impl.ScanDefault;
import umich.ms.datatypes.scan.props.Polarity;
import umich.ms.datatypes.scan.props.PrecursorInfo;
import umich.ms.datatypes.scan.props.ScanType;
import umich.ms.datatypes.spectrum.ISpectrum;
import umich.ms.datatypes.spectrum.impl.SpectrumDefault;
import umich.ms.fileio.exceptions.FileParsingException;
import umich.ms.fileio.filetypes.mzxml.MZXMLFile;
import umich.ms.fileio.filetypes.mzxml.MZXMLIndex;
import umich.ms.fileio.filetypes.mzxml.MZXMLIndexElement;
import umich.ms.fileio.filetypes.mzxml.MZXMLPeaksDecoder;
import umich.ms.fileio.filetypes.mzxml.MzxmlVars;
import umich.ms.fileio.filetypes.xmlbased.MultiSpectraParser;
import umich.ms.logging.LogHelper;
import umich.ms.util.ByteArrayHolder;
import umich.ms.util.base64.Base64;
import umich.ms.util.base64.Base64Context;
import umich.ms.util.base64.Base64ContextPooled;

public class MZXMLMultiSpectraParser
extends MultiSpectraParser {
    protected final MZXMLFile source;
    protected LCMSRunInfo runInfo;
    protected MZXMLIndex index;
    private ArrayList<IScan> parsedScans;
    private MzxmlVars vars;
    private ObjectPool<XMLStreamReaderImpl> readerPool = null;
    private int numOpeningScanTagsFound;

    MZXMLMultiSpectraParser(InputStream is, LCMSDataSubset subset, MZXMLFile source) throws FileParsingException {
        super(is, subset);
        this.source = source;
    }

    void setReaderPool(ObjectPool<XMLStreamReaderImpl> readerPool) {
        this.readerPool = readerPool;
    }

    public MZXMLFile getSource() {
        return this.source;
    }

    /*
     * Exception decompiling
     */
    @Override
    public List<IScan> call() throws Exception {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [0[TRYBLOCK]], but top level block is 3[SWITCH]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private int tagPeaksStart(XMLStreamReaderImpl reader, int eventType) throws XMLStreamException, FileParsingException, DataFormatException, IOException {
        this.vars.isPeaksTagReached = true;
        if (this.vars.curScan == null || !this.doesNeedSpectrumParsing(this.vars.curScan)) {
            this.addCurScanAndFlushVars();
            return eventType;
        }
        Attributes attrs = reader.getAttributes();
        CharArray attr = attrs.getValue((CharSequence)ATTR.COMPRESSION_TYPE.name);
        if (attr != null) {
            this.vars.compressionType = attr.toString();
        }
        if ((attr = attrs.getValue((CharSequence)ATTR.COMPRESSED_LEN.name)) != null) {
            this.vars.compressedLen = attr.toInt();
        }
        if ((attr = attrs.getValue((CharSequence)ATTR.PRECISION.name)) != null) {
            this.vars.precisionMz = attr.toInt();
            this.vars.precisionInt = attr.toInt();
        }
        if (this.vars.peaksCount > 0) {
            eventType = reader.next();
            if (eventType != 4) {
                throw new FileParsingException(String.format("Base64 encoded string was not found immediately after <%s> tag for scan #%d", TAG.PEAKS.name, this.vars.curScan.getNum()));
            }
            Base64 base64 = new Base64();
            Base64ContextPooled ctx = new Base64ContextPooled();
            CharArray chars = reader.getText();
            Base64Context decodedB64 = base64.decode(chars.array(), chars.offset(), chars.length(), (Base64Context)ctx);
            ByteArrayHolder bah = decodedB64.readResults();
            PeaksCompression compression = PeaksCompression.NONE;
            if (this.vars.compressionType != null && "zlib".equalsIgnoreCase(this.vars.compressionType)) {
                compression = PeaksCompression.ZLIB;
            }
            MZXMLPeaksDecoder.DecodedData decoded = MZXMLPeaksDecoder.decode(bah.getUnderlyingBytes(), bah.getPosition(), this.vars.precisionMz, compression);
            ((Base64Context)ctx).close();
            SpectrumDefault spectrum = new SpectrumDefault(decoded.mzs, decoded.intensities, decoded.minIntensity, decoded.minIntensityNonZero, decoded.maxIntensity, decoded.maxIntensityMz, decoded.intensitySum);
            this.vars.curScan.setSpectrum(spectrum, false);
        }
        return eventType;
    }

    private int tagPrecursorStart(XMLStreamReaderImpl reader) throws FileParsingException, XMLStreamException {
        int eventType;
        CharArray attr;
        if (this.vars.curScan == null) {
            this.vars.reset();
        }
        Attributes attrs = reader.getAttributes();
        PrecursorInfo precursorInfo = this.vars.curScan.getPrecursor();
        if (precursorInfo == null) {
            precursorInfo = new PrecursorInfo();
            this.vars.curScan.setPrecursor(precursorInfo);
        }
        if ((attr = attrs.getValue((CharSequence)ATTR.PRECURSOR_SCAN_NUM.name)) != null) {
            precursorInfo.setParentScanRefRaw(attr.toString());
            try {
                int precursorScanNumInternal = this.mapRawNumToInternalScanNum(attr.toInt());
                precursorInfo.setParentScanNum(precursorScanNumInternal);
            }
            catch (FileParsingException precursorScanNumInternal) {
                // empty catch block
            }
        }
        if ((attr = attrs.getValue((CharSequence)ATTR.FRAGMENTATION_METHOD.name)) != null) {
            precursorInfo.getActivationInfo().setActivationMethod(attr.toString());
        }
        attr = attrs.getValue((CharSequence)ATTR.PRECURSOR_ISOLATION_WINDOW.name);
        Double isolationWindowWidth = null;
        if (attr != null) {
            isolationWindowWidth = attr.toDouble();
        }
        attr = attrs.getValue((CharSequence)ATTR.PRECURSOR_CHARGE.name);
        Integer charge = null;
        if (attr != null) {
            charge = attr.toInt();
        }
        if ((eventType = reader.next()) != 4) {
            throw new FileParsingException("PrecursorMz tag was not immediately followed by characters, representing precursor mass.");
        }
        attr = reader.getText();
        double precursorMz = attr.toDouble();
        precursorInfo.setMzTarget(precursorMz);
        precursorInfo.setCharge(charge);
        if (isolationWindowWidth == null) {
            isolationWindowWidth = 0.0;
        }
        precursorInfo.setMzRangeStart(precursorMz - isolationWindowWidth / 2.0);
        precursorInfo.setMzRangeEnd(precursorMz + isolationWindowWidth / 2.0);
        return eventType;
    }

    private void tagScanStart(XMLStreamReaderImpl reader) throws FileParsingException {
        ++this.numOpeningScanTagsFound;
        if (this.vars.curScan != null) {
            this.addCurScanAndFlushVars();
        }
        Attributes attrs = reader.getAttributes();
        try {
            this.vars.scanNumRaw = attrs.getValue((CharSequence)ATTR.SCAN_NUM.name).toInt();
            this.vars.msLevel = attrs.getValue((CharSequence)ATTR.MS_LEVEL.name).toInt();
            this.vars.peaksCount = attrs.getValue((CharSequence)ATTR.PEAKS_COUNT.name).toInt();
        }
        catch (NumberFormatException e) {
            throw new FileParsingException("One of the required attributes for <scan> was missing", e);
        }
        int scanNumInternal = this.mapRawNumToInternalScanNum(this.vars.scanNumRaw);
        this.vars.curScan = new ScanDefault(scanNumInternal);
        this.vars.curScan.setMsLevel(this.vars.msLevel);
        CharArray attr = attrs.getValue((CharSequence)ATTR.SCAN_TYPE.name);
        if (attr != null) {
            ScanType scanType = ScanType.fromString(attr.toString());
            this.vars.curScan.setScanType(scanType);
        }
        if ((attr = attrs.getValue((CharSequence)ATTR.CENTROIDED.name)) != null) {
            if (attr.equals("1")) {
                this.vars.curScan.setCentroided(true);
            } else if (attr.equals("0")) {
                this.vars.curScan.setCentroided(false);
            } else {
                this.vars.curScan.setCentroided(attr.toBoolean());
            }
        }
        if ((attr = attrs.getValue((CharSequence)ATTR.POLARITY.name)) != null) {
            if (attr.equals(Polarity.POSITIVE.toString())) {
                this.vars.curScan.setPolarity(Polarity.POSITIVE);
            } else if (attr.equals(Polarity.NEGATIVE.toString())) {
                this.vars.curScan.setPolarity(Polarity.NEGATIVE);
            }
        }
        if ((attr = attrs.getValue((CharSequence)ATTR.ACTIVATION_ENERGY.name)) != null) {
            PrecursorInfo precursorInfo = this.vars.curScan.getPrecursor();
            if (precursorInfo == null) {
                precursorInfo = new PrecursorInfo();
                this.vars.curScan.setPrecursor(precursorInfo);
            }
            precursorInfo.getActivationInfo().setActivationEnergyLo(attr.toDouble());
            precursorInfo.getActivationInfo().setActivationEnergyHi(attr.toDouble());
        }
        if ((attr = attrs.getValue((CharSequence)ATTR.RT.name)) != null) {
            this.vars.curScan.setRt((double)DATA_FACTORY.newDuration(attr.toString()).getTimeInMillis(new Date()) / 1000.0 / 60.0);
        }
        if ((attr = attrs.getValue((CharSequence)ATTR.MZ_LO_INSTRUMENT.name)) != null) {
            this.vars.curScan.setScanMzWindowLower(attr.toDouble());
        } else {
            attr = attrs.getValue((CharSequence)ATTR.MZ_LO_OBSERVED.name);
            if (attr != null) {
                this.vars.curScan.setScanMzWindowLower(attr.toDouble());
            }
        }
        attr = attrs.getValue((CharSequence)ATTR.MZ_HI_INSTRUMENT.name);
        if (attr != null) {
            this.vars.curScan.setScanMzWindowUpper(attr.toDouble());
        } else {
            attr = attrs.getValue((CharSequence)ATTR.MZ_HI_OBSERVED.name);
            if (attr != null) {
                this.vars.curScan.setScanMzWindowUpper(attr.toDouble());
            }
        }
        attr = attrs.getValue((CharSequence)ATTR.BASEPEAK_INTENSITY.name);
        if (attr != null) {
            this.vars.curScan.setBasePeakIntensity(attr.toDouble());
        }
        if ((attr = attrs.getValue((CharSequence)ATTR.TIC.name)) != null) {
            this.vars.curScan.setTic(attr.toDouble());
        }
        attr = attrs.getValue((CharSequence)ATTR.INSTRUMENT_ID.name);
        if (this.runInfo != null) {
            if (attr != null) {
                this.vars.curScan.setInstrument(this.runInfo.getInstrument(attr.toString()));
            } else {
                this.vars.curScan.setInstrument(this.runInfo.getDefaultInstrument());
            }
        }
    }

    private void addCurScanAndFlushVars() {
        if (this.vars.curScan != null && this.vars.isPeaksTagReached && (!this.source.isExcludeEmptyScans() || this.vars.peaksCount != 0)) {
            ISpectrum spectrum = this.vars.curScan.getSpectrumRef().get();
            if (spectrum != null) {
                if (this.vars.curScan.getTic() == null) {
                    this.vars.curScan.setTic(spectrum.getSumInt());
                }
                if (this.vars.curScan.getScanMzWindowLower() == null) {
                    this.vars.curScan.setScanMzWindowLower(spectrum.getMinMZ());
                }
                if (this.vars.curScan.getScanMzWindowUpper() == null) {
                    this.vars.curScan.setScanMzWindowUpper(spectrum.getMaxMZ());
                }
                if (this.vars.curScan.getBasePeakIntensity() == null) {
                    this.vars.curScan.setBasePeakIntensity(spectrum.getMaxInt());
                }
            }
            if (this.vars.curScan.isCentroided() == null && this.runInfo != null && this.runInfo.isCentroided() != null) {
                this.vars.curScan.setCentroided(this.runInfo.isCentroided());
            }
            this.parsedScans.add(this.vars.curScan);
        }
        this.vars.reset();
    }

    protected CharArray fetchAttribute(Attributes attrs, ATTR attr) throws FileParsingException {
        CharArray value = attrs.getValue((CharSequence)attr.name);
        if (attr.isRequired && value == null) {
            throw new FileParsingException(String.format("%s attribute was not specified, but is required by mzXML schema.", attr.name));
        }
        return value;
    }

    private boolean doesNeedSpectrumParsing(IScan scan) {
        return this.subset.isInSubset(scan);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    int findThisStreamFirstScanLen() throws FileParsingException {
        int length = -1;
        this.numOpeningScanTagsFound = 0;
        XMLStreamReaderImpl reader = null;
        try {
            reader = this.readerPool == null ? new XMLStreamReaderImpl() : (XMLStreamReaderImpl)this.readerPool.borrowObject();
            reader.setInput(this.is, StandardCharsets.UTF_8.name());
            LogHelper.setJavolutionLogLevelFatal();
            int eventType = 8;
            block21: do {
                try {
                    eventType = reader.next();
                }
                catch (XMLStreamException e) {
                    if (e instanceof XMLUnexpectedEndTagException) continue;
                    if (!(e instanceof XMLUnexpectedEndOfDocumentException)) throw new FileParsingException(e);
                    int n = length;
                    if (this.readerPool == null) return n;
                    if (reader == null) return n;
                    try {
                        this.readerPool.returnObject((Object)reader);
                        return n;
                    }
                    catch (Exception e2) {
                        throw new FileParsingException(e2);
                    }
                }
                switch (eventType) {
                    case 1: {
                        CharArray localName = reader.getLocalName();
                        if (!localName.contentEquals((CharSequence)TAG.SCAN.name)) continue block21;
                        ++this.numOpeningScanTagsFound;
                        break;
                    }
                    case 2: {
                        CharArray localName = reader.getLocalName();
                        if (!localName.contentEquals((CharSequence)TAG.SCAN.name) || this.numOpeningScanTagsFound != 1) continue block21;
                        XMLStreamReaderImpl.LocationImpl loc = reader.getLocation();
                        int n = length = loc.getCharacterOffset() + loc.getBomLength();
                        return n;
                    }
                }
            } while (eventType != 8);
            return length;
        }
        catch (Exception e) {
            throw new FileParsingException(e);
        }
        finally {
            if (this.readerPool != null && reader != null) {
                try {
                    this.readerPool.returnObject((Object)reader);
                }
                catch (Exception e) {
                    throw new FileParsingException(e);
                }
            }
        }
    }

    private int mapRawNumToInternalScanNum(int rawScanNum) throws FileParsingException {
        MZXMLIndexElement byRawNum = (MZXMLIndexElement)this.index.getByRawNum(rawScanNum);
        if (byRawNum == null) {
            String msg = String.format("Could not find a mapping from spectrum index ref to an internal scan number for\n\t file: %s\n\t raw scan num searched for: #%d\n\t raw scan num of the spectrum in which the error occured: #%d", this.source.getPath(), rawScanNum, this.vars.scanNumRaw);
            throw new FileParsingException(msg);
        }
        return byRawNum.getNumber();
    }

    protected static enum ATTR {
        SCAN_NUM("num", true),
        SCAN_TYPE("scanType", false),
        MS_LEVEL("msLevel", true),
        PEAKS_COUNT("peaksCount", true),
        RT("retentionTime", false),
        POLARITY("polarity", false),
        MZ_LO_OBSERVED("lowMz", false),
        MZ_HI_OBSERVED("highMz", false),
        MZ_LO_INSTRUMENT("startMz", false),
        MZ_HI_INSTRUMENT("endMz", false),
        BASEPEAK_INTENSITY("basePeakIntensity", false),
        INSTRUMENT_ID("msInstrumentID", false),
        TIC("totIonCurrent", false),
        CENTROIDED("centroided", false),
        PRECURSOR_SCAN_NUM("precursorScanNum", false),
        PRECURSOR_INTENSITY("precursorIntensity", true),
        PRECURSOR_CHARGE("precursorCharge", false),
        PRECURSOR_ISOLATION_WINDOW("windowWideness", false),
        FRAGMENTATION_METHOD("activationMethod", false),
        ACTIVATION_ENERGY("collisionEnergy", false),
        COMPRESSION_TYPE("compressionType", true),
        COMPRESSED_LEN("compressedLen", true),
        PRECISION("precision", false);

        public final String name;
        public final boolean isRequired;

        private ATTR(String named, boolean isRequired) {
            this.name = named;
            this.isRequired = isRequired;
        }
    }

    protected static enum TAG {
        SCAN("scan"),
        PRECURSOR("precursorMz"),
        PEAKS("peaks");

        public final String name;

        private TAG(String named) {
            this.name = named;
        }
    }
}

