
/*
 * Copyright (c) 2017 Dmitry Avtonomov
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package umich.ms.fileio.filetypes.pepxml.jaxb.standard;

import java.util.ArrayList;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;


/**
 * <p>Java class for anonymous complex type.
 *
 * <p>The following schema fragment specifies the expected content contained within this class.
 *
 * <pre>
 * &lt;complexType>
 *   &lt;complexContent>
 *     &lt;restriction base="{http://www.w3.org/2001/XMLSchema}anyType">
 *       &lt;sequence>
 *         &lt;element name="inputfile" type="{http://regis-web.systemsbiology.net/pepXML}inputFileType" maxOccurs="unbounded"/>
 *       &lt;/sequence>
 *       &lt;attribute name="filename" use="required" type="{http://www.w3.org/2001/XMLSchema}string" />
 *       &lt;attribute name="directory" use="required" type="{http://www.w3.org/2001/XMLSchema}string" />
 *     &lt;/restriction>
 *   &lt;/complexContent>
 * &lt;/complexType>
 * </pre>
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "", propOrder = {
    "inputfile"
})
@XmlRootElement(name = "interact_summary")
public class InteractSummary {

  @XmlElement(required = true)
  protected List<InputFileType> inputfile;
  @XmlAttribute(name = "filename", required = true)
  protected String filename;
  @XmlAttribute(name = "directory", required = true)
  protected String directory;

  /**
   * Gets the value of the inputfile property.
   *
   * <p>
   * This accessor method returns a reference to the live list, not a snapshot. Therefore any
   * modification you make to the returned list will be present inside the JAXB object. This is why
   * there is not a <CODE>set</CODE> method for the inputfile property.
   *
   * <p>
   * For example, to add a new item, do as follows:
   * <pre>
   *    getInputfile().add(newItem);
   * </pre>
   *
   *
   * <p>
   * Objects of the following type(s) are allowed in the list {@link InputFileType }
   */
  public List<InputFileType> getInputfile() {
    if (inputfile == null) {
      inputfile = new ArrayList<InputFileType>(1);
    }
    return this.inputfile;
  }

  /**
   * Gets the value of the filename property.
   *
   * @return possible object is {@link String }
   */
  public String getFilename() {
    return filename;
  }

  /**
   * Sets the value of the filename property.
   *
   * @param value allowed object is {@link String }
   */
  public void setFilename(String value) {
    this.filename = value;
  }

  /**
   * Gets the value of the directory property.
   *
   * @return possible object is {@link String }
   */
  public String getDirectory() {
    return directory;
  }

  /**
   * Sets the value of the directory property.
   *
   * @param value allowed object is {@link String }
   */
  public void setDirectory(String value) {
    this.directory = value;
  }

}
