/*
 * Decompiled with CFR 0.152.
 */
package javolution.util.internal.table.sorted;

import javolution.util.internal.table.SubTableImpl;
import javolution.util.internal.table.sorted.SharedSortedTableImpl;
import javolution.util.service.SortedTableService;
import javolution.util.service.TableService;

public class SubSortedTableImpl<E>
extends SubTableImpl<E>
implements SortedTableService<E> {
    private static final long serialVersionUID = 1536L;

    public static <E> SortedTableService<E>[] splitOf(SortedTableService<E> table, int n, boolean updateable) {
        if (updateable) {
            table = new SharedSortedTableImpl<E>(table);
        }
        if (n < 1) {
            throw new IllegalArgumentException("Invalid argument n: " + n);
        }
        SortedTableService[] subTables = new SortedTableService[n];
        int minSize = table.size() / n;
        int start = 0;
        for (int i = 0; i < n - 1; ++i) {
            subTables[i] = new SubSortedTableImpl<E>(table, start, start + minSize);
            start += minSize;
        }
        subTables[n - 1] = new SubSortedTableImpl<E>(table, start, table.size());
        return subTables;
    }

    public SubSortedTableImpl(TableService<E> target, int from, int to) {
        super(target, from, to);
    }

    @Override
    public boolean add(E element) {
        int i = this.positionOf(element);
        this.add(i < 0 ? -i - 1 : i, element);
        return true;
    }

    @Override
    public boolean addIfAbsent(E element) {
        int i = this.positionOf(element);
        if (i >= 0) {
            return false;
        }
        this.add(-i - 1, element);
        return true;
    }

    @Override
    public int indexOf(Object o) {
        int i = this.positionOf(o);
        return i >= 0 ? i : -1;
    }

    @Override
    public int lastIndexOf(Object o) {
        int i = this.positionOf(o);
        if (i < 0) {
            return -1;
        }
        while (++i < this.size() && this.comparator().equal(o, this.get(i))) {
        }
        return --i;
    }

    @Override
    public int positionOf(E element) {
        int i = this.target().positionOf(element);
        if (i >= 0) {
            if (i < this.fromIndex) {
                return -1;
            }
            if (i >= this.toIndex) {
                return -this.size() - 1;
            }
            return i - this.fromIndex;
        }
        if ((i = -i - 1) < this.fromIndex) {
            return -1;
        }
        if (i >= this.toIndex) {
            return -this.size() - 1;
        }
        return -(i - this.fromIndex) - 1;
    }

    @Override
    public SortedTableService<E>[] split(int n, boolean updateable) {
        return SubSortedTableImpl.splitOf(this, n, updateable);
    }

    @Override
    protected SortedTableService<E> target() {
        return (SortedTableService)super.target();
    }
}

