/*
 * Decompiled with CFR 0.152.
 */
package javolution.util.internal.table;

import java.util.Iterator;
import java.util.NoSuchElementException;
import javolution.lang.Constant;
import javolution.util.function.Equalities;
import javolution.util.function.Equality;
import javolution.util.internal.table.TableView;

@Constant
public final class ConstantTableImpl<E>
extends TableView<E> {
    private static final long serialVersionUID = 1552L;
    private final E[] elements;

    public ConstantTableImpl(E[] elements) {
        super(null);
        this.elements = elements;
    }

    @Override
    public boolean add(E element) {
        throw new UnsupportedOperationException("Constant tables cannot be modified.");
    }

    @Override
    public void add(int index, E element) {
        throw new UnsupportedOperationException("Constant tables cannot be modified.");
    }

    @Override
    public void clear() {
        throw new UnsupportedOperationException("Constant tables cannot be modified.");
    }

    @Override
    public ConstantTableImpl<E> clone() {
        return this;
    }

    @Override
    public Equality<? super E> comparator() {
        return Equalities.STANDARD;
    }

    @Override
    public E get(int index) {
        return this.elements[index];
    }

    @Override
    public Iterator<E> iterator() {
        return new IteratorImpl();
    }

    @Override
    public E remove(int index) {
        throw new UnsupportedOperationException("Constant tables cannot be modified.");
    }

    @Override
    public E set(int index, E element) {
        throw new UnsupportedOperationException("Constant tables cannot be modified.");
    }

    @Override
    public int size() {
        return this.elements.length;
    }

    private class IteratorImpl
    implements Iterator<E> {
        private int nextIndex;

        private IteratorImpl() {
        }

        @Override
        public boolean hasNext() {
            return this.nextIndex < ConstantTableImpl.this.elements.length;
        }

        @Override
        public E next() {
            if (this.nextIndex >= ConstantTableImpl.this.elements.length) {
                throw new NoSuchElementException();
            }
            return ConstantTableImpl.this.elements[this.nextIndex++];
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("Constant tables cannot be modified.");
        }
    }
}

