/*
 * Decompiled with CFR 0.152.
 */
package javolution.util.internal.map.sorted;

import java.util.Comparator;
import java.util.Map;
import javolution.util.internal.ReadWriteLockImpl;
import javolution.util.internal.map.SharedMapImpl;
import javolution.util.internal.map.sorted.SubSortedMapImpl;
import javolution.util.service.SortedMapService;
import javolution.util.service.SortedSetService;

public class SharedSortedMapImpl<K, V>
extends SharedMapImpl<K, V>
implements SortedMapService<K, V> {
    private static final long serialVersionUID = 1536L;

    public SharedSortedMapImpl(SortedMapService<K, V> target) {
        super(target);
    }

    public SharedSortedMapImpl(SortedMapService<K, V> target, ReadWriteLockImpl lock) {
        super(target, lock);
    }

    @Override
    public Comparator<? super K> comparator() {
        return this.target().keyComparator();
    }

    @Override
    public SortedSetService<Map.Entry<K, V>> entrySet() {
        return new SubSortedMapImpl(this, null, null).entrySet();
    }

    @Override
    public K firstKey() {
        this.lock.readLock.lock();
        try {
            Object k = this.target().firstKey();
            return k;
        }
        finally {
            this.lock.readLock.unlock();
        }
    }

    @Override
    public SortedMapService<K, V> headMap(K toKey) {
        return new SubSortedMapImpl(this, null, toKey);
    }

    @Override
    public SortedSetService<K> keySet() {
        return new SubSortedMapImpl(this, null, null).keySet();
    }

    @Override
    public K lastKey() {
        this.lock.readLock.lock();
        try {
            Object k = this.target().lastKey();
            return k;
        }
        finally {
            this.lock.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SortedMapService<K, V>[] split(int n, boolean updateable) {
        SortedMapService<K, V>[] tmp;
        this.lock.readLock.lock();
        try {
            tmp = this.target().split(n, updateable);
        }
        finally {
            this.lock.readLock.unlock();
        }
        SortedMapService[] result = new SortedMapService[tmp.length];
        for (int i = 0; i < tmp.length; ++i) {
            result[i] = new SharedSortedMapImpl(tmp[i], this.lock);
        }
        return result;
    }

    @Override
    public SortedMapService<K, V> subMap(K fromKey, K toKey) {
        return new SubSortedMapImpl(this, fromKey, toKey);
    }

    @Override
    public SortedMapService<K, V> tailMap(K fromKey) {
        return new SubSortedMapImpl(this, fromKey, null);
    }

    @Override
    protected SortedMapService<K, V> target() {
        return (SortedMapService)super.target();
    }
}

