/*
 * Decompiled with CFR 0.152.
 */
package com.github.blagerweij.sessionlock;

import com.github.blagerweij.sessionlock.SessionLockService;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Date;
import java.util.Locale;
import liquibase.database.Database;
import liquibase.database.core.MySQLDatabase;
import liquibase.exception.LockException;
import liquibase.lockservice.DatabaseChangeLogLock;

public class MySQLLockService
extends SessionLockService {
    static final String SQL_GET_LOCK = "SELECT get_lock(?, ?)";
    static final String SQL_RELEASE_LOCK = "SELECT release_lock(?)";
    static final String SQL_LOCK_INFO = "SELECT l.processlist_id, p.host, p.time, p.state FROM (SELECT is_used_lock(?) AS processlist_id) AS l LEFT JOIN information_schema.processlist p ON p.id = l.processlist_id";

    @Override
    public boolean supports(Database database) {
        return database instanceof MySQLDatabase;
    }

    private String getChangeLogLockName() {
        return (this.database.getDefaultSchemaName() + "." + this.database.getDatabaseChangeLogLockTableName()).toUpperCase(Locale.ROOT);
    }

    private static Integer getIntegerResult(PreparedStatement stmt) throws SQLException {
        try (ResultSet rs = stmt.executeQuery();){
            rs.next();
            Number locked = (Number)rs.getObject(1);
            Integer n = locked == null ? null : Integer.valueOf(locked.intValue());
            return n;
        }
    }

    @Override
    protected boolean acquireLock(Connection con) throws SQLException, LockException {
        try (PreparedStatement stmt = con.prepareStatement(SQL_GET_LOCK);){
            stmt.setString(1, this.getChangeLogLockName());
            int timeoutSeconds = 5;
            stmt.setInt(2, 5);
            Integer locked = MySQLLockService.getIntegerResult(stmt);
            if (locked == null) {
                throw new LockException("GET_LOCK() returned NULL");
            }
            if (locked == 0) {
                boolean bl = false;
                return bl;
            }
            if (locked != 1) {
                throw new LockException("GET_LOCK() returned " + locked);
            }
            boolean bl = true;
            return bl;
        }
    }

    @Override
    protected void releaseLock(Connection con) throws SQLException, LockException {
        try (PreparedStatement stmt = con.prepareStatement(SQL_RELEASE_LOCK);){
            stmt.setString(1, this.getChangeLogLockName());
            Integer unlocked = MySQLLockService.getIntegerResult(stmt);
            if (!Integer.valueOf(1).equals(unlocked)) {
                throw new LockException("RELEASE_LOCK() returned " + String.valueOf(unlocked).toUpperCase(Locale.ROOT));
            }
        }
    }

    @Override
    protected DatabaseChangeLogLock usedLock(Connection con) throws SQLException, LockException {
        try (PreparedStatement stmt = con.prepareStatement(SQL_LOCK_INFO);){
            DatabaseChangeLogLock databaseChangeLogLock;
            block17: {
                ResultSet rs;
                block15: {
                    DatabaseChangeLogLock databaseChangeLogLock2;
                    block16: {
                        stmt.setString(1, this.getChangeLogLockName());
                        rs = stmt.executeQuery();
                        try {
                            if (rs.next() && rs.getObject("PROCESSLIST_ID") != null) break block15;
                            databaseChangeLogLock2 = null;
                            if (rs == null) break block16;
                        }
                        catch (Throwable throwable) {
                            if (rs != null) {
                                try {
                                    rs.close();
                                }
                                catch (Throwable throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                            }
                            throw throwable;
                        }
                        rs.close();
                    }
                    return databaseChangeLogLock2;
                }
                long timestamp = rs.getInt("TIME");
                if (timestamp > 0L) {
                    timestamp = System.currentTimeMillis() - timestamp * 1000L;
                }
                databaseChangeLogLock = new DatabaseChangeLogLock(1, new Date(timestamp), MySQLLockService.lockedBy(rs));
                if (rs == null) break block17;
                rs.close();
            }
            return databaseChangeLogLock;
        }
    }

    private static String lockedBy(ResultSet rs) throws SQLException {
        String host = rs.getString("HOST");
        if (host == null) {
            return "connection_id#" + rs.getLong("PROCESSLIST_ID");
        }
        int colonIndex = host.lastIndexOf(58);
        if (colonIndex > 0) {
            host = host.substring(0, colonIndex);
        }
        return host + " (" + rs.getString("STATE") + ")";
    }
}

