package com.franciaflex.faxtomail.services.service.imports;

/*
 * #%L
 * FaxToMail :: Service
 * $Id: ClientImportModel.java 48 2014-04-25 13:43:04Z echatellier $
 * $HeadURL: http://svn.codelutin.com/faxtomail/tags/faxtomail-0.2/faxtomail-service/src/main/java/com/franciaflex/faxtomail/services/service/imports/ClientImportModel.java $
 * %%
 * Copyright (C) 2014 Franciaflex, Code Lutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

import com.franciaflex.faxtomail.persistence.entities.Client;
import com.franciaflex.faxtomail.persistence.entities.ClientImpl;
import org.nuiton.csv.ValueParser;
import org.nuiton.csv.ext.AbstractImportModel;

import java.text.ParseException;

/**
 * @author Kevin Morin (Code Lutin)
 * @since x.x
 */
public class ClientImportModel extends AbstractImportModel<Client> {

    public ClientImportModel(char separator) {
        super(separator);

        ValueParser<String> nullParser = new ValueParser<String>() {
            @Override
            public String parse(String s) throws ParseException {
                if ("NULL".equals(s)) {
                    s = null;
                }
                return s;
            }
        };
        newMandatoryColumn("Id_Correspondance", Client.PROPERTY_ID);
        newMandatoryColumn("Societe", Client.PROPERTY_BRAND);
        newMandatoryColumn("Nom", Client.PROPERTY_NAME);
        newMandatoryColumn("Caracteristique1", Client.PROPERTY_CARACTERISTIC1, nullParser);
        newMandatoryColumn("Caracteristique2", Client.PROPERTY_CARACTERISTIC2, nullParser);
        newMandatoryColumn("Caracteristique3", Client.PROPERTY_CARACTERISTIC3, nullParser);
        newMandatoryColumn("Numero_Fax", Client.PROPERTY_FAX_NUMBER, nullParser);
        newMandatoryColumn("Adresse_Mail", Client.PROPERTY_EMAIL_ADDRESS, nullParser);
        newMandatoryColumn("Code_Client", Client.PROPERTY_CODE);

        newIgnoredColumn("Client_Top");
        newIgnoredColumn("Objet_Message");
        newIgnoredColumn("Destination");
    }

    @Override
    public Client newEmptyInstance() {
        return new ClientImpl();
    }
}
