package com.franciaflex.faxtomail.persistence.entities;

/*
 * #%L
 * FaxToMail :: Persistence
 * $Id:$
 * $HeadURL:$
 * %%
 * Copyright (C) 2014 - 2015 Mac-Groupe, Code Lutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.annotation.Generated;
import org.nuiton.topia.persistence.TopiaDao;
import org.nuiton.topia.persistence.TopiaEntity;
import org.nuiton.topia.persistence.TopiaException;
import org.nuiton.topia.persistence.TopiaQueryBuilderAddCriteriaOrRunQueryStep;

@Generated(value = "org.nuiton.topia.templates.EntityDaoTransformer", date = "Tue Sep 08 16:00:55 CEST 2015")
public abstract class GeneratedStampTopiaDao<E extends Stamp> extends AbstractFaxToMailTopiaDao<E> {

    @Override
    public Class<E> getEntityClass() {
        return (Class<E>) Stamp.class;
    }

    @Override
    public FaxToMailEntityEnum getTopiaEntityEnum() {
        return FaxToMailEntityEnum.Stamp;
    }

    @Override
    public void delete(E entity) {
        if ( ! entity.isPersisted()) {
            throw new IllegalArgumentException("entity " + entity  + " is not persisted, you can't delete it");
        }

        {
            FaxToMailUserTopiaDao dao = topiaDaoSupplier
                    .getDao(FaxToMailUser.class, FaxToMailUserTopiaDao.class);
            List<FaxToMailUser> list = dao
                    .forProperties(FaxToMailUser.PROPERTY_DEFAULT_SIGNING, entity)
                    .findAll();
            for (FaxToMailUser item : list) {

                // sletellier : Set null only if target is concerned by deletion
                if (entity.equals(item.getDefaultSigning())) {
                    item.setDefaultSigning(null);
                }
            
            }
        }

        super.delete(entity);
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forImageIn(Collection<String> v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forIn(Stamp.PROPERTY_IMAGE, (Collection) v);
        return result;
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forImageEquals(String v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forEquals(Stamp.PROPERTY_IMAGE, v);
        return result;
    }

    @Deprecated
    public E findByImage(String v) {
        return forImageEquals(v).findAnyOrNull();
    }

    @Deprecated
    public List<E> findAllByImage(String v) {
        return forImageEquals(v).findAll();
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forTextIn(Collection<String> v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forIn(Stamp.PROPERTY_TEXT, (Collection) v);
        return result;
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forTextEquals(String v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forEquals(Stamp.PROPERTY_TEXT, v);
        return result;
    }

    @Deprecated
    public E findByText(String v) {
        return forTextEquals(v).findAnyOrNull();
    }

    @Deprecated
    public List<E> findAllByText(String v) {
        return forTextEquals(v).findAll();
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forLabelIn(Collection<String> v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forIn(Stamp.PROPERTY_LABEL, (Collection) v);
        return result;
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forLabelEquals(String v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forEquals(Stamp.PROPERTY_LABEL, v);
        return result;
    }

    @Deprecated
    public E findByLabel(String v) {
        return forLabelEquals(v).findAnyOrNull();
    }

    @Deprecated
    public List<E> findAllByLabel(String v) {
        return forLabelEquals(v).findAll();
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forDescriptionIn(Collection<String> v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forIn(Stamp.PROPERTY_DESCRIPTION, (Collection) v);
        return result;
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forDescriptionEquals(String v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forEquals(Stamp.PROPERTY_DESCRIPTION, v);
        return result;
    }

    @Deprecated
    public E findByDescription(String v) {
        return forDescriptionEquals(v).findAnyOrNull();
    }

    @Deprecated
    public List<E> findAllByDescription(String v) {
        return forDescriptionEquals(v).findAll();
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forSigningIn(Collection<Boolean> v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forIn(Stamp.PROPERTY_SIGNING, (Collection) v);
        return result;
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forSigningEquals(boolean v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forEquals(Stamp.PROPERTY_SIGNING, v);
        return result;
    }

    @Deprecated
    public E findBySigning(boolean v) {
        return forSigningEquals(v).findAnyOrNull();
    }

    @Deprecated
    public List<E> findAllBySigning(boolean v) {
        return forSigningEquals(v).findAll();
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forUsersContains(FaxToMailUser v) {
        return forContains(Stamp.PROPERTY_USERS, v);
    }

    @Deprecated
    public E findContainsUsers(FaxToMailUser v) {
        return forUsersContains(v).findAnyOrNull();
    }

    @Deprecated
    public List<E> findAllContainsUsers(FaxToMailUser v) {
        return forUsersContains(v).findAll();
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forGroupsContains(FaxToMailUserGroup v) {
        return forContains(Stamp.PROPERTY_GROUPS, v);
    }

    @Deprecated
    public E findContainsGroups(FaxToMailUserGroup v) {
        return forGroupsContains(v).findAnyOrNull();
    }

    @Deprecated
    public List<E> findAllContainsGroups(FaxToMailUserGroup v) {
        return forGroupsContains(v).findAll();
    }

    @Override
    public <U extends TopiaEntity> List<U> findUsages(Class<U> type, E entity) {
        List<?> result = new LinkedList();
        List tmp;

        if (type == FaxToMailUser.class) {
            FaxToMailUserTopiaDao dao =
                topiaDaoSupplier.getDao(FaxToMailUser.class, FaxToMailUserTopiaDao.class);
            tmp = dao.forSigningsContains(entity).findAll();
            result.addAll(tmp);
        }

        if (type == FaxToMailUser.class) {
            FaxToMailUserTopiaDao dao =
                topiaDaoSupplier.getDao(FaxToMailUser.class, FaxToMailUserTopiaDao.class);
            tmp = dao.forDefaultSigningEquals(entity).findAll();
            result.addAll(tmp);
        }

        return (List<U>) result;
    }

    @Override
    public Map<Class<? extends TopiaEntity>, List<? extends TopiaEntity>> findAllUsages(E entity) {
        Map<Class<? extends TopiaEntity>,List<? extends TopiaEntity>> result;
        result = new HashMap<Class<? extends TopiaEntity>, List<? extends TopiaEntity>>(1);

        List<? extends TopiaEntity> list;

        list = findUsages(FaxToMailUser.class, entity);
        if (!list.isEmpty()) {
            result.put(FaxToMailUser.class, list);
        }

        return result;
    }

    @Override
    public List<TopiaEntity> getAggregate(E entity) throws TopiaException {
        List<TopiaEntity> tmp = new ArrayList<TopiaEntity>();

        // pour tous les attributs rechecher les composites et les class d'asso
        // on les ajoute dans tmp

        // on refait un tour sur chaque entity de tmp pour recuperer leur
        // composite
        List<TopiaEntity> result = new ArrayList<TopiaEntity>();
        for (TopiaEntity e : tmp) {
            result.add(e);
            TopiaDao<TopiaEntity> dao = (TopiaDao<TopiaEntity>) topiaDaoSupplier.getDao(e.getClass());
            result.addAll(dao.getAggregate(e));
        }
        return result;
    }

    @Override
    public List<TopiaEntity> getComposite(E entity) throws TopiaException {
        List<TopiaEntity> tmp = new ArrayList<TopiaEntity>();

        // pour tous les attributs rechecher les composites et les class d'asso
        // on les ajoute dans tmp

        // on refait un tour sur chaque entity de tmp pour recuperer leur
        // composite
        List<TopiaEntity> result = new ArrayList<TopiaEntity>();
        for (TopiaEntity e : tmp) {
            if (e != null) {
                result.add(e);
                TopiaDao<TopiaEntity> dao = (TopiaDao<TopiaEntity>) topiaDaoSupplier.getDao(e.getClass());
                result.addAll(dao.getComposite(e));
            }
        }
        return result;
    }

} //GeneratedStampTopiaDao<E extends Stamp>
