/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.jaxrs.json.annotation;

import com.fasterxml.jackson.annotation.JacksonAnnotationsInside;
import com.fasterxml.jackson.annotation.JsonRootName;
import com.fasterxml.jackson.annotation.JsonView;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectReader;
import com.fasterxml.jackson.databind.ObjectWriter;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.util.JSONPObject;
import com.fasterxml.jackson.databind.util.JSONWrappedObject;
import com.fasterxml.jackson.jaxrs.json.annotation.JSONP;
import com.fasterxml.jackson.jaxrs.json.annotation.JacksonFeatures;
import java.lang.annotation.Annotation;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EndpointConfig {
    protected Class<?> _activeView;
    protected String _rootName;
    protected DeserializationFeature[] _deserEnable;
    protected DeserializationFeature[] _deserDisable;
    protected ObjectReader _reader;
    protected JSONP.Def _jsonp;
    protected SerializationFeature[] _serEnable;
    protected SerializationFeature[] _serDisable;
    protected ObjectWriter _writer;

    protected EndpointConfig() {
    }

    public static EndpointConfig forReading(ObjectMapper mapper, Annotation[] annotations) {
        return new EndpointConfig().add(annotations, false).initReader(mapper);
    }

    public static EndpointConfig forWriting(ObjectMapper mapper, Annotation[] annotations, String defaultJsonpMethod) {
        EndpointConfig config = new EndpointConfig();
        if (defaultJsonpMethod != null) {
            config._jsonp = new JSONP.Def(defaultJsonpMethod);
        }
        return config.add(annotations, true).initWriter(mapper);
    }

    protected EndpointConfig add(Annotation[] annotations, boolean forWriting) {
        for (Annotation annotation : annotations) {
            JacksonAnnotationsInside inside;
            Class<? extends Annotation> type = annotation.annotationType();
            if (type == JSONP.class) {
                if (!forWriting) continue;
                this._jsonp = new JSONP.Def((JSONP)annotation);
                continue;
            }
            if (type == JsonView.class) {
                Class[] views = ((JsonView)annotation).value();
                this._activeView = views.length > 0 ? views[0] : null;
                continue;
            }
            if (type == JsonRootName.class) {
                this._rootName = ((JsonRootName)annotation).value();
                continue;
            }
            if (type == JacksonFeatures.class) {
                JacksonFeatures feats = (JacksonFeatures)annotation;
                if (forWriting) {
                    this._serEnable = EndpointConfig.nullIfEmpty(feats.serializationEnable());
                    this._serDisable = EndpointConfig.nullIfEmpty(feats.serializationDisable());
                    continue;
                }
                this._deserEnable = EndpointConfig.nullIfEmpty(feats.deserializationEnable());
                this._deserDisable = EndpointConfig.nullIfEmpty(feats.deserializationDisable());
                continue;
            }
            if (type == JacksonAnnotationsInside.class || (inside = type.getAnnotation(JacksonAnnotationsInside.class)) == null) continue;
            this.add(type.getAnnotations(), forWriting);
        }
        return this;
    }

    protected EndpointConfig initReader(ObjectMapper mapper) {
        this._reader = this._activeView != null ? mapper.readerWithView(this._activeView) : mapper.reader();
        if (this._rootName != null) {
            this._reader = this._reader.withRootName(this._rootName);
        }
        if (this._deserEnable != null) {
            this._reader = this._reader.withFeatures(this._deserEnable);
        }
        if (this._deserDisable != null) {
            this._reader = this._reader.withoutFeatures(this._deserDisable);
        }
        this._reader.getJsonFactory().disable(JsonParser.Feature.AUTO_CLOSE_SOURCE);
        return this;
    }

    protected EndpointConfig initWriter(ObjectMapper mapper) {
        this._writer = this._activeView != null ? mapper.writerWithView(this._activeView) : mapper.writer();
        if (this._rootName != null) {
            this._writer = this._writer.withRootName(this._rootName);
        }
        if (this._serEnable != null) {
            this._writer = this._writer.withFeatures(this._serEnable);
        }
        if (this._serDisable != null) {
            this._writer = this._writer.withoutFeatures(this._serDisable);
        }
        this._writer.getJsonFactory().disable(JsonGenerator.Feature.AUTO_CLOSE_TARGET);
        return this;
    }

    public ObjectReader getReader() {
        if (this._reader == null) {
            throw new IllegalStateException();
        }
        return this._reader;
    }

    public ObjectWriter getWriter() {
        if (this._writer == null) {
            throw new IllegalStateException();
        }
        return this._writer;
    }

    public Object applyJSONP(Object value) {
        if (this._jsonp != null) {
            if (this._jsonp.prefix != null || this._jsonp.suffix != null) {
                return new JSONWrappedObject(this._jsonp.prefix, this._jsonp.suffix, value);
            }
            if (this._jsonp.method != null) {
                return new JSONPObject(this._jsonp.method, value);
            }
        }
        return value;
    }

    private static <T> T[] nullIfEmpty(T[] arg) {
        if (arg == null || arg.length == 0) {
            return null;
        }
        return arg;
    }
}

