/*
 * Decompiled with CFR 0.152.
 */
package com.exasol.parquetio.reader.converter;

import com.exasol.parquetio.reader.converter.ArrayGroupConverter;
import com.exasol.parquetio.reader.converter.ArrayPrimitiveConverter;
import com.exasol.parquetio.reader.converter.MapConverter;
import com.exasol.parquetio.reader.converter.ParquetConverter;
import com.exasol.parquetio.reader.converter.ParquetDateConverter;
import com.exasol.parquetio.reader.converter.ParquetDecimalConverter;
import com.exasol.parquetio.reader.converter.ParquetPrimitiveConverter;
import com.exasol.parquetio.reader.converter.ParquetStringConverter;
import com.exasol.parquetio.reader.converter.ParquetTimestampInt96Converter;
import com.exasol.parquetio.reader.converter.ParquetTimestampMicrosConverter;
import com.exasol.parquetio.reader.converter.ParquetTimestampMillisConverter;
import com.exasol.parquetio.reader.converter.ParquetUUIDConverter;
import com.exasol.parquetio.reader.converter.RepeatedGroupConverter;
import com.exasol.parquetio.reader.converter.RepeatedPrimitiveConverter;
import com.exasol.parquetio.reader.converter.StructConverter;
import com.exasol.parquetio.reader.converter.ValueHolder;
import org.apache.parquet.schema.GroupType;
import org.apache.parquet.schema.LogicalTypeAnnotation;
import org.apache.parquet.schema.OriginalType;
import org.apache.parquet.schema.PrimitiveType;
import org.apache.parquet.schema.Type;
import scala.MatchError;

public final class ParquetConverterFactory$ {
    public static final ParquetConverterFactory$ MODULE$ = new ParquetConverterFactory$();

    public ParquetConverter apply(Type parquetType, int fieldIndex, ValueHolder parentDataHolder) {
        if (parquetType.isPrimitive()) {
            if (parquetType.isRepetition(Type.Repetition.REPEATED)) {
                return new RepeatedPrimitiveConverter(parquetType.asPrimitiveType(), fieldIndex, parentDataHolder);
            }
            return this.createPrimitiveConverter(parquetType.asPrimitiveType(), fieldIndex, parentDataHolder);
        }
        return this.createGroupConverter(parquetType, fieldIndex, parentDataHolder);
    }

    public ParquetConverter createPrimitiveConverter(PrimitiveType parquetType, int index, ValueHolder parentHolder) {
        PrimitiveType.PrimitiveTypeName primitiveTypeName = parquetType.getPrimitiveTypeName();
        if (PrimitiveType.PrimitiveTypeName.BOOLEAN.equals(primitiveTypeName)) {
            return new ParquetPrimitiveConverter(index, parentHolder);
        }
        if (PrimitiveType.PrimitiveTypeName.DOUBLE.equals(primitiveTypeName)) {
            return new ParquetPrimitiveConverter(index, parentHolder);
        }
        if (PrimitiveType.PrimitiveTypeName.FLOAT.equals(primitiveTypeName)) {
            return new ParquetPrimitiveConverter(index, parentHolder);
        }
        if (PrimitiveType.PrimitiveTypeName.BINARY.equals(primitiveTypeName)) {
            return this.createBinaryConverter(parquetType, index, parentHolder);
        }
        if (PrimitiveType.PrimitiveTypeName.FIXED_LEN_BYTE_ARRAY.equals(primitiveTypeName)) {
            return this.createFixedByteArrayConverter(parquetType, index, parentHolder);
        }
        if (PrimitiveType.PrimitiveTypeName.INT32.equals(primitiveTypeName)) {
            return this.createIntegerConverter(parquetType, index, parentHolder);
        }
        if (PrimitiveType.PrimitiveTypeName.INT64.equals(primitiveTypeName)) {
            return this.createLongConverter(parquetType, index, parentHolder);
        }
        if (PrimitiveType.PrimitiveTypeName.INT96.equals(primitiveTypeName)) {
            return new ParquetTimestampInt96Converter(index, parentHolder);
        }
        throw new MatchError((Object)primitiveTypeName);
    }

    public ParquetConverter createGroupConverter(Type parquetType, int index, ValueHolder parentHolder) {
        GroupType groupType = parquetType.asGroupType();
        OriginalType originalType = parquetType.getOriginalType();
        if (OriginalType.LIST.equals(originalType)) {
            return this.createArrayConverter(groupType.getType(0), index, parentHolder);
        }
        if (OriginalType.MAP.equals(originalType)) {
            return new MapConverter(parquetType.asGroupType(), index, parentHolder);
        }
        if (groupType.isRepetition(Type.Repetition.REPEATED)) {
            return new RepeatedGroupConverter(groupType, index, parentHolder);
        }
        return new StructConverter(groupType, index, parentHolder);
    }

    private ParquetConverter createBinaryConverter(PrimitiveType primitiveType, int index, ValueHolder holder) {
        OriginalType originalType = primitiveType.getOriginalType();
        if (OriginalType.UTF8.equals(originalType)) {
            return new ParquetStringConverter(index, holder);
        }
        if (OriginalType.DECIMAL.equals(originalType)) {
            return new ParquetDecimalConverter(primitiveType, index, holder);
        }
        return new ParquetPrimitiveConverter(index, holder);
    }

    private ParquetConverter createFixedByteArrayConverter(PrimitiveType primitiveType, int index, ValueHolder holder) {
        LogicalTypeAnnotation logicalTypeAnnotation = primitiveType.getLogicalTypeAnnotation();
        LogicalTypeAnnotation.UUIDLogicalTypeAnnotation uUIDLogicalTypeAnnotation = LogicalTypeAnnotation.uuidType();
        if (!(logicalTypeAnnotation != null ? !logicalTypeAnnotation.equals(uUIDLogicalTypeAnnotation) : uUIDLogicalTypeAnnotation != null)) {
            return new ParquetUUIDConverter(index, holder);
        }
        OriginalType originalType = primitiveType.getOriginalType();
        if (OriginalType.DECIMAL.equals(originalType)) {
            return new ParquetDecimalConverter(primitiveType, index, holder);
        }
        return new ParquetPrimitiveConverter(index, holder);
    }

    private ParquetConverter createIntegerConverter(PrimitiveType primitiveType, int index, ValueHolder holder) {
        OriginalType originalType = primitiveType.getOriginalType();
        if (OriginalType.DATE.equals(originalType)) {
            return new ParquetDateConverter(index, holder);
        }
        if (OriginalType.DECIMAL.equals(originalType)) {
            return new ParquetDecimalConverter(primitiveType, index, holder);
        }
        return new ParquetPrimitiveConverter(index, holder);
    }

    private ParquetConverter createLongConverter(PrimitiveType primitiveType, int index, ValueHolder holder) {
        OriginalType originalType = primitiveType.getOriginalType();
        if (OriginalType.TIMESTAMP_MILLIS.equals(originalType)) {
            return new ParquetTimestampMillisConverter(index, holder);
        }
        if (OriginalType.TIMESTAMP_MICROS.equals(originalType)) {
            return new ParquetTimestampMicrosConverter(index, holder);
        }
        if (OriginalType.DECIMAL.equals(originalType)) {
            return new ParquetDecimalConverter(primitiveType, index, holder);
        }
        return new ParquetPrimitiveConverter(index, holder);
    }

    private ParquetConverter createArrayConverter(Type repeatedType, int index, ValueHolder holder) {
        if (repeatedType.isPrimitive()) {
            return new ArrayPrimitiveConverter(repeatedType.asPrimitiveType(), index, holder);
        }
        if (repeatedType.asGroupType().getFieldCount() > 1) {
            return new ArrayGroupConverter(repeatedType, index, holder);
        }
        Type innerElementType = repeatedType.asGroupType().getType(0);
        return new ArrayGroupConverter(innerElementType, index, holder);
    }

    private ParquetConverterFactory$() {
    }
}

