/*
 * Decompiled with CFR 0.152.
 */
package com.exasol.errorreporting;

import com.exasol.errorreporting.ParameterDefinition;
import com.exasol.errorreporting.ParameterDefinitionList;
import com.exasol.errorreporting.Placeholder;
import com.exasol.errorreporting.PlaceholderMatcher;
import com.exasol.errorreporting.Quoter;

class PlaceholdersFiller {
    private final StringBuilder result;
    private final String text;
    private final ParameterDefinitionList parameters;
    private int previousPlaceholderEndPosition;

    static String fillPlaceholders(String text, ParameterDefinitionList parameters) {
        return new PlaceholdersFiller(text, parameters).fillPlaceholders();
    }

    private PlaceholdersFiller(String text, ParameterDefinitionList parameters) {
        this.parameters = parameters;
        this.result = new StringBuilder();
        this.text = text;
        this.previousPlaceholderEndPosition = 0;
    }

    private String fillPlaceholders() {
        Iterable<Placeholder> placeholders = PlaceholderMatcher.findPlaceholders(this.text);
        for (Placeholder placeholder : placeholders) {
            this.appendSectionBeforePlaceholder(placeholder);
            this.fillPlaceholder(placeholder);
            this.moveToNextPlaceholder(placeholder);
        }
        this.appendRestOfTheMessage();
        return this.getFullMessage();
    }

    private void appendSectionBeforePlaceholder(Placeholder placeholder) {
        this.append(this.getSectionBeforePlaceholder(placeholder));
    }

    private void fillPlaceholder(Placeholder placeholder) {
        this.append(this.getPlaceholderFilling(placeholder));
    }

    private void append(String text) {
        this.result.append(text);
    }

    private void appendRestOfTheMessage() {
        this.append(this.getRestOfTheMessage());
    }

    private String getSectionBeforePlaceholder(Placeholder placeholder) {
        return this.text.substring(this.previousPlaceholderEndPosition, placeholder.getStartIndex());
    }

    private String getRestOfTheMessage() {
        return this.text.substring(this.previousPlaceholderEndPosition);
    }

    private void moveToNextPlaceholder(Placeholder placeholder) {
        this.previousPlaceholderEndPosition = placeholder.getEndIndex();
    }

    private String getFullMessage() {
        return this.result.toString();
    }

    private String getPlaceholderFilling(Placeholder placeholder) {
        if (this.isParameterPresent(placeholder)) {
            return this.getPresentParameterPlaceholderFilling(placeholder);
        }
        return this.getUnknownPlaceholderTextFor(placeholder);
    }

    private boolean isParameterPresent(Placeholder placeholder) {
        return this.parameters.containsKey(placeholder.getReference());
    }

    private String getPresentParameterPlaceholderFilling(Placeholder placeholder) {
        return this.quoteParameterValue(placeholder);
    }

    private String quoteParameterValue(Placeholder placeholder) {
        ParameterDefinition parameter = this.parameters.get(placeholder.getReference());
        return Quoter.quoteObject(parameter.getValue(), placeholder.getQuoting());
    }

    private String getUnknownPlaceholderTextFor(Placeholder placeholder) {
        return "UNKNOWN PLACEHOLDER('" + placeholder.getReference() + "')";
    }
}

