/*
 * Decompiled with CFR 0.152.
 */
package com.docusign.esign.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.v3.oas.annotations.media.Schema;
import java.io.Serializable;
import java.util.Objects;

@Schema(description="Contains information about the BCC email address.")
public class BccEmailAddress
implements Serializable {
    private static final long serialVersionUID = 1L;
    @JsonProperty(value="bccEmailAddressId")
    private String bccEmailAddressId = null;
    @JsonProperty(value="email")
    private String email = null;

    public BccEmailAddress bccEmailAddressId(String bccEmailAddressId) {
        this.bccEmailAddressId = bccEmailAddressId;
        return this;
    }

    @Schema(description="Only users with canManageAccount setting can use this option. An array of up to 5 email addresses the envelope is sent to as a BCC email.    Example: If your account has BCC for Email Archive set up for the email address 'archive@mycompany.com' and you send an envelope using the BCC Email Override to send a BCC email to 'salesarchive@mycompany.com', then a copy of the envelope is only sent to the 'salesarchive@mycompany.com' email address.")
    public String getBccEmailAddressId() {
        return this.bccEmailAddressId;
    }

    public void setBccEmailAddressId(String bccEmailAddressId) {
        this.bccEmailAddressId = bccEmailAddressId;
    }

    public BccEmailAddress email(String email) {
        this.email = email;
        return this;
    }

    @Schema(description="Specifies the BCC email address. DocuSign verifies that the email format is correct, but does not verify that the email is active.Using this overrides the BCC for Email Archive information setting for this envelope.  Maximum of length: 100 characters. ")
    public String getEmail() {
        return this.email;
    }

    public void setEmail(String email) {
        this.email = email;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BccEmailAddress bccEmailAddress = (BccEmailAddress)o;
        return Objects.equals(this.bccEmailAddressId, bccEmailAddress.bccEmailAddressId) && Objects.equals(this.email, bccEmailAddress.email);
    }

    public int hashCode() {
        return Objects.hash(this.bccEmailAddressId, this.email);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class BccEmailAddress {\n");
        sb.append("    bccEmailAddressId: ").append(this.toIndentedString(this.bccEmailAddressId)).append("\n");
        sb.append("    email: ").append(this.toIndentedString(this.email)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

