/*
 * Decompiled with CFR 0.152.
 */
package com.docusign.esign.model;

import com.docusign.esign.model.RecipientAdditionalNotification;
import com.docusign.esign.model.RecipientEmailNotification;
import com.docusign.esign.model.RecipientPhoneNumber;
import com.docusign.esign.model.RecipientSignatureProvider;
import com.docusign.esign.model.Tabs;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@ApiModel(description="Information about a specific role.")
public class TemplateRole {
    @JsonProperty(value="accessCode")
    private String accessCode = null;
    @JsonProperty(value="additionalNotifications")
    private List<RecipientAdditionalNotification> additionalNotifications = null;
    @JsonProperty(value="clientUserId")
    private String clientUserId = null;
    @JsonProperty(value="defaultRecipient")
    private String defaultRecipient = null;
    @JsonProperty(value="deliveryMethod")
    private String deliveryMethod = null;
    @JsonProperty(value="email")
    private String email = null;
    @JsonProperty(value="emailNotification")
    private RecipientEmailNotification emailNotification = null;
    @JsonProperty(value="embeddedRecipientStartURL")
    private String embeddedRecipientStartURL = null;
    @JsonProperty(value="inPersonSignerName")
    private String inPersonSignerName = null;
    @JsonProperty(value="name")
    private String name = null;
    @JsonProperty(value="phoneNumber")
    private RecipientPhoneNumber phoneNumber = null;
    @JsonProperty(value="recipientSignatureProviders")
    private List<RecipientSignatureProvider> recipientSignatureProviders = null;
    @JsonProperty(value="roleName")
    private String roleName = null;
    @JsonProperty(value="routingOrder")
    private String routingOrder = null;
    @JsonProperty(value="signingGroupId")
    private String signingGroupId = null;
    @JsonProperty(value="tabs")
    private Tabs tabs = null;

    public TemplateRole accessCode(String accessCode) {
        this.accessCode = accessCode;
        return this;
    }

    @ApiModelProperty(value="If a value is provided, the recipient must enter the value as the access code to view and sign the envelope.   Maximum Length: 50 characters and it must conform to the account's access code format setting.  If blank, but the signer `accessCode` property is set in the envelope, then that value is used.  If blank and the signer `accessCode` property is not set, then the access code is not required.")
    public String getAccessCode() {
        return this.accessCode;
    }

    public void setAccessCode(String accessCode) {
        this.accessCode = accessCode;
    }

    public TemplateRole additionalNotifications(List<RecipientAdditionalNotification> additionalNotifications) {
        this.additionalNotifications = additionalNotifications;
        return this;
    }

    public TemplateRole addAdditionalNotificationsItem(RecipientAdditionalNotification additionalNotificationsItem) {
        if (this.additionalNotifications == null) {
            this.additionalNotifications = new ArrayList<RecipientAdditionalNotification>();
        }
        this.additionalNotifications.add(additionalNotificationsItem);
        return this;
    }

    @ApiModelProperty(value="")
    public List<RecipientAdditionalNotification> getAdditionalNotifications() {
        return this.additionalNotifications;
    }

    public void setAdditionalNotifications(List<RecipientAdditionalNotification> additionalNotifications) {
        this.additionalNotifications = additionalNotifications;
    }

    public TemplateRole clientUserId(String clientUserId) {
        this.clientUserId = clientUserId;
        return this;
    }

    @ApiModelProperty(value="Specifies whether the recipient is embedded or remote.   If the `clientUserId` property is not null then the recipient is embedded. Note that if the `ClientUserId` property is set and either `SignerMustHaveAccount` or `SignerMustLoginToSign` property of the account settings is set to  **true**, an error is generated on sending.ng.   Maximum length: 100 characters. ")
    public String getClientUserId() {
        return this.clientUserId;
    }

    public void setClientUserId(String clientUserId) {
        this.clientUserId = clientUserId;
    }

    public TemplateRole defaultRecipient(String defaultRecipient) {
        this.defaultRecipient = defaultRecipient;
        return this;
    }

    @ApiModelProperty(value="When set to **true**, this recipient is the default recipient and any tabs generated by the transformPdfFields option are mapped to this recipient.")
    public String getDefaultRecipient() {
        return this.defaultRecipient;
    }

    public void setDefaultRecipient(String defaultRecipient) {
        this.defaultRecipient = defaultRecipient;
    }

    public TemplateRole deliveryMethod(String deliveryMethod) {
        this.deliveryMethod = deliveryMethod;
        return this;
    }

    @ApiModelProperty(value="Reserved: For DocuSign use only.")
    public String getDeliveryMethod() {
        return this.deliveryMethod;
    }

    public void setDeliveryMethod(String deliveryMethod) {
        this.deliveryMethod = deliveryMethod;
    }

    public TemplateRole email(String email) {
        this.email = email;
        return this;
    }

    @ApiModelProperty(value="Specifies the email associated with a role name.")
    public String getEmail() {
        return this.email;
    }

    public void setEmail(String email) {
        this.email = email;
    }

    public TemplateRole emailNotification(RecipientEmailNotification emailNotification) {
        this.emailNotification = emailNotification;
        return this;
    }

    @ApiModelProperty(value="An optional complex type that sets a specific email subject and body for this recipient's notification email.   **Note:** You can set the `emailNotification` property separately for each recipient. If you set the value only for certain recipients, the other recipients will inherit the this value from the top-level `emailSubject` and `emailBlurb`. ")
    public RecipientEmailNotification getEmailNotification() {
        return this.emailNotification;
    }

    public void setEmailNotification(RecipientEmailNotification emailNotification) {
        this.emailNotification = emailNotification;
    }

    public TemplateRole embeddedRecipientStartURL(String embeddedRecipientStartURL) {
        this.embeddedRecipientStartURL = embeddedRecipientStartURL;
        return this;
    }

    @ApiModelProperty(value="Specifies a sender provided valid URL string for redirecting an embedded recipient. When using this option, the embedded recipient still receives an email from DocuSign, just as a remote recipient would. When the document link in the email is clicked the recipient is redirected, through DocuSign, to the supplied URL to complete their actions. When routing to the URL, the sender's system (the server responding to the URL) must request a recipient token to launch a signing session.   If set to `SIGN_AT_DOCUSIGN`, the recipient is directed to an embedded signing or viewing process directly at DocuSign. The signing or viewing action is initiated by the DocuSign system and the transaction activity and Certificate of Completion records will reflect this. In all other ways the process is identical to an embedded signing or viewing operation that is launched by any partner.  It is important to remember that in a typical embedded workflow the authentication of an embedded recipient is the responsibility of the sending application, DocuSign expects that senders will follow their own process for establishing the recipient's identity. In this workflow the recipient goes through the sending application before the embedded signing or viewing process in initiated. However, when the sending application sets `EmbeddedRecipientStartURL=SIGN_AT_DOCUSIGN`, the recipient goes directly to the embedded signing or viewing process bypassing the sending application and any authentication steps the sending application would use. In this case, DocuSign recommends that you use one of the normal DocuSign authentication features (Access Code, Phone Authentication, SMS Authentication, etc.) to verify the identity of the recipient.  If the `clientUserId` property is NOT set, and the `embeddedRecipientStartURL` is set, DocuSign will ignore the redirect URL and launch the standard signing process for the email recipient. Information can be appended to the embedded recipient start URL using merge fields. The available merge fields items are: envelopeId, recipientId, recipientName, recipientEmail, and customFields. The `customFields` property must be set fort the recipient or envelope. The merge fields are enclosed in double brackets.   *Example*:   `http://senderHost/[[mergeField1]]/ beginSigningSession? [[mergeField2]]&[[mergeField3]]` ")
    public String getEmbeddedRecipientStartURL() {
        return this.embeddedRecipientStartURL;
    }

    public void setEmbeddedRecipientStartURL(String embeddedRecipientStartURL) {
        this.embeddedRecipientStartURL = embeddedRecipientStartURL;
    }

    public TemplateRole inPersonSignerName(String inPersonSignerName) {
        this.inPersonSignerName = inPersonSignerName;
        return this;
    }

    @ApiModelProperty(value="Specifies the full legal name of the signer in person signer template roles.  Maximum Length: 100 characters.")
    public String getInPersonSignerName() {
        return this.inPersonSignerName;
    }

    public void setInPersonSignerName(String inPersonSignerName) {
        this.inPersonSignerName = inPersonSignerName;
    }

    public TemplateRole name(String name) {
        this.name = name;
        return this;
    }

    @ApiModelProperty(value="Specifies the recipient's name.")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public TemplateRole phoneNumber(RecipientPhoneNumber phoneNumber) {
        this.phoneNumber = phoneNumber;
        return this;
    }

    @ApiModelProperty(value="Describes the recipient phone number.")
    public RecipientPhoneNumber getPhoneNumber() {
        return this.phoneNumber;
    }

    public void setPhoneNumber(RecipientPhoneNumber phoneNumber) {
        this.phoneNumber = phoneNumber;
    }

    public TemplateRole recipientSignatureProviders(List<RecipientSignatureProvider> recipientSignatureProviders) {
        this.recipientSignatureProviders = recipientSignatureProviders;
        return this;
    }

    public TemplateRole addRecipientSignatureProvidersItem(RecipientSignatureProvider recipientSignatureProvidersItem) {
        if (this.recipientSignatureProviders == null) {
            this.recipientSignatureProviders = new ArrayList<RecipientSignatureProvider>();
        }
        this.recipientSignatureProviders.add(recipientSignatureProvidersItem);
        return this;
    }

    @ApiModelProperty(value="")
    public List<RecipientSignatureProvider> getRecipientSignatureProviders() {
        return this.recipientSignatureProviders;
    }

    public void setRecipientSignatureProviders(List<RecipientSignatureProvider> recipientSignatureProviders) {
        this.recipientSignatureProviders = recipientSignatureProviders;
    }

    public TemplateRole roleName(String roleName) {
        this.roleName = roleName;
        return this;
    }

    @ApiModelProperty(value="Optional element. Specifies the role name associated with the recipient.<br/><br/>This is required when working with template recipients.")
    public String getRoleName() {
        return this.roleName;
    }

    public void setRoleName(String roleName) {
        this.roleName = roleName;
    }

    public TemplateRole routingOrder(String routingOrder) {
        this.routingOrder = routingOrder;
        return this;
    }

    @ApiModelProperty(value="Specifies the routing order of the recipient in the envelope. ")
    public String getRoutingOrder() {
        return this.routingOrder;
    }

    public void setRoutingOrder(String routingOrder) {
        this.routingOrder = routingOrder;
    }

    public TemplateRole signingGroupId(String signingGroupId) {
        this.signingGroupId = signingGroupId;
        return this;
    }

    @ApiModelProperty(value="When set to **true** and the feature is enabled in the sender's account, the signing recipient is required to draw signatures and initials at each signature/initial tab ( instead of adopting a signature/initial style or only drawing a signature/initial once).")
    public String getSigningGroupId() {
        return this.signingGroupId;
    }

    public void setSigningGroupId(String signingGroupId) {
        this.signingGroupId = signingGroupId;
    }

    public TemplateRole tabs(Tabs tabs) {
        this.tabs = tabs;
        return this;
    }

    @ApiModelProperty(value="A list of tabs, which are represented graphically as symbols on documents at the time of signing. Tabs show recipients where to sign, initial, or enter data. They may also display data to the recipients.")
    public Tabs getTabs() {
        return this.tabs;
    }

    public void setTabs(Tabs tabs) {
        this.tabs = tabs;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TemplateRole templateRole = (TemplateRole)o;
        return Objects.equals(this.accessCode, templateRole.accessCode) && Objects.equals(this.additionalNotifications, templateRole.additionalNotifications) && Objects.equals(this.clientUserId, templateRole.clientUserId) && Objects.equals(this.defaultRecipient, templateRole.defaultRecipient) && Objects.equals(this.deliveryMethod, templateRole.deliveryMethod) && Objects.equals(this.email, templateRole.email) && Objects.equals(this.emailNotification, templateRole.emailNotification) && Objects.equals(this.embeddedRecipientStartURL, templateRole.embeddedRecipientStartURL) && Objects.equals(this.inPersonSignerName, templateRole.inPersonSignerName) && Objects.equals(this.name, templateRole.name) && Objects.equals(this.phoneNumber, templateRole.phoneNumber) && Objects.equals(this.recipientSignatureProviders, templateRole.recipientSignatureProviders) && Objects.equals(this.roleName, templateRole.roleName) && Objects.equals(this.routingOrder, templateRole.routingOrder) && Objects.equals(this.signingGroupId, templateRole.signingGroupId) && Objects.equals(this.tabs, templateRole.tabs);
    }

    public int hashCode() {
        return Objects.hash(this.accessCode, this.additionalNotifications, this.clientUserId, this.defaultRecipient, this.deliveryMethod, this.email, this.emailNotification, this.embeddedRecipientStartURL, this.inPersonSignerName, this.name, this.phoneNumber, this.recipientSignatureProviders, this.roleName, this.routingOrder, this.signingGroupId, this.tabs);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class TemplateRole {\n");
        sb.append("    accessCode: ").append(this.toIndentedString(this.accessCode)).append("\n");
        sb.append("    additionalNotifications: ").append(this.toIndentedString(this.additionalNotifications)).append("\n");
        sb.append("    clientUserId: ").append(this.toIndentedString(this.clientUserId)).append("\n");
        sb.append("    defaultRecipient: ").append(this.toIndentedString(this.defaultRecipient)).append("\n");
        sb.append("    deliveryMethod: ").append(this.toIndentedString(this.deliveryMethod)).append("\n");
        sb.append("    email: ").append(this.toIndentedString(this.email)).append("\n");
        sb.append("    emailNotification: ").append(this.toIndentedString(this.emailNotification)).append("\n");
        sb.append("    embeddedRecipientStartURL: ").append(this.toIndentedString(this.embeddedRecipientStartURL)).append("\n");
        sb.append("    inPersonSignerName: ").append(this.toIndentedString(this.inPersonSignerName)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    phoneNumber: ").append(this.toIndentedString(this.phoneNumber)).append("\n");
        sb.append("    recipientSignatureProviders: ").append(this.toIndentedString(this.recipientSignatureProviders)).append("\n");
        sb.append("    roleName: ").append(this.toIndentedString(this.roleName)).append("\n");
        sb.append("    routingOrder: ").append(this.toIndentedString(this.routingOrder)).append("\n");
        sb.append("    signingGroupId: ").append(this.toIndentedString(this.signingGroupId)).append("\n");
        sb.append("    tabs: ").append(this.toIndentedString(this.tabs)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

