/*
 * Decompiled with CFR 0.152.
 */
package com.docusign.esign.api;

import com.docusign.esign.client.ApiClient;
import com.docusign.esign.client.ApiException;
import com.docusign.esign.client.ApiResponse;
import com.docusign.esign.client.Configuration;
import com.docusign.esign.client.Pair;
import com.docusign.esign.model.Notary;
import com.docusign.esign.model.NotaryJournalList;
import com.docusign.esign.model.NotaryJurisdiction;
import com.docusign.esign.model.NotaryJurisdictionList;
import com.docusign.esign.model.NotaryResult;
import java.util.ArrayList;
import java.util.HashMap;
import javax.ws.rs.core.GenericType;

public class NotaryApi {
    private ApiClient apiClient;

    public NotaryApi() {
        this(Configuration.getDefaultApiClient());
    }

    public NotaryApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public Notary createNotary(Notary notary) throws ApiException {
        ApiResponse<Notary> localVarResponse = this.createNotaryWithHttpInfo(notary);
        return localVarResponse.getData();
    }

    public ApiResponse<Notary> createNotaryWithHttpInfo(Notary notary) throws ApiException {
        Notary localVarPostBody = notary;
        String localVarPath = "/v2.1/current_user/notary";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"docusignAccessCode"};
        GenericType<Notary> localVarReturnType = new GenericType<Notary>(){};
        Notary localVarResponse = this.apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
        return new ApiResponse<Notary>(this.apiClient.getStatusCode(), this.apiClient.getResponseHeaders(), localVarResponse);
    }

    public NotaryJurisdiction createNotaryJurisdictions(NotaryJurisdiction notaryJurisdiction) throws ApiException {
        ApiResponse<NotaryJurisdiction> localVarResponse = this.createNotaryJurisdictionsWithHttpInfo(notaryJurisdiction);
        return localVarResponse.getData();
    }

    public ApiResponse<NotaryJurisdiction> createNotaryJurisdictionsWithHttpInfo(NotaryJurisdiction notaryJurisdiction) throws ApiException {
        NotaryJurisdiction localVarPostBody = notaryJurisdiction;
        String localVarPath = "/v2.1/current_user/notary/jurisdictions";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"docusignAccessCode"};
        GenericType<NotaryJurisdiction> localVarReturnType = new GenericType<NotaryJurisdiction>(){};
        NotaryJurisdiction localVarResponse = this.apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
        return new ApiResponse<NotaryJurisdiction>(this.apiClient.getStatusCode(), this.apiClient.getResponseHeaders(), localVarResponse);
    }

    public void deleteNotaryJurisdiction(String jurisdictionId) throws ApiException {
        this.deleteNotaryJurisdictionWithHttpInfo(jurisdictionId);
    }

    public ApiResponse<Object> deleteNotaryJurisdictionWithHttpInfo(String jurisdictionId) throws ApiException {
        String localVarPostBody = "{}";
        if (jurisdictionId == null) {
            throw new ApiException(400, "Missing the required parameter 'jurisdictionId' when calling deleteNotaryJurisdiction");
        }
        String localVarPath = "/v2.1/current_user/notary/jurisdictions/{jurisdictionId}".replaceAll("\\{jurisdictionId\\}", this.apiClient.escapeString(jurisdictionId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"docusignAccessCode"};
        this.apiClient.invokeAPI(localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, null);
        return new ApiResponse<Object>(this.apiClient.getStatusCode(), this.apiClient.getResponseHeaders(), null);
    }

    public NotaryResult getNotary() throws ApiException {
        return this.getNotary(null);
    }

    public NotaryResult getNotary(GetNotaryOptions options) throws ApiException {
        ApiResponse<NotaryResult> localVarResponse = this.getNotaryWithHttpInfo(options);
        return localVarResponse.getData();
    }

    public ApiResponse<NotaryResult> getNotaryWithHttpInfo(GetNotaryOptions options) throws ApiException {
        String localVarPostBody = "{}";
        String localVarPath = "/v2.1/current_user/notary";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (options != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("include_jurisdictions", options.includeJurisdictions));
        }
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"docusignAccessCode"};
        GenericType<NotaryResult> localVarReturnType = new GenericType<NotaryResult>(){};
        NotaryResult localVarResponse = this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
        return new ApiResponse<NotaryResult>(this.apiClient.getStatusCode(), this.apiClient.getResponseHeaders(), localVarResponse);
    }

    public NotaryJurisdiction getNotaryJurisdiction(String jurisdictionId) throws ApiException {
        ApiResponse<NotaryJurisdiction> localVarResponse = this.getNotaryJurisdictionWithHttpInfo(jurisdictionId);
        return localVarResponse.getData();
    }

    public ApiResponse<NotaryJurisdiction> getNotaryJurisdictionWithHttpInfo(String jurisdictionId) throws ApiException {
        String localVarPostBody = "{}";
        if (jurisdictionId == null) {
            throw new ApiException(400, "Missing the required parameter 'jurisdictionId' when calling getNotaryJurisdiction");
        }
        String localVarPath = "/v2.1/current_user/notary/jurisdictions/{jurisdictionId}".replaceAll("\\{jurisdictionId\\}", this.apiClient.escapeString(jurisdictionId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"docusignAccessCode"};
        GenericType<NotaryJurisdiction> localVarReturnType = new GenericType<NotaryJurisdiction>(){};
        NotaryJurisdiction localVarResponse = this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
        return new ApiResponse<NotaryJurisdiction>(this.apiClient.getStatusCode(), this.apiClient.getResponseHeaders(), localVarResponse);
    }

    public void getNotaryJurisdictionSeal(String jurisdictionId) throws ApiException {
        this.getNotaryJurisdictionSealWithHttpInfo(jurisdictionId);
    }

    public ApiResponse<Object> getNotaryJurisdictionSealWithHttpInfo(String jurisdictionId) throws ApiException {
        String localVarPostBody = "{}";
        if (jurisdictionId == null) {
            throw new ApiException(400, "Missing the required parameter 'jurisdictionId' when calling getNotaryJurisdictionSeal");
        }
        String localVarPath = "/v2.1/current_user/notary/jurisdictions/{jurisdictionId}/seal".replaceAll("\\{jurisdictionId\\}", this.apiClient.escapeString(jurisdictionId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"docusignAccessCode"};
        this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, null);
        return new ApiResponse<Object>(this.apiClient.getStatusCode(), this.apiClient.getResponseHeaders(), null);
    }

    public NotaryJurisdictionList getNotaryJurisdictions() throws ApiException {
        ApiResponse<NotaryJurisdictionList> localVarResponse = this.getNotaryJurisdictionsWithHttpInfo();
        return localVarResponse.getData();
    }

    public ApiResponse<NotaryJurisdictionList> getNotaryJurisdictionsWithHttpInfo() throws ApiException {
        String localVarPostBody = "{}";
        String localVarPath = "/v2.1/current_user/notary/jurisdictions";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"docusignAccessCode"};
        GenericType<NotaryJurisdictionList> localVarReturnType = new GenericType<NotaryJurisdictionList>(){};
        NotaryJurisdictionList localVarResponse = this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
        return new ApiResponse<NotaryJurisdictionList>(this.apiClient.getStatusCode(), this.apiClient.getResponseHeaders(), localVarResponse);
    }

    public NotaryJournalList listNotaryJournals() throws ApiException {
        return this.listNotaryJournals(null);
    }

    public NotaryJournalList listNotaryJournals(ListNotaryJournalsOptions options) throws ApiException {
        ApiResponse<NotaryJournalList> localVarResponse = this.listNotaryJournalsWithHttpInfo(options);
        return localVarResponse.getData();
    }

    public ApiResponse<NotaryJournalList> listNotaryJournalsWithHttpInfo(ListNotaryJournalsOptions options) throws ApiException {
        String localVarPostBody = "{}";
        String localVarPath = "/v2.1/current_user/notary/journals";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (options != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("count", options.count));
        }
        if (options != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("search_text", options.searchText));
        }
        if (options != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("start_position", options.startPosition));
        }
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"docusignAccessCode"};
        GenericType<NotaryJournalList> localVarReturnType = new GenericType<NotaryJournalList>(){};
        NotaryJournalList localVarResponse = this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
        return new ApiResponse<NotaryJournalList>(this.apiClient.getStatusCode(), this.apiClient.getResponseHeaders(), localVarResponse);
    }

    public Notary updateNotary(Notary notary) throws ApiException {
        ApiResponse<Notary> localVarResponse = this.updateNotaryWithHttpInfo(notary);
        return localVarResponse.getData();
    }

    public ApiResponse<Notary> updateNotaryWithHttpInfo(Notary notary) throws ApiException {
        Notary localVarPostBody = notary;
        String localVarPath = "/v2.1/current_user/notary";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"docusignAccessCode"};
        GenericType<Notary> localVarReturnType = new GenericType<Notary>(){};
        Notary localVarResponse = this.apiClient.invokeAPI(localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
        return new ApiResponse<Notary>(this.apiClient.getStatusCode(), this.apiClient.getResponseHeaders(), localVarResponse);
    }

    public NotaryJurisdiction updateNotaryJurisdiction(String jurisdictionId, NotaryJurisdiction notaryJurisdiction) throws ApiException {
        ApiResponse<NotaryJurisdiction> localVarResponse = this.updateNotaryJurisdictionWithHttpInfo(jurisdictionId, notaryJurisdiction);
        return localVarResponse.getData();
    }

    public ApiResponse<NotaryJurisdiction> updateNotaryJurisdictionWithHttpInfo(String jurisdictionId, NotaryJurisdiction notaryJurisdiction) throws ApiException {
        NotaryJurisdiction localVarPostBody = notaryJurisdiction;
        if (jurisdictionId == null) {
            throw new ApiException(400, "Missing the required parameter 'jurisdictionId' when calling updateNotaryJurisdiction");
        }
        String localVarPath = "/v2.1/current_user/notary/jurisdictions/{jurisdictionId}".replaceAll("\\{jurisdictionId\\}", this.apiClient.escapeString(jurisdictionId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"docusignAccessCode"};
        GenericType<NotaryJurisdiction> localVarReturnType = new GenericType<NotaryJurisdiction>(){};
        NotaryJurisdiction localVarResponse = this.apiClient.invokeAPI(localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
        return new ApiResponse<NotaryJurisdiction>(this.apiClient.getStatusCode(), this.apiClient.getResponseHeaders(), localVarResponse);
    }

    public class ListNotaryJournalsOptions {
        private String count = null;
        private String searchText = null;
        private String startPosition = null;

        public void setCount(String count) {
            this.count = count;
        }

        public String getCount() {
            return this.count;
        }

        public void setSearchText(String searchText) {
            this.searchText = searchText;
        }

        public String getSearchText() {
            return this.searchText;
        }

        public void setStartPosition(String startPosition) {
            this.startPosition = startPosition;
        }

        public String getStartPosition() {
            return this.startPosition;
        }
    }

    public class GetNotaryOptions {
        private String includeJurisdictions = null;

        public void setIncludeJurisdictions(String includeJurisdictions) {
            this.includeJurisdictions = includeJurisdictions;
        }

        public String getIncludeJurisdictions() {
            return this.includeJurisdictions;
        }
    }
}

