/*
 * Decompiled with CFR 0.152.
 */
package io.github.bucket4j;

import io.github.bucket4j.BlockingBucket;
import io.github.bucket4j.BlockingStrategy;
import io.github.bucket4j.Bucket;
import io.github.bucket4j.BucketConfiguration;
import io.github.bucket4j.BucketExceptions;
import io.github.bucket4j.BucketListener;
import io.github.bucket4j.ConsumptionProbe;
import io.github.bucket4j.EstimationProbe;
import io.github.bucket4j.LimitChecker;
import io.github.bucket4j.Nothing;
import io.github.bucket4j.SchedulingBucket;
import io.github.bucket4j.TokensInheritanceStrategy;
import io.github.bucket4j.UninterruptibleBlockingStrategy;
import io.github.bucket4j.VerboseBucket;
import io.github.bucket4j.VerboseResult;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;

public abstract class AbstractBucket
implements Bucket,
BlockingBucket,
SchedulingBucket {
    protected static long INFINITY_DURATION = Long.MAX_VALUE;
    protected static long UNLIMITED_AMOUNT = Long.MAX_VALUE;
    private final BucketListener listener;
    private final VerboseBucket verboseView = new VerboseBucket(){

        @Override
        public VerboseResult<Boolean> tryConsume(long tokensToConsume) {
            LimitChecker.checkTokensToConsume(tokensToConsume);
            VerboseResult<Boolean> result = AbstractBucket.this.tryConsumeVerboseImpl(tokensToConsume);
            if (result.getValue().booleanValue()) {
                AbstractBucket.this.listener.onConsumed(tokensToConsume);
            } else {
                AbstractBucket.this.listener.onRejected(tokensToConsume);
            }
            return result;
        }

        @Override
        public VerboseResult<Long> consumeIgnoringRateLimits(long tokens) {
            LimitChecker.checkTokensToConsume(tokens);
            VerboseResult<Long> result = AbstractBucket.this.consumeIgnoringRateLimitsVerboseImpl(tokens);
            long penaltyNanos = result.getValue();
            if (penaltyNanos == INFINITY_DURATION) {
                throw BucketExceptions.reservationOverflow();
            }
            AbstractBucket.this.listener.onConsumed(tokens);
            return result;
        }

        @Override
        public VerboseResult<ConsumptionProbe> tryConsumeAndReturnRemaining(long tokensToConsume) {
            LimitChecker.checkTokensToConsume(tokensToConsume);
            VerboseResult<ConsumptionProbe> result = AbstractBucket.this.tryConsumeAndReturnRemainingTokensVerboseImpl(tokensToConsume);
            ConsumptionProbe probe = result.getValue();
            if (probe.isConsumed()) {
                AbstractBucket.this.listener.onConsumed(tokensToConsume);
            } else {
                AbstractBucket.this.listener.onRejected(tokensToConsume);
            }
            return result;
        }

        @Override
        public VerboseResult<EstimationProbe> estimateAbilityToConsume(long numTokens) {
            LimitChecker.checkTokensToConsume(numTokens);
            return AbstractBucket.this.estimateAbilityToConsumeVerboseImpl(numTokens);
        }

        @Override
        public VerboseResult<Long> tryConsumeAsMuchAsPossible() {
            VerboseResult<Long> result = AbstractBucket.this.consumeAsMuchAsPossibleVerboseImpl(UNLIMITED_AMOUNT);
            long consumed = result.getValue();
            if (consumed > 0L) {
                AbstractBucket.this.listener.onConsumed(consumed);
            }
            return result;
        }

        @Override
        public VerboseResult<Long> tryConsumeAsMuchAsPossible(long limit) {
            LimitChecker.checkTokensToConsume(limit);
            VerboseResult<Long> result = AbstractBucket.this.consumeAsMuchAsPossibleVerboseImpl(limit);
            long consumed = result.getValue();
            if (consumed > 0L) {
                AbstractBucket.this.listener.onConsumed(consumed);
            }
            return result;
        }

        @Override
        public VerboseResult<Long> getAvailableTokens() {
            return AbstractBucket.this.getAvailableTokensVerboseImpl();
        }

        @Override
        public VerboseResult<Nothing> addTokens(long tokensToAdd) {
            LimitChecker.checkTokensToAdd(tokensToAdd);
            return AbstractBucket.this.addTokensVerboseImpl(tokensToAdd);
        }

        @Override
        public VerboseResult<Nothing> reset() {
            return AbstractBucket.this.resetVerboseImpl();
        }

        @Override
        public VerboseResult<Nothing> forceAddTokens(long tokensToAdd) {
            LimitChecker.checkTokensToAdd(tokensToAdd);
            return AbstractBucket.this.forceAddTokensVerboseImpl(tokensToAdd);
        }

        @Override
        public VerboseResult<Nothing> replaceConfiguration(BucketConfiguration newConfiguration, TokensInheritanceStrategy tokensInheritanceStrategy) {
            LimitChecker.checkConfiguration(newConfiguration);
            LimitChecker.checkMigrationMode(tokensInheritanceStrategy);
            return AbstractBucket.this.replaceConfigurationVerboseImpl(newConfiguration, tokensInheritanceStrategy);
        }
    };

    protected abstract long consumeAsMuchAsPossibleImpl(long var1);

    protected abstract boolean tryConsumeImpl(long var1);

    protected abstract ConsumptionProbe tryConsumeAndReturnRemainingTokensImpl(long var1);

    protected abstract EstimationProbe estimateAbilityToConsumeImpl(long var1);

    protected abstract long reserveAndCalculateTimeToSleepImpl(long var1, long var3);

    protected abstract void addTokensImpl(long var1);

    protected abstract void forceAddTokensImpl(long var1);

    protected abstract void replaceConfigurationImpl(BucketConfiguration var1, TokensInheritanceStrategy var2);

    protected abstract long consumeIgnoringRateLimitsImpl(long var1);

    protected abstract VerboseResult<Long> consumeAsMuchAsPossibleVerboseImpl(long var1);

    protected abstract VerboseResult<Boolean> tryConsumeVerboseImpl(long var1);

    protected abstract VerboseResult<ConsumptionProbe> tryConsumeAndReturnRemainingTokensVerboseImpl(long var1);

    protected abstract VerboseResult<EstimationProbe> estimateAbilityToConsumeVerboseImpl(long var1);

    protected abstract VerboseResult<Long> getAvailableTokensVerboseImpl();

    protected abstract VerboseResult<Nothing> addTokensVerboseImpl(long var1);

    protected abstract VerboseResult<Nothing> forceAddTokensVerboseImpl(long var1);

    protected abstract VerboseResult<Nothing> resetVerboseImpl();

    protected abstract VerboseResult<Nothing> replaceConfigurationVerboseImpl(BucketConfiguration var1, TokensInheritanceStrategy var2);

    protected abstract VerboseResult<Long> consumeIgnoringRateLimitsVerboseImpl(long var1);

    public AbstractBucket(BucketListener listener) {
        if (listener == null) {
            throw BucketExceptions.nullListener();
        }
        this.listener = listener;
    }

    @Override
    public SchedulingBucket asScheduler() {
        return this;
    }

    @Override
    public VerboseBucket asVerbose() {
        return this.verboseView;
    }

    @Override
    public BlockingBucket asBlocking() {
        return this;
    }

    @Override
    public boolean tryConsume(long tokensToConsume) {
        LimitChecker.checkTokensToConsume(tokensToConsume);
        if (this.tryConsumeImpl(tokensToConsume)) {
            this.listener.onConsumed(tokensToConsume);
            return true;
        }
        this.listener.onRejected(tokensToConsume);
        return false;
    }

    @Override
    public boolean tryConsume(long tokensToConsume, long maxWaitTimeNanos, BlockingStrategy blockingStrategy) throws InterruptedException {
        LimitChecker.checkTokensToConsume(tokensToConsume);
        LimitChecker.checkMaxWaitTime(maxWaitTimeNanos);
        long nanosToSleep = this.reserveAndCalculateTimeToSleepImpl(tokensToConsume, maxWaitTimeNanos);
        if (nanosToSleep == INFINITY_DURATION) {
            this.listener.onRejected(tokensToConsume);
            return false;
        }
        this.listener.onConsumed(tokensToConsume);
        if (nanosToSleep > 0L) {
            try {
                blockingStrategy.park(nanosToSleep);
            }
            catch (InterruptedException e) {
                this.listener.onInterrupted(e);
                throw e;
            }
            this.listener.onParked(nanosToSleep);
        }
        return true;
    }

    @Override
    public boolean tryConsumeUninterruptibly(long tokensToConsume, long maxWaitTimeNanos, UninterruptibleBlockingStrategy blockingStrategy) {
        LimitChecker.checkTokensToConsume(tokensToConsume);
        LimitChecker.checkMaxWaitTime(maxWaitTimeNanos);
        long nanosToSleep = this.reserveAndCalculateTimeToSleepImpl(tokensToConsume, maxWaitTimeNanos);
        if (nanosToSleep == INFINITY_DURATION) {
            this.listener.onRejected(tokensToConsume);
            return false;
        }
        this.listener.onConsumed(tokensToConsume);
        if (nanosToSleep > 0L) {
            blockingStrategy.parkUninterruptibly(nanosToSleep);
            this.listener.onParked(nanosToSleep);
        }
        return true;
    }

    @Override
    public void consume(long tokensToConsume, BlockingStrategy blockingStrategy) throws InterruptedException {
        LimitChecker.checkTokensToConsume(tokensToConsume);
        long nanosToSleep = this.reserveAndCalculateTimeToSleepImpl(tokensToConsume, INFINITY_DURATION);
        if (nanosToSleep == INFINITY_DURATION) {
            throw BucketExceptions.reservationOverflow();
        }
        this.listener.onConsumed(tokensToConsume);
        if (nanosToSleep > 0L) {
            try {
                blockingStrategy.park(nanosToSleep);
            }
            catch (InterruptedException e) {
                this.listener.onInterrupted(e);
                throw e;
            }
            this.listener.onParked(nanosToSleep);
        }
    }

    @Override
    public void consumeUninterruptibly(long tokensToConsume, UninterruptibleBlockingStrategy blockingStrategy) {
        LimitChecker.checkTokensToConsume(tokensToConsume);
        long nanosToSleep = this.reserveAndCalculateTimeToSleepImpl(tokensToConsume, INFINITY_DURATION);
        if (nanosToSleep == INFINITY_DURATION) {
            throw BucketExceptions.reservationOverflow();
        }
        this.listener.onConsumed(tokensToConsume);
        if (nanosToSleep > 0L) {
            blockingStrategy.parkUninterruptibly(nanosToSleep);
            this.listener.onParked(nanosToSleep);
        }
    }

    @Override
    public long consumeIgnoringRateLimits(long tokens) {
        LimitChecker.checkTokensToConsume(tokens);
        long penaltyNanos = this.consumeIgnoringRateLimitsImpl(tokens);
        if (penaltyNanos == INFINITY_DURATION) {
            throw BucketExceptions.reservationOverflow();
        }
        this.listener.onConsumed(tokens);
        return penaltyNanos;
    }

    @Override
    public long tryConsumeAsMuchAsPossible(long limit) {
        LimitChecker.checkTokensToConsume(limit);
        long consumed = this.consumeAsMuchAsPossibleImpl(limit);
        if (consumed > 0L) {
            this.listener.onConsumed(consumed);
        }
        return consumed;
    }

    @Override
    public long tryConsumeAsMuchAsPossible() {
        long consumed = this.consumeAsMuchAsPossibleImpl(UNLIMITED_AMOUNT);
        if (consumed > 0L) {
            this.listener.onConsumed(consumed);
        }
        return consumed;
    }

    @Override
    public ConsumptionProbe tryConsumeAndReturnRemaining(long tokensToConsume) {
        LimitChecker.checkTokensToConsume(tokensToConsume);
        ConsumptionProbe probe = this.tryConsumeAndReturnRemainingTokensImpl(tokensToConsume);
        if (probe.isConsumed()) {
            this.listener.onConsumed(tokensToConsume);
        } else {
            this.listener.onRejected(tokensToConsume);
        }
        return probe;
    }

    @Override
    public EstimationProbe estimateAbilityToConsume(long numTokens) {
        LimitChecker.checkTokensToConsume(numTokens);
        return this.estimateAbilityToConsumeImpl(numTokens);
    }

    @Override
    public void addTokens(long tokensToAdd) {
        LimitChecker.checkTokensToAdd(tokensToAdd);
        this.addTokensImpl(tokensToAdd);
    }

    @Override
    public void forceAddTokens(long tokensToAdd) {
        LimitChecker.checkTokensToAdd(tokensToAdd);
        this.forceAddTokensImpl(tokensToAdd);
    }

    @Override
    public void replaceConfiguration(BucketConfiguration newConfiguration, TokensInheritanceStrategy tokensInheritanceStrategy) {
        LimitChecker.checkConfiguration(newConfiguration);
        LimitChecker.checkMigrationMode(tokensInheritanceStrategy);
        this.replaceConfigurationImpl(newConfiguration, tokensInheritanceStrategy);
    }

    @Override
    public CompletableFuture<Boolean> tryConsume(long tokensToConsume, long maxWaitTimeNanos, ScheduledExecutorService scheduler) {
        LimitChecker.checkMaxWaitTime(maxWaitTimeNanos);
        LimitChecker.checkTokensToConsume(tokensToConsume);
        LimitChecker.checkScheduler(scheduler);
        try {
            long nanosToSleep = this.reserveAndCalculateTimeToSleepImpl(tokensToConsume, maxWaitTimeNanos);
            if (nanosToSleep == INFINITY_DURATION) {
                this.listener.onRejected(tokensToConsume);
                return CompletableFuture.completedFuture(false);
            }
            if (nanosToSleep == 0L) {
                this.listener.onConsumed(tokensToConsume);
                return CompletableFuture.completedFuture(true);
            }
            this.listener.onConsumed(tokensToConsume);
            this.listener.onDelayed(nanosToSleep);
            CompletableFuture<Boolean> resultFuture = new CompletableFuture<Boolean>();
            Runnable delayedCompletion = () -> resultFuture.complete(true);
            scheduler.schedule(delayedCompletion, nanosToSleep, TimeUnit.NANOSECONDS);
            return resultFuture;
        }
        catch (Throwable t) {
            return AbstractBucket.failedFuture(t);
        }
    }

    @Override
    public CompletableFuture<Void> consume(long tokensToConsume, ScheduledExecutorService scheduler) {
        LimitChecker.checkTokensToConsume(tokensToConsume);
        LimitChecker.checkScheduler(scheduler);
        try {
            long nanosToSleep = this.reserveAndCalculateTimeToSleepImpl(tokensToConsume, INFINITY_DURATION);
            if (nanosToSleep == INFINITY_DURATION) {
                return AbstractBucket.failedFuture(BucketExceptions.reservationOverflow());
            }
            if (nanosToSleep == 0L) {
                this.listener.onConsumed(tokensToConsume);
                return CompletableFuture.completedFuture(null);
            }
            this.listener.onConsumed(tokensToConsume);
            this.listener.onDelayed(nanosToSleep);
            CompletableFuture<Void> resultFuture = new CompletableFuture<Void>();
            Runnable delayedCompletion = () -> resultFuture.complete(null);
            scheduler.schedule(delayedCompletion, nanosToSleep, TimeUnit.NANOSECONDS);
            return resultFuture;
        }
        catch (Throwable t) {
            return AbstractBucket.failedFuture(t);
        }
    }

    protected BucketListener getListener() {
        return this.listener;
    }

    public static <T> CompletableFuture<T> completedFuture(Supplier<T> supplier) {
        try {
            return CompletableFuture.completedFuture(supplier.get());
        }
        catch (Throwable t) {
            CompletableFuture fail = new CompletableFuture();
            fail.completeExceptionally(t);
            return fail;
        }
    }

    public static <T> CompletableFuture<T> failedFuture(Throwable t) {
        CompletableFuture fail = new CompletableFuture();
        fail.completeExceptionally(t);
        return fail;
    }
}

