/*
 * Decompiled with CFR 0.152.
 */
package com.browseengine.bobo.search.section;

import com.browseengine.bobo.search.section.SectionSearchQueryPlan;
import com.browseengine.bobo.search.section.SectionSearchQueryPlanBuilder;
import java.io.IOException;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.search.Explanation;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.search.Searcher;
import org.apache.lucene.search.Similarity;
import org.apache.lucene.search.Weight;

public class SectionSearchQuery
extends Query {
    private static final long serialVersionUID = 1L;
    private Query _query;

    public SectionSearchQuery(Query query) {
        this._query = query;
    }

    public String toString(String field) {
        StringBuilder buffer = new StringBuilder();
        buffer.append("SECTION(" + this._query.toString() + ")");
        return buffer.toString();
    }

    public Weight createWeight(Searcher searcher) throws IOException {
        return new SectionSearchWeight(searcher);
    }

    public Query rewrite(IndexReader reader) throws IOException {
        this._query.rewrite(reader);
        return this;
    }

    public class SectionSearchScorer
    extends Scorer {
        private int _curDoc;
        private float _curScr;
        private boolean _more;
        private SectionSearchQueryPlan _plan;

        public SectionSearchScorer(Similarity similarity, float score, IndexReader reader) throws IOException {
            super(similarity);
            this._curDoc = -1;
            this._more = true;
            this._curScr = score;
            SectionSearchQueryPlanBuilder builer = new SectionSearchQueryPlanBuilder(reader);
            this._plan = builer.getPlan(SectionSearchQuery.this._query);
            if (this._plan != null) {
                this._curDoc = -1;
                this._more = true;
            } else {
                this._curDoc = Integer.MAX_VALUE;
                this._more = false;
            }
        }

        public int docID() {
            return this._curDoc;
        }

        public int nextDoc() throws IOException {
            return this.advance(0);
        }

        public float score() throws IOException {
            return this._curScr;
        }

        public int advance(int target) throws IOException {
            if (this._curDoc < Integer.MAX_VALUE) {
                if (target <= this._curDoc) {
                    target = this._curDoc + 1;
                }
                return this._plan.fetch(target);
            }
            return this._curDoc;
        }
    }

    private class SectionSearchWeight
    extends Weight {
        private static final long serialVersionUID = 1L;
        float _weight;
        Similarity _similarity;

        public SectionSearchWeight(Searcher searcher) throws IOException {
            this._similarity = SectionSearchQuery.this.getSimilarity(searcher);
        }

        public String toString() {
            return "weight(" + (Object)((Object)SectionSearchQuery.this) + ")";
        }

        public Query getQuery() {
            return SectionSearchQuery.this;
        }

        public float getValue() {
            return SectionSearchQuery.this.getBoost();
        }

        public float sumOfSquaredWeights() {
            this._weight = SectionSearchQuery.this.getBoost();
            return this._weight * this._weight;
        }

        public void normalize(float queryNorm) {
            this._weight *= queryNorm;
        }

        public Scorer scorer(IndexReader reader) throws IOException {
            SectionSearchScorer scorer = new SectionSearchScorer(this._similarity, this.getValue(), reader);
            return scorer;
        }

        public Explanation explain(IndexReader reader, int doc) throws IOException {
            Explanation result = new Explanation();
            result.setValue(this._weight);
            result.setDescription(SectionSearchQuery.this.toString());
            return result;
        }

        public Scorer scorer(IndexReader reader, boolean scoreDocsInOrder, boolean topScorer) throws IOException {
            return this.scorer(reader);
        }
    }
}

