/*
 * Decompiled with CFR 0.152.
 */
package com.browseengine.bobo.facets.impl;

import com.browseengine.bobo.api.BoboIndexReader;
import com.browseengine.bobo.api.BrowseSelection;
import com.browseengine.bobo.api.FacetSpec;
import com.browseengine.bobo.facets.FacetCountCollector;
import com.browseengine.bobo.facets.FacetCountCollectorSource;
import com.browseengine.bobo.facets.FacetHandler;
import com.browseengine.bobo.facets.data.FacetDataCache;
import com.browseengine.bobo.facets.filter.RandomAccessFilter;
import com.browseengine.bobo.facets.impl.RangeFacetCountCollector;
import com.browseengine.bobo.facets.impl.RangeFacetHandler;
import com.browseengine.bobo.sort.DocComparatorSource;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Properties;

public class FilteredRangeFacetHandler
extends FacetHandler<FacetHandler.FacetDataNone> {
    private final List<String> _predefinedRanges;
    private final String _inner;
    private RangeFacetHandler _innerHandler;

    public FilteredRangeFacetHandler(String name, String underlyingHandler, List<String> predefinedRanges) {
        super(name, new HashSet<String>(Arrays.asList(underlyingHandler)));
        this._predefinedRanges = predefinedRanges;
        this._inner = underlyingHandler;
        this._innerHandler = null;
    }

    @Override
    public RandomAccessFilter buildRandomAccessFilter(String value, Properties selectionProperty) throws IOException {
        return this._innerHandler.buildRandomAccessFilter(value, selectionProperty);
    }

    @Override
    public RandomAccessFilter buildRandomAccessAndFilter(String[] vals, Properties prop) throws IOException {
        return this._innerHandler.buildRandomAccessAndFilter(vals, prop);
    }

    @Override
    public RandomAccessFilter buildRandomAccessOrFilter(String[] vals, Properties prop, boolean isNot) throws IOException {
        return this._innerHandler.buildRandomAccessOrFilter(vals, prop, isNot);
    }

    @Override
    public FacetCountCollectorSource getFacetCountCollectorSource(BrowseSelection sel, final FacetSpec fspec) {
        return new FacetCountCollectorSource(){

            @Override
            public FacetCountCollector getFacetCountCollector(BoboIndexReader reader, int docBase) {
                FacetDataCache dataCache = (FacetDataCache)FilteredRangeFacetHandler.this._innerHandler.getFacetData(reader);
                return new RangeFacetCountCollector(FilteredRangeFacetHandler.this._name, dataCache, docBase, fspec, FilteredRangeFacetHandler.this._predefinedRanges);
            }
        };
    }

    @Override
    public String[] getFieldValues(BoboIndexReader reader, int id) {
        return this._innerHandler.getFieldValues(reader, id);
    }

    @Override
    public Object[] getRawFieldValues(BoboIndexReader reader, int id) {
        return this._innerHandler.getRawFieldValues(reader, id);
    }

    @Override
    public DocComparatorSource getDocComparatorSource() {
        return this._innerHandler.getDocComparatorSource();
    }

    @Override
    public FacetHandler.FacetDataNone load(BoboIndexReader reader) throws IOException {
        FacetHandler<?> handler = reader.getFacetHandler(this._inner);
        if (handler instanceof RangeFacetHandler) {
            this._innerHandler = (RangeFacetHandler)handler;
            return FacetHandler.FacetDataNone.instance;
        }
        throw new IOException("inner handler is not instance of " + RangeFacetHandler.class);
    }
}

