/*
 * Decompiled with CFR 0.152.
 */
package com.browseengine.bobo.client;

import com.browseengine.bobo.api.BrowseRequest;
import com.browseengine.bobo.api.BrowseSelection;
import com.browseengine.bobo.api.FacetSpec;
import org.apache.lucene.search.SortField;

public class BrowseRequestBuilder {
    private BrowseRequest _req;
    private String _qString;

    public BrowseRequestBuilder() {
        this.clear();
    }

    public void addSelection(String name, String val, boolean isNot) {
        BrowseSelection sel = this._req.getSelection(name);
        if (sel == null) {
            sel = new BrowseSelection(name);
        }
        if (isNot) {
            sel.addNotValue(val);
        } else {
            sel.addValue(val);
        }
        this._req.addSelection(sel);
    }

    public void clearSelection(String name) {
        this._req.removeSelection(name);
    }

    public void applyFacetSpec(String name, int minHitCount, int maxCount, boolean expand, FacetSpec.FacetSortSpec orderBy) {
        FacetSpec fspec = new FacetSpec();
        fspec.setMinHitCount(minHitCount);
        fspec.setMaxCount(maxCount);
        fspec.setExpandSelection(expand);
        fspec.setOrderBy(orderBy);
        this._req.setFacetSpec(name, fspec);
    }

    public void applySort(SortField[] sorts) {
        if (sorts == null) {
            this._req.clearSort();
        } else {
            this._req.setSort(sorts);
        }
    }

    public void clearFacetSpecs() {
        this._req.getFacetSpecs().clear();
    }

    public void clearFacetSpec(String name) {
        this._req.getFacetSpecs().remove(name);
    }

    public void setOffset(int offset) {
        this._req.setOffset(offset);
    }

    public void setCount(int count) {
        this._req.setCount(count);
    }

    public void setQuery(String qString) {
        this._qString = qString;
    }

    public void clear() {
        this._req = new BrowseRequest();
        this._req.setOffset(0);
        this._req.setCount(5);
        this._req.setFetchStoredFields(true);
        this._qString = null;
    }

    public void clearSelections() {
        this._req.clearSelections();
    }

    public BrowseRequest getRequest() {
        return this._req;
    }

    public String getQueryString() {
        return this._qString;
    }
}

