/*
 * Decompiled with CFR 0.152.
 */
package com.browseengine.bobo.api;

import com.browseengine.bobo.api.BoboIndexReader;
import com.browseengine.bobo.api.Browsable;
import com.browseengine.bobo.api.BrowseException;
import com.browseengine.bobo.api.BrowseHit;
import com.browseengine.bobo.api.BrowseRequest;
import com.browseengine.bobo.api.BrowseResult;
import com.browseengine.bobo.api.BrowseSelection;
import com.browseengine.bobo.api.FacetAccessible;
import com.browseengine.bobo.api.FacetSpec;
import com.browseengine.bobo.facets.CombinedFacetAccessible;
import com.browseengine.bobo.facets.FacetCountCollector;
import com.browseengine.bobo.facets.FacetHandler;
import com.browseengine.bobo.facets.FacetHandlerInitializerParam;
import com.browseengine.bobo.facets.RuntimeFacetHandler;
import com.browseengine.bobo.facets.RuntimeFacetHandlerFactory;
import com.browseengine.bobo.facets.filter.AndFilter;
import com.browseengine.bobo.facets.filter.RandomAccessFilter;
import com.browseengine.bobo.search.BoboSearcher2;
import com.browseengine.bobo.search.FacetHitCollector;
import com.browseengine.bobo.sort.SortCollector;
import java.io.Closeable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.FieldSelector;
import org.apache.lucene.document.FieldSelectorResult;
import org.apache.lucene.document.Fieldable;
import org.apache.lucene.index.CorruptIndexException;
import org.apache.lucene.search.Collector;
import org.apache.lucene.search.Explanation;
import org.apache.lucene.search.Filter;
import org.apache.lucene.search.MatchAllDocsQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.SortField;
import org.apache.lucene.search.Weight;

public class BoboSubBrowser
extends BoboSearcher2
implements Browsable,
Closeable {
    private static Logger logger = Logger.getLogger(BoboSubBrowser.class);
    private final BoboIndexReader _reader;
    private final Map<String, RuntimeFacetHandlerFactory<?, ?>> _runtimeFacetHandlerFactoryMap;
    private final HashMap<String, FacetHandler<?>> _runtimeFacetHandlerMap;
    private HashMap<String, FacetHandler<?>> _allFacetHandlerMap;
    private ArrayList<RuntimeFacetHandler<?>> _runtimeFacetHandlers = null;

    public BoboIndexReader getIndexReader() {
        return this._reader;
    }

    public BoboSubBrowser(BoboIndexReader reader) {
        super(reader);
        this._reader = reader;
        this._runtimeFacetHandlerMap = new HashMap();
        this._runtimeFacetHandlerFactoryMap = reader.getRuntimeFacetHandlerFactoryMap();
        this._allFacetHandlerMap = null;
    }

    private boolean isNoQueryNoFilter(BrowseRequest req) {
        Query q = req.getQuery();
        Filter filter = req.getFilter();
        return (q == null || q instanceof MatchAllDocsQuery) && filter == null && !this._reader.hasDeletions();
    }

    @Override
    public Object[] getRawFieldVal(int docid, String fieldname) throws IOException {
        FacetHandler<?> facetHandler = this.getFacetHandler(fieldname);
        if (facetHandler == null) {
            return this.getFieldVal(docid, fieldname);
        }
        return facetHandler.getRawFieldValues(this._reader, docid);
    }

    @Override
    public void setFacetHandler(FacetHandler<?> facetHandler) throws IOException {
        Set<String> dependsOn = facetHandler.getDependsOn();
        BoboIndexReader reader = this.getIndexReader();
        if (dependsOn.size() > 0) {
            for (String fn : dependsOn) {
                FacetHandler<?> f = this._runtimeFacetHandlerMap.get(fn);
                if (f == null) {
                    f = reader.getFacetHandler(fn);
                }
                if (f == null) {
                    throw new IOException("depended on facet handler: " + fn + ", but is not found");
                }
                facetHandler.putDependedFacetHandler(f);
            }
        }
        facetHandler.loadFacetData(reader);
        this._runtimeFacetHandlerMap.put(facetHandler.getName(), facetHandler);
    }

    @Override
    public FacetHandler<?> getFacetHandler(String name) {
        return this.getFacetHandlerMap().get(name);
    }

    @Override
    public Map<String, FacetHandler<?>> getFacetHandlerMap() {
        if (this._allFacetHandlerMap == null) {
            this._allFacetHandlerMap = new HashMap(this._reader.getFacetHandlerMap());
        }
        this._allFacetHandlerMap.putAll(this._runtimeFacetHandlerMap);
        return this._allFacetHandlerMap;
    }

    @Override
    public Set<String> getFacetNames() {
        Map<String, FacetHandler<?>> map = this.getFacetHandlerMap();
        return map.keySet();
    }

    @Override
    public void browse(BrowseRequest req, Collector collector, Map<String, FacetAccessible> facetMap) throws BrowseException {
        this.browse(req, collector, facetMap, 0);
    }

    @Override
    public void browse(BrowseRequest req, Collector collector, Map<String, FacetAccessible> facetMap, int start) throws BrowseException {
        Weight w = null;
        try {
            Query q = req.getQuery();
            if (q == null) {
                q = new MatchAllDocsQuery();
            }
            w = this.createWeight(q);
        }
        catch (IOException ioe) {
            throw new BrowseException(ioe.getMessage(), ioe);
        }
        this.browse(req, w, collector, facetMap, start);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void browse(BrowseRequest req, Weight weight, Collector collector, Map<String, FacetAccessible> facetMap, int start) throws BrowseException {
        if (this._reader == null) {
            return;
        }
        this._runtimeFacetHandlers = new ArrayList(this._runtimeFacetHandlerFactoryMap.size());
        Set<String> runtimeFacetNames = this._runtimeFacetHandlerFactoryMap.keySet();
        for (String facetName : runtimeFacetNames) {
            FacetHandler<?> sfacetHandler = this.getFacetHandler(facetName);
            if (sfacetHandler != null) {
                logger.warn((Object)("attempting to reset facetHandler: " + sfacetHandler));
                continue;
            }
            RuntimeFacetHandlerFactory<?, ?> factory = this._runtimeFacetHandlerFactoryMap.get(facetName);
            FacetHandlerInitializerParam data = req.getFacethandlerData(facetName);
            if (data == null) continue;
            Object facetHandler = factory.get(data);
            this._runtimeFacetHandlers.add((RuntimeFacetHandler<?>)facetHandler);
            try {
                this.setFacetHandler((FacetHandler<?>)facetHandler);
            }
            catch (IOException e) {
                logger.error((Object)("error trying to set FacetHandler : " + facetHandler + ":" + e.getMessage()), (Throwable)e);
            }
        }
        Set<String> fields = this.getFacetNames();
        LinkedList<Filter> preFilterList = new LinkedList<Filter>();
        LinkedList<FacetHitCollector> facetHitCollectorList = new LinkedList<FacetHitCollector>();
        Filter baseFilter = req.getFilter();
        if (baseFilter != null) {
            preFilterList.add(baseFilter);
        }
        int selCount = req.getSelectionCount();
        boolean isNoQueryNoFilter = this.isNoQueryNoFilter(req);
        boolean isDefaultSearch = isNoQueryNoFilter && selCount == 0;
        try {
            for (String name : fields) {
                BrowseSelection sel = req.getSelection(name);
                FacetSpec ospec = req.getFacetSpec(name);
                FacetHandler<?> handler = this.getFacetHandler(name);
                if (handler == null) {
                    logger.error((Object)("facet handler: " + name + " is not defined, ignored."));
                    continue;
                }
                FacetHitCollector facetHitCollector = null;
                RandomAccessFilter filter = null;
                if (sel != null) {
                    filter = handler.buildFilter(sel);
                }
                if (ospec == null) {
                    if (filter != null) {
                        preFilterList.add(filter);
                    }
                } else {
                    FacetSpec fspec = ospec;
                    facetHitCollector = new FacetHitCollector();
                    facetHitCollector.facetHandler = handler;
                    if (isDefaultSearch) {
                        facetHitCollector._collectAllSource = handler.getFacetCountCollectorSource(sel, fspec);
                    } else {
                        facetHitCollector._facetCountCollectorSource = handler.getFacetCountCollectorSource(sel, fspec);
                        if (ospec.isExpandSelection()) {
                            if (isNoQueryNoFilter && sel != null && selCount == 1) {
                                facetHitCollector._collectAllSource = handler.getFacetCountCollectorSource(sel, fspec);
                                if (filter != null) {
                                    preFilterList.add(filter);
                                }
                            } else if (filter != null) {
                                facetHitCollector._filter = filter;
                            }
                        } else if (filter != null) {
                            preFilterList.add(filter);
                        }
                    }
                }
                if (facetHitCollector == null) continue;
                facetHitCollectorList.add(facetHitCollector);
            }
            Object finalFilter = null;
            if (preFilterList.size() > 0) {
                finalFilter = preFilterList.size() == 1 ? (Filter)preFilterList.getFirst() : new AndFilter(preFilterList);
            }
            this.setFacetHitCollectorList(facetHitCollectorList);
            try {
                if (weight == null) {
                    Query q = req.getQuery();
                    if (q == null) {
                        q = new MatchAllDocsQuery();
                    }
                    weight = this.createWeight(q);
                }
                this.search(weight, (Filter)finalFilter, collector, start);
            }
            catch (Throwable throwable) {
                for (FacetHitCollector facetCollector : facetHitCollectorList) {
                    String name = facetCollector.facetHandler.getName();
                    LinkedList<FacetCountCollector> resultcollector = null;
                    resultcollector = facetCollector._countCollectorList;
                    if (resultcollector == null || resultcollector.size() == 0) {
                        resultcollector = facetCollector._collectAllCollectorList;
                    }
                    if (resultcollector == null) continue;
                    FacetSpec fspec = req.getFacetSpec(name);
                    assert (fspec != null);
                    if (resultcollector.size() == 1) {
                        facetMap.put(name, resultcollector.get(0));
                        continue;
                    }
                    ArrayList<FacetAccessible> finalList = new ArrayList<FacetAccessible>(resultcollector.size());
                    for (FacetCountCollector fc : resultcollector) {
                        finalList.add(fc);
                    }
                    CombinedFacetAccessible combinedCollector = new CombinedFacetAccessible(fspec, finalList);
                    facetMap.put(name, combinedCollector);
                }
                throw throwable;
            }
            for (FacetHitCollector facetCollector : facetHitCollectorList) {
                String name = facetCollector.facetHandler.getName();
                LinkedList<FacetCountCollector> resultcollector = null;
                resultcollector = facetCollector._countCollectorList;
                if (resultcollector == null || resultcollector.size() == 0) {
                    resultcollector = facetCollector._collectAllCollectorList;
                }
                if (resultcollector == null) continue;
                FacetSpec fspec = req.getFacetSpec(name);
                assert (fspec != null);
                if (resultcollector.size() == 1) {
                    facetMap.put(name, resultcollector.get(0));
                    continue;
                }
                ArrayList<FacetAccessible> finalList = new ArrayList<FacetAccessible>(resultcollector.size());
                for (FacetCountCollector fc : resultcollector) {
                    finalList.add(fc);
                }
                CombinedFacetAccessible combinedCollector = new CombinedFacetAccessible(fspec, finalList);
                facetMap.put(name, combinedCollector);
            }
        }
        catch (IOException ioe) {
            throw new BrowseException(ioe.getMessage(), ioe);
        }
    }

    @Override
    public SortCollector getSortCollector(SortField[] sort, Query q, int offset, int count, boolean fetchStoredFields, boolean forceScoring, String groupBy, int maxPerGroup, boolean collectDocIdCache) {
        return SortCollector.buildSortCollector(this, q, sort, offset, count, forceScoring, fetchStoredFields, groupBy, maxPerGroup, collectDocIdCache);
    }

    @Override
    public BrowseResult browse(BrowseRequest req) throws BrowseException {
        if (this._reader == null) {
            return new BrowseResult();
        }
        BrowseResult result = new BrowseResult();
        long start = System.currentTimeMillis();
        SortCollector collector = this.getSortCollector(req.getSort(), req.getQuery(), req.getOffset(), req.getCount(), req.isFetchStoredFields(), false, req.getGroupBy(), req.getMaxPerGroup(), req.getCollectDocIdCache());
        HashMap<String, FacetAccessible> facetCollectors = new HashMap<String, FacetAccessible>();
        this.browse(req, collector, facetCollectors);
        BrowseHit[] hits = null;
        try {
            hits = collector.topDocs();
        }
        catch (IOException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            hits = new BrowseHit[]{};
        }
        Query q = req.getQuery();
        if (q == null) {
            q = new MatchAllDocsQuery();
        }
        if (req.isShowExplanation()) {
            for (BrowseHit hit : hits) {
                try {
                    Explanation expl = this.explain(q, hit.getDocid());
                    hit.setExplanation(expl);
                }
                catch (IOException e) {
                    logger.error((Object)e.getMessage(), (Throwable)e);
                }
            }
        }
        result.setHits(hits);
        result.setNumHits(collector.getTotalHits());
        result.setNumGroups(collector.getTotalGroups());
        result.setGroupAccessible(collector.getGroupAccessible());
        result.setSortCollector(collector);
        result.setTotalDocs(this._reader.numDocs());
        result.addAll(facetCollectors);
        long end = System.currentTimeMillis();
        result.setTime(end - start);
        return result;
    }

    public Map<String, FacetHandler<?>> getRuntimeFacetHandlerMap() {
        return this._runtimeFacetHandlerMap;
    }

    @Override
    public int numDocs() {
        return this._reader.numDocs();
    }

    public Document doc(int docid) throws CorruptIndexException, IOException {
        Document doc = super.doc(docid);
        for (FacetHandler<?> handler : this._runtimeFacetHandlerMap.values()) {
            String[] vals;
            for (String val : vals = handler.getFieldValues(this._reader, docid)) {
                doc.add((Fieldable)new Field(handler.getName(), val, Field.Store.NO, Field.Index.NOT_ANALYZED));
            }
        }
        return doc;
    }

    @Override
    public String[] getFieldVal(int docid, final String fieldname) throws IOException {
        FacetHandler<?> facetHandler = this.getFacetHandler(fieldname);
        if (facetHandler != null) {
            return facetHandler.getFieldValues(this._reader, docid);
        }
        logger.warn((Object)("facet handler: " + fieldname + " not defined, looking at stored field."));
        Document doc = this._reader.document(docid, new FieldSelector(){
            private static final long serialVersionUID = 1L;

            public FieldSelectorResult accept(String field) {
                if (fieldname.equals(field)) {
                    return FieldSelectorResult.LOAD_AND_BREAK;
                }
                return FieldSelectorResult.NO_LOAD;
            }
        });
        return doc.getValues(fieldname);
    }

    @Override
    public void close() throws IOException {
        if (this._runtimeFacetHandlers != null) {
            for (RuntimeFacetHandler<?> handler : this._runtimeFacetHandlers) {
                handler.close();
            }
        }
        if (this._reader != null) {
            this._reader.clearRuntimeFacetData();
        }
        super.close();
    }
}

