/*
 * Decompiled with CFR 0.152.
 */
package com.browseengine.bobo.sort;

import com.browseengine.bobo.api.BoboIndexReader;
import com.browseengine.bobo.api.Browsable;
import com.browseengine.bobo.api.BrowseFacet;
import com.browseengine.bobo.api.BrowseHit;
import com.browseengine.bobo.api.FacetAccessible;
import com.browseengine.bobo.api.FacetSpec;
import com.browseengine.bobo.facets.CombinedFacetAccessible;
import com.browseengine.bobo.facets.FacetCountCollector;
import com.browseengine.bobo.facets.FacetHandler;
import com.browseengine.bobo.facets.data.FacetDataCache;
import com.browseengine.bobo.facets.impl.SimpleFacetHandler;
import com.browseengine.bobo.sort.DocComparator;
import com.browseengine.bobo.sort.DocComparatorSource;
import com.browseengine.bobo.sort.DocIDPriorityQueue;
import com.browseengine.bobo.sort.SortCollector;
import com.browseengine.bobo.util.ListMerger;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.search.ScoreDoc;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.search.SortField;

public class SortCollectorImpl
extends SortCollector {
    private static final Comparator<MyScoreDoc> MERGE_COMPATATOR = new Comparator<MyScoreDoc>(){

        @Override
        public int compare(MyScoreDoc o1, MyScoreDoc o2) {
            int v;
            Comparable s1 = o1.getValue();
            Comparable s2 = o2.getValue();
            int r = s1 == null ? (s2 == null ? 0 : -1) : (s2 == null ? 1 : ((v = s1.compareTo(s2)) == 0 ? o1.doc + o1.queue.base - o2.doc - o2.queue.base : v));
            return r;
        }
    };
    private final LinkedList<DocIDPriorityQueue> _pqList;
    private final int _numHits;
    private int _totalHits;
    private int _totalGroups;
    private ScoreDoc _bottom;
    private ScoreDoc _tmpScoreDoc;
    private boolean _queueFull;
    private DocComparator _currentComparator;
    private DocComparatorSource _compSource;
    private DocIDPriorityQueue _currentQueue;
    private BoboIndexReader _currentReader = null;
    private FacetCountCollector _facetCountCollector;
    private final boolean _doScoring;
    private Scorer _scorer;
    private final int _offset;
    private final int _count;
    private final Browsable _boboBrowser;
    private final FacetHandler<?> _groupBy;
    private CombinedFacetAccessible _groupAccessible;
    private final List<FacetAccessible> _facetAccessibles;
    private final Map<Integer, ScoreDoc> _currentValueDocMaps;

    public SortCollectorImpl(DocComparatorSource compSource, SortField[] sortFields, Browsable boboBrowser, int offset, int count, boolean doScoring, boolean fetchStoredFields, String groupBy) {
        super(sortFields, fetchStoredFields);
        assert (offset >= 0 && count >= 0);
        this._boboBrowser = boboBrowser;
        this._compSource = compSource;
        this._pqList = new LinkedList();
        this._numHits = offset + count;
        this._offset = offset;
        this._count = count;
        this._totalHits = 0;
        this._totalGroups = 0;
        this._queueFull = false;
        this._doScoring = doScoring;
        this._tmpScoreDoc = new MyScoreDoc();
        if (groupBy != null) {
            this._groupBy = boboBrowser.getFacetHandler(groupBy);
            if (this._groupBy != null && this._count > 0) {
                this._currentValueDocMaps = new HashMap<Integer, ScoreDoc>(this._count);
                this._facetAccessibles = new LinkedList<FacetAccessible>();
            } else {
                this._currentValueDocMaps = null;
                this._facetAccessibles = null;
            }
        } else {
            this._groupBy = null;
            this._currentValueDocMaps = null;
            this._facetAccessibles = null;
        }
    }

    public boolean acceptsDocsOutOfOrder() {
        return this._collector == null ? true : this._collector.acceptsDocsOutOfOrder();
    }

    public void collect(int doc) throws IOException {
        ++this._totalHits;
        if (this._groupBy != null) {
            if (this._facetCountCollector != null) {
                this._facetCountCollector.collect(doc);
            }
            if (this._count > 0) {
                float score = this._doScoring ? this._scorer.score() : 0.0f;
                this._tmpScoreDoc.doc = doc;
                this._tmpScoreDoc.score = score;
                if (!this._queueFull || this._currentComparator.compare(this._bottom, this._tmpScoreDoc) > 0) {
                    Integer order = ((FacetDataCache)this._groupBy.getFacetData((BoboIndexReader)this._currentReader)).orderArray.get(doc);
                    ScoreDoc pre = this._currentValueDocMaps.get(order);
                    if (pre != null) {
                        if (this._currentComparator.compare(pre, this._tmpScoreDoc) > 0) {
                            ScoreDoc tmp = pre;
                            this._bottom = this._currentQueue.replace(this._tmpScoreDoc, pre);
                            this._currentValueDocMaps.put(order, this._tmpScoreDoc);
                            this._tmpScoreDoc = tmp;
                        }
                    } else if (this._queueFull) {
                        MyScoreDoc tmp = (MyScoreDoc)this._bottom;
                        this._currentValueDocMaps.remove(((FacetDataCache)this._groupBy.getFacetData((BoboIndexReader)tmp.reader)).orderArray.get(tmp.doc));
                        this._bottom = this._currentQueue.replace(this._tmpScoreDoc);
                        this._currentValueDocMaps.put(order, this._tmpScoreDoc);
                        this._tmpScoreDoc = tmp;
                    } else {
                        MyScoreDoc tmp = new MyScoreDoc(doc, score, this._currentQueue, this._currentReader);
                        this._bottom = this._currentQueue.add(tmp);
                        this._currentValueDocMaps.put(order, tmp);
                        this._queueFull = this._currentQueue.size >= this._numHits;
                    }
                }
            }
        } else if (this._count > 0) {
            float score;
            float f = score = this._doScoring ? this._scorer.score() : 0.0f;
            if (this._queueFull) {
                this._tmpScoreDoc.doc = doc;
                this._tmpScoreDoc.score = score;
                if (this._currentComparator.compare(this._bottom, this._tmpScoreDoc) > 0) {
                    ScoreDoc tmp = this._bottom;
                    this._bottom = this._currentQueue.replace(this._tmpScoreDoc);
                    this._tmpScoreDoc = tmp;
                }
            } else {
                this._bottom = this._currentQueue.add(new MyScoreDoc(doc, score, this._currentQueue, this._currentReader));
                boolean bl = this._queueFull = this._currentQueue.size >= this._numHits;
            }
        }
        if (this._collector != null) {
            this._collector.collect(doc);
        }
    }

    private void collectTotalGrous() {
        int[] count;
        if (this._facetCountCollector instanceof SimpleFacetHandler.SimpleGroupByFacetCountCollector) {
            this._totalGroups += ((SimpleFacetHandler.SimpleGroupByFacetCountCollector)this._facetCountCollector).getTotalGroups();
            return;
        }
        for (int c : count = this._facetCountCollector.getCountDistribution()) {
            if (c <= 0) continue;
            ++this._totalGroups;
        }
    }

    public void setNextReader(IndexReader reader, int docBase) throws IOException {
        assert (reader instanceof BoboIndexReader);
        this._currentReader = (BoboIndexReader)reader;
        this._currentComparator = this._compSource.getComparator(reader, docBase);
        this._currentQueue = new DocIDPriorityQueue(this._currentComparator, this._numHits, docBase);
        if (this._groupBy != null) {
            if (this._facetCountCollector != null) {
                this.collectTotalGrous();
            }
            this._facetCountCollector = this._groupBy instanceof SimpleFacetHandler ? ((SimpleFacetHandler)this._groupBy).getFacetCountCollectorSource(null, null, true).getFacetCountCollector(this._currentReader, docBase) : this._groupBy.getFacetCountCollectorSource(null, null).getFacetCountCollector(this._currentReader, docBase);
            if (this._facetAccessibles != null) {
                this._facetAccessibles.add(this._facetCountCollector);
            }
            if (this._currentValueDocMaps != null) {
                this._currentValueDocMaps.clear();
            }
        }
        MyScoreDoc myScoreDoc = (MyScoreDoc)this._tmpScoreDoc;
        myScoreDoc.queue = this._currentQueue;
        myScoreDoc.reader = this._currentReader;
        myScoreDoc.sortValue = null;
        this._pqList.add(this._currentQueue);
        this._queueFull = false;
    }

    public void setScorer(Scorer scorer) throws IOException {
        this._scorer = scorer;
        this._currentComparator.setScorer(scorer);
    }

    @Override
    public int getTotalHits() {
        return this._totalHits;
    }

    @Override
    public int getTotalGroups() {
        return this._totalGroups;
    }

    @Override
    public CombinedFacetAccessible getGroupAccessible() {
        return this._groupAccessible;
    }

    @Override
    public BrowseHit[] topDocs() throws IOException {
        ArrayList<MyScoreDoc> resList;
        ArrayList iterList = new ArrayList(this._pqList.size());
        for (DocIDPriorityQueue pq : this._pqList) {
            int count = pq.size();
            MyScoreDoc[] resList2 = new MyScoreDoc[count];
            for (int i = count - 1; i >= 0; --i) {
                resList2[i] = (MyScoreDoc)pq.pop();
            }
            iterList.add(Arrays.asList(resList2).iterator());
        }
        if (this._count > 0) {
            if (this._groupBy == null) {
                resList = ListMerger.mergeLists(this._offset, this._count, iterList, MERGE_COMPATATOR);
            } else {
                if (this._facetCountCollector != null) {
                    this.collectTotalGrous();
                    this._facetCountCollector = null;
                }
                this._groupAccessible = new CombinedFacetAccessible(new FacetSpec(), this._facetAccessibles);
                resList = new ArrayList(this._count);
                Iterator<MyScoreDoc> mergedIter = ListMerger.mergeLists(iterList, MERGE_COMPATATOR);
                HashSet<Object> groupSet = new HashSet<Object>(this._offset + this._count);
                int offsetLeft = this._offset;
                while (mergedIter.hasNext()) {
                    MyScoreDoc scoreDoc = mergedIter.next();
                    Object val = this._groupBy.getRawFieldValues(scoreDoc.reader, scoreDoc.doc)[0];
                    if (!groupSet.contains(val)) {
                        if (offsetLeft > 0) {
                            --offsetLeft;
                        } else {
                            resList.add(scoreDoc);
                        }
                        groupSet.add(val);
                    }
                    if (resList.size() < this._count) continue;
                    break;
                }
            }
        } else {
            resList = Collections.EMPTY_LIST;
        }
        Map<String, FacetHandler<?>> facetHandlerMap = this._boboBrowser.getFacetHandlerMap();
        return SortCollectorImpl.buildHits(resList.toArray(new MyScoreDoc[resList.size()]), this._sortFields, facetHandlerMap, this._fetchStoredFields, this._groupBy, this._groupAccessible);
    }

    protected static BrowseHit[] buildHits(MyScoreDoc[] scoreDocs, SortField[] sortFields, Map<String, FacetHandler<?>> facetHandlerMap, boolean fetchStoredFields, FacetHandler<?> groupBy, CombinedFacetAccessible groupAccessible) throws IOException {
        BrowseHit[] hits = new BrowseHit[scoreDocs.length];
        Collection<FacetHandler<?>> facetHandlers = facetHandlerMap.values();
        for (int i = scoreDocs.length - 1; i >= 0; --i) {
            MyScoreDoc fdoc = scoreDocs[i];
            BoboIndexReader reader = fdoc.reader;
            BrowseHit hit = new BrowseHit();
            if (fetchStoredFields) {
                hit.setStoredFields(reader.document(fdoc.doc));
            }
            HashMap<String, String[]> map = new HashMap<String, String[]>();
            HashMap<String, Object[]> rawMap = new HashMap<String, Object[]>();
            for (FacetHandler<?> facetHandler : facetHandlers) {
                map.put(facetHandler.getName(), facetHandler.getFieldValues(reader, fdoc.doc));
                rawMap.put(facetHandler.getName(), facetHandler.getRawFieldValues(reader, fdoc.doc));
            }
            hit.setFieldValues(map);
            hit.setRawFieldValues(rawMap);
            hit.setDocid(fdoc.doc + fdoc.queue.base);
            hit.setScore(fdoc.score);
            hit.setComparable(fdoc.getValue());
            if (groupBy != null) {
                hit.setGroupValue(hit.getField(groupBy.getName()));
                if (hit.getGroupValue() != null && groupAccessible != null) {
                    BrowseFacet facet = groupAccessible.getFacet(hit.getGroupValue());
                    hit.setGroupHitsCount(facet.getFacetValueHitCount());
                }
            }
            hits[i] = hit;
        }
        return hits;
    }

    static class MyScoreDoc
    extends ScoreDoc {
        private static final long serialVersionUID = 1L;
        DocIDPriorityQueue queue;
        BoboIndexReader reader;
        Comparable sortValue;

        public MyScoreDoc() {
            this(0, 0.0f, null, null);
        }

        public MyScoreDoc(int docid, float score, DocIDPriorityQueue queue, BoboIndexReader reader) {
            super(docid, score);
            this.queue = queue;
            this.reader = reader;
            this.sortValue = null;
        }

        Comparable getValue() {
            if (this.sortValue == null) {
                this.sortValue = this.queue.sortValue(this);
            }
            return this.sortValue;
        }
    }
}

