/*
 * Decompiled with CFR 0.152.
 */
package com.browseengine.bobo.facets.impl;

import com.browseengine.bobo.api.IntFacetIterator;
import java.util.List;
import java.util.NoSuchElementException;

public class CombinedIntFacetIterator
extends IntFacetIterator {
    public int facet;
    private final IntFacetPriorityQueue _queue = new IntFacetPriorityQueue();
    private List<IntFacetIterator> _iterators;

    private CombinedIntFacetIterator(int length) {
        this._queue.initialize(length);
    }

    public CombinedIntFacetIterator(List<IntFacetIterator> iterators) {
        this(iterators.size());
        this._iterators = iterators;
        for (IntFacetIterator iterator : iterators) {
            IntIteratorNode node = new IntIteratorNode(iterator);
            if (!node.fetch(1)) continue;
            this._queue.add(node);
        }
        this.facet = -1;
        this.count = 0;
    }

    public CombinedIntFacetIterator(List<IntFacetIterator> iterators, int minHits) {
        this(iterators.size());
        this._iterators = iterators;
        for (IntFacetIterator iterator : iterators) {
            IntIteratorNode node = new IntIteratorNode(iterator);
            if (!node.fetch(minHits)) continue;
            this._queue.add(node);
        }
        this.facet = -1;
        this.count = 0;
    }

    public String getFacet() {
        if (this.facet == -1) {
            return null;
        }
        return this.format(this.facet);
    }

    @Override
    public String format(int val) {
        return this._iterators.get(0).format(val);
    }

    @Override
    public String format(Object val) {
        return this._iterators.get(0).format(val);
    }

    public int getFacetCount() {
        return this.count;
    }

    @Override
    public String next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException("No more facets in this iteration");
        }
        IntIteratorNode node = this._queue.top();
        this.facet = node._curFacet;
        int next = -1;
        this.count = 0;
        while (this.hasNext()) {
            node = this._queue.top();
            next = node._curFacet;
            if (next != -1 && next != this.facet) {
                return this.format(this.facet);
            }
            this.count += node._curFacetCount;
            if (node.fetch(1)) {
                this._queue.updateTop();
                continue;
            }
            this._queue.pop();
        }
        return null;
    }

    public String next(int minHits) {
        int qsize = this._queue.size();
        if (qsize == 0) {
            this.facet = -1;
            this.count = 0;
            return null;
        }
        IntIteratorNode node = this._queue.top();
        this.facet = node._curFacet;
        this.count = node._curFacetCount;
        while (true) {
            if (node.fetch(minHits)) {
                node = this._queue.updateTop();
            } else {
                this._queue.pop();
                if (--qsize > 0) {
                    node = this._queue.top();
                } else {
                    if (this.count >= minHits) break;
                    this.facet = -1;
                    this.count = 0;
                    return null;
                }
            }
            int next = node._curFacet;
            if (next != this.facet) {
                if (this.count >= minHits) break;
                this.facet = next;
                this.count = node._curFacetCount;
                continue;
            }
            this.count += node._curFacetCount;
        }
        return this.format(this.facet);
    }

    @Override
    public boolean hasNext() {
        return this._queue.size() > 0;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("remove() method not supported for Facet Iterators");
    }

    @Override
    public int nextInt() {
        if (!this.hasNext()) {
            throw new NoSuchElementException("No more facets in this iteration");
        }
        IntIteratorNode node = this._queue.top();
        this.facet = node._curFacet;
        int next = -1;
        this.count = 0;
        while (this.hasNext()) {
            node = this._queue.top();
            next = node._curFacet;
            if (next != -1 && next != this.facet) {
                return this.facet;
            }
            this.count += node._curFacetCount;
            if (node.fetch(1)) {
                this._queue.updateTop();
                continue;
            }
            this._queue.pop();
        }
        return -1;
    }

    @Override
    public int nextInt(int minHits) {
        int qsize = this._queue.size();
        if (qsize == 0) {
            this.facet = -1;
            this.count = 0;
            return -1;
        }
        IntIteratorNode node = this._queue.top();
        this.facet = node._curFacet;
        this.count = node._curFacetCount;
        while (true) {
            if (node.fetch(minHits)) {
                node = this._queue.updateTop();
            } else {
                this._queue.pop();
                if (--qsize > 0) {
                    node = this._queue.top();
                } else {
                    if (this.count >= minHits) break;
                    this.facet = -1;
                    this.count = 0;
                    break;
                }
            }
            int next = node._curFacet;
            if (next != this.facet) {
                if (this.count >= minHits) break;
                this.facet = next;
                this.count = node._curFacetCount;
                continue;
            }
            this.count += node._curFacetCount;
        }
        return this.facet;
    }

    public static class IntFacetPriorityQueue {
        private int size;
        private int maxSize;
        protected IntIteratorNode[] heap;

        protected final void initialize(int maxSize) {
            this.size = 0;
            int heapSize = 0 == maxSize ? 2 : maxSize + 1;
            this.heap = new IntIteratorNode[heapSize];
            this.maxSize = maxSize;
        }

        public final void put(IntIteratorNode element) {
            ++this.size;
            this.heap[this.size] = element;
            this.upHeap();
        }

        public final IntIteratorNode add(IntIteratorNode element) {
            ++this.size;
            this.heap[this.size] = element;
            this.upHeap();
            return this.heap[1];
        }

        public boolean insert(IntIteratorNode element) {
            return this.insertWithOverflow(element) != element;
        }

        public IntIteratorNode insertWithOverflow(IntIteratorNode element) {
            if (this.size < this.maxSize) {
                this.put(element);
                return null;
            }
            if (this.size > 0 && element._curFacet >= this.heap[1]._curFacet) {
                IntIteratorNode ret = this.heap[1];
                this.heap[1] = element;
                this.adjustTop();
                return ret;
            }
            return element;
        }

        public final IntIteratorNode top() {
            return this.heap[1];
        }

        public final IntIteratorNode pop() {
            if (this.size > 0) {
                IntIteratorNode result = this.heap[1];
                this.heap[1] = this.heap[this.size];
                this.heap[this.size] = null;
                --this.size;
                this.downHeap();
                return result;
            }
            return null;
        }

        public final void adjustTop() {
            this.downHeap();
        }

        public final IntIteratorNode updateTop() {
            this.downHeap();
            return this.heap[1];
        }

        public final int size() {
            return this.size;
        }

        public final void clear() {
            for (int i = 0; i <= this.size; ++i) {
                this.heap[i] = null;
            }
            this.size = 0;
        }

        private final void upHeap() {
            int i = this.size;
            IntIteratorNode node = this.heap[i];
            for (int j = i >>> 1; j > 0 && node._curFacet < this.heap[j]._curFacet; j >>>= 1) {
                this.heap[i] = this.heap[j];
                i = j;
            }
            this.heap[i] = node;
        }

        private final void downHeap() {
            int i = 1;
            IntIteratorNode node = this.heap[i];
            int j = i << 1;
            int k = j + 1;
            if (k <= this.size && this.heap[k]._curFacet < this.heap[j]._curFacet) {
                j = k;
            }
            while (j <= this.size && this.heap[j]._curFacet < node._curFacet) {
                this.heap[i] = this.heap[j];
                i = j;
                k = (j = i << 1) + 1;
                if (k > this.size || this.heap[k]._curFacet >= this.heap[j]._curFacet) continue;
                j = k;
            }
            this.heap[i] = node;
        }
    }

    private static class IntIteratorNode {
        public IntFacetIterator _iterator;
        public int _curFacet;
        public int _curFacetCount;

        public IntIteratorNode(IntFacetIterator iterator) {
            this._iterator = iterator;
            this._curFacet = -1;
            this._curFacetCount = 0;
        }

        public boolean fetch(int minHits) {
            if (minHits > 0) {
                minHits = 1;
            }
            if ((this._curFacet = this._iterator.nextInt(minHits)) != -1) {
                this._curFacetCount = this._iterator.count;
                return true;
            }
            this._curFacet = -1;
            this._curFacetCount = 0;
            return false;
        }

        public String peek() {
            throw new UnsupportedOperationException();
        }
    }
}

