/*
 * Decompiled with CFR 0.152.
 */
package com.browseengine.bobo.api;

import com.browseengine.bobo.api.Browsable;
import com.browseengine.bobo.api.BrowseException;
import com.browseengine.bobo.api.BrowseFacet;
import com.browseengine.bobo.api.BrowseHit;
import com.browseengine.bobo.api.BrowseRequest;
import com.browseengine.bobo.api.BrowseResult;
import com.browseengine.bobo.api.FacetAccessible;
import com.browseengine.bobo.facets.FacetHandler;
import com.browseengine.bobo.sort.SortCollector;
import java.io.Closeable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;
import org.apache.lucene.search.Collector;
import org.apache.lucene.search.Explanation;
import org.apache.lucene.search.MatchAllDocsQuery;
import org.apache.lucene.search.MultiSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.Searchable;
import org.apache.lucene.search.Similarity;
import org.apache.lucene.search.SortField;
import org.apache.lucene.search.Weight;

public class MultiBoboBrowser
extends MultiSearcher
implements Browsable,
Closeable {
    private static Logger logger = Logger.getLogger(MultiBoboBrowser.class);
    protected final Browsable[] _subBrowsers;

    public MultiBoboBrowser(Browsable[] browsers) throws IOException {
        super((Searchable[])browsers);
        this._subBrowsers = browsers;
    }

    @Override
    public void browse(BrowseRequest req, Collector hc, Map<String, FacetAccessible> facetMap) throws BrowseException {
        this.browse(req, hc, facetMap, 0);
    }

    @Override
    public void browse(BrowseRequest req, Collector collector, Map<String, FacetAccessible> facetMap, int start) throws BrowseException {
        Weight w = null;
        try {
            Query q = req.getQuery();
            if (q == null) {
                q = new MatchAllDocsQuery();
            }
            w = this.createWeight(q);
        }
        catch (IOException ioe) {
            throw new BrowseException(ioe.getMessage(), ioe);
        }
        catch (RuntimeException e) {
            w = null;
        }
        this.browse(req, w, collector, facetMap, start);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void browse(BrowseRequest req, Weight weight, Collector hc, Map<String, FacetAccessible> facetMap, int start) throws BrowseException {
        Browsable[] browsers = this.getSubBrowsers();
        if (browsers == null || browsers.length == 0) {
            return;
        }
        int[] starts = this.getStarts();
        HashMap<String, ArrayList<FacetAccessible>> mergedMap = new HashMap<String, ArrayList<FacetAccessible>>();
        try {
            HashMap<String, FacetAccessible> facetColMap = new HashMap<String, FacetAccessible>();
            for (int i = 0; i < browsers.length; ++i) {
                try {
                    browsers[i].browse(req, weight, hc, facetColMap, start + starts[i]);
                    continue;
                }
                finally {
                    Set entries = facetColMap.entrySet();
                    for (Map.Entry entry : entries) {
                        String name = (String)entry.getKey();
                        FacetAccessible facetAccessor = (FacetAccessible)entry.getValue();
                        ArrayList<FacetAccessible> list = (ArrayList<FacetAccessible>)mergedMap.get(name);
                        if (list == null) {
                            list = new ArrayList<FacetAccessible>(browsers.length);
                            mergedMap.put(name, list);
                        }
                        list.add(facetAccessor);
                    }
                    facetColMap.clear();
                }
            }
        }
        finally {
            Set entries = mergedMap.entrySet();
            for (Map.Entry entry : entries) {
                String name = (String)entry.getKey();
                FacetHandler<?> handler = this.getFacetHandler(name);
                try {
                    List subList = (List)entry.getValue();
                    if (subList == null) continue;
                    FacetAccessible merged = handler.merge(req.getFacetSpec(name), subList);
                    facetMap.put(name, merged);
                }
                catch (Exception e) {
                    logger.error((Object)e.getMessage(), (Throwable)e);
                }
            }
        }
    }

    @Override
    public BrowseResult browse(BrowseRequest req) throws BrowseException {
        BrowseResult result = new BrowseResult();
        if (this._subBrowsers == null || this._subBrowsers.length == 0) {
            return result;
        }
        long start = System.currentTimeMillis();
        int offset = req.getOffset();
        int count = req.getCount();
        if (offset < 0 || count < 0) {
            throw new IllegalArgumentException("both offset and count must be > 0: " + offset + "/" + count);
        }
        SortCollector collector = this.getSortCollector(req.getSort(), req.getQuery(), offset, count, req.isFetchStoredFields(), false, req.getGroupBy());
        HashMap<String, FacetAccessible> facetCollectors = new HashMap<String, FacetAccessible>();
        this.browse(req, collector, facetCollectors);
        BrowseHit[] hits = null;
        try {
            hits = collector.topDocs();
        }
        catch (IOException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            hits = new BrowseHit[]{};
        }
        Query q = req.getQuery();
        if (q == null) {
            q = new MatchAllDocsQuery();
        }
        if (req.isShowExplanation()) {
            for (BrowseHit hit : hits) {
                try {
                    Explanation expl = this.explain(q, hit.getDocid());
                    hit.setExplanation(expl);
                }
                catch (IOException e) {
                    logger.error((Object)e.getMessage(), (Throwable)e);
                }
            }
        }
        result.setHits(hits);
        result.setNumHits(collector.getTotalHits());
        result.setNumGroups(collector.getTotalGroups());
        result.setGroupAccessible(collector.getGroupAccessible());
        result.setTotalDocs(this.numDocs());
        result.addAll(facetCollectors);
        long end = System.currentTimeMillis();
        result.setTime(end - start);
        result.setTid(req.getTid());
        return result;
    }

    @Override
    public String[] getFieldVal(int docid, String fieldname) throws IOException {
        int i = this.subSearcher(docid);
        Browsable browser = this.getSubBrowsers()[i];
        return browser.getFieldVal(this.subDoc(docid), fieldname);
    }

    @Override
    public Object[] getRawFieldVal(int docid, String fieldname) throws IOException {
        int i = this.subSearcher(docid);
        Browsable browser = this.getSubBrowsers()[i];
        return browser.getRawFieldVal(this.subDoc(docid), fieldname);
    }

    public Browsable[] getSubBrowsers() {
        return this._subBrowsers;
    }

    public int[] getStarts() {
        return super.getStarts();
    }

    public Browsable subBrowser(int docid) {
        return this.getSubBrowsers()[this.subSearcher(docid)];
    }

    @Override
    public void setSimilarity(Similarity similarity) {
        super.setSimilarity(similarity);
        for (Browsable subBrowser : this.getSubBrowsers()) {
            subBrowser.setSimilarity(similarity);
        }
    }

    @Override
    public int numDocs() {
        Browsable[] subBrowsers;
        int count = 0;
        for (Browsable subBrowser : subBrowsers = this.getSubBrowsers()) {
            count += subBrowser.numDocs();
        }
        return count;
    }

    @Override
    public Set<String> getFacetNames() {
        Browsable[] subBrowsers;
        HashSet<String> names = new HashSet<String>();
        for (Browsable subBrowser : subBrowsers = this.getSubBrowsers()) {
            names.addAll(subBrowser.getFacetNames());
        }
        return names;
    }

    @Override
    public FacetHandler<?> getFacetHandler(String name) {
        Browsable[] subBrowsers;
        for (Browsable subBrowser : subBrowsers = this.getSubBrowsers()) {
            FacetHandler<?> subHandler = subBrowser.getFacetHandler(name);
            if (subHandler == null) continue;
            return subHandler;
        }
        return null;
    }

    @Override
    public Map<String, FacetHandler<?>> getFacetHandlerMap() {
        Browsable[] subBrowsers;
        HashMap map = new HashMap();
        for (Browsable subBrowser : subBrowsers = this.getSubBrowsers()) {
            map.putAll(subBrowser.getFacetHandlerMap());
        }
        return map;
    }

    @Override
    public void setFacetHandler(FacetHandler<?> facetHandler) throws IOException {
        Browsable[] subBrowsers;
        for (Browsable subBrowser : subBrowsers = this.getSubBrowsers()) {
            subBrowser.setFacetHandler(facetHandler);
        }
    }

    @Override
    public SortCollector getSortCollector(SortField[] sort, Query q, int offset, int count, boolean fetchStoredFields, boolean forceScoring, String groupBy) {
        if (this._subBrowsers.length == 1) {
            return this._subBrowsers[0].getSortCollector(sort, q, offset, count, fetchStoredFields, forceScoring, groupBy);
        }
        return SortCollector.buildSortCollector(this, q, sort, offset, count, forceScoring, fetchStoredFields, groupBy);
    }

    @Override
    public void close() throws IOException {
        Browsable[] subBrowsers;
        for (Browsable subBrowser : subBrowsers = this.getSubBrowsers()) {
            subBrowser.close();
        }
    }

    public static class BrowseFacetValueComparator
    implements Comparator<BrowseFacet> {
        @Override
        public int compare(BrowseFacet o1, BrowseFacet o2) {
            return o1.getValue().compareTo(o2.getValue());
        }
    }
}

