/*
 * Decompiled with CFR 0.152.
 */
package com.box.sdk;

import com.box.sdk.BoxDateFormat;
import com.box.sdk.DateRange;
import com.box.sdk.SizeRange;
import com.eclipsesource.json.JsonObject;
import com.eclipsesource.json.JsonValue;

public class BoxMetadataFilter {
    private String templateKey;
    private String scope = "enterprise";
    private JsonObject filtersList = new JsonObject();

    public String getTemplateKey() {
        return this.templateKey;
    }

    public void setTemplateKey(String templateKey) {
        this.templateKey = templateKey;
    }

    public JsonObject getFiltersList() {
        return this.filtersList;
    }

    public void addFilter(String key, String value) {
        this.filtersList.add(key, value);
    }

    public void addNumberRangeFilter(String key, SizeRange sizeRange) {
        JsonObject opObj = new JsonObject();
        if (sizeRange.getLowerBoundBytes() != 0) {
            opObj.add("gt", sizeRange.getLowerBoundBytes());
        }
        if (sizeRange.getUpperBoundBytes() != 0) {
            opObj.add("lt", sizeRange.getUpperBoundBytes());
        }
        this.filtersList.add(key, (JsonValue)opObj);
    }

    public void addDateRangeFilter(String key, DateRange dateRange) {
        JsonObject opObj = new JsonObject();
        if (dateRange.getFromDate() != null) {
            String dateGtString = BoxDateFormat.format(dateRange.getFromDate());
            dateGtString = dateGtString.replaceAll("(\\+|-)(?!-\\|?!\\+)\\d+$", "Z");
            opObj.add("gt", dateGtString);
        }
        if (dateRange.getToDate() != null) {
            String dateLtString = BoxDateFormat.format(dateRange.getToDate());
            dateLtString = dateLtString.replaceAll("(\\+|-)(?!-\\|?!\\+)\\d+$", "Z");
            opObj.add("lt", dateLtString);
        }
        this.filtersList.add(key, (JsonValue)opObj);
    }

    public String getScope() {
        return this.scope;
    }

    public void setScope(String scope) {
        this.scope = scope;
    }
}

