/*
 * Decompiled with CFR 0.152.
 */
package com.box.sdkgen.managers.webhooks;

import com.box.sdkgen.internal.utils.Entry;
import com.box.sdkgen.internal.utils.UtilsManager;
import com.box.sdkgen.managers.webhooks.CreateWebhookHeaders;
import com.box.sdkgen.managers.webhooks.CreateWebhookRequestBody;
import com.box.sdkgen.managers.webhooks.DeleteWebhookByIdHeaders;
import com.box.sdkgen.managers.webhooks.GetWebhookByIdHeaders;
import com.box.sdkgen.managers.webhooks.GetWebhooksHeaders;
import com.box.sdkgen.managers.webhooks.GetWebhooksQueryParams;
import com.box.sdkgen.managers.webhooks.UpdateWebhookByIdHeaders;
import com.box.sdkgen.managers.webhooks.UpdateWebhookByIdRequestBody;
import com.box.sdkgen.networking.auth.Authentication;
import com.box.sdkgen.networking.fetchoptions.FetchOptions;
import com.box.sdkgen.networking.fetchoptions.ResponseFormat;
import com.box.sdkgen.networking.fetchresponse.FetchResponse;
import com.box.sdkgen.networking.network.NetworkSession;
import com.box.sdkgen.schemas.webhook.Webhook;
import com.box.sdkgen.schemas.webhooks.Webhooks;
import com.box.sdkgen.serialization.json.JsonManager;
import java.time.OffsetDateTime;
import java.util.Map;

public class WebhooksManager {
    public Authentication auth;
    public NetworkSession networkSession;

    public WebhooksManager() {
        this.networkSession = new NetworkSession();
    }

    protected WebhooksManager(Builder builder) {
        this.auth = builder.auth;
        this.networkSession = builder.networkSession;
    }

    public Webhooks getWebhooks() {
        return this.getWebhooks(new GetWebhooksQueryParams(), new GetWebhooksHeaders());
    }

    public Webhooks getWebhooks(GetWebhooksQueryParams queryParams) {
        return this.getWebhooks(queryParams, new GetWebhooksHeaders());
    }

    public Webhooks getWebhooks(GetWebhooksHeaders headers) {
        return this.getWebhooks(new GetWebhooksQueryParams(), headers);
    }

    public Webhooks getWebhooks(GetWebhooksQueryParams queryParams, GetWebhooksHeaders headers) {
        Map<String, String> queryParamsMap = UtilsManager.prepareParams(UtilsManager.mapOf(UtilsManager.entryOf("marker", UtilsManager.convertToString(queryParams.getMarker())), UtilsManager.entryOf("limit", UtilsManager.convertToString(queryParams.getLimit()))));
        Map<String, String> headersMap = UtilsManager.prepareParams(UtilsManager.mergeMaps(UtilsManager.mapOf(new Entry[0]), headers.getExtraHeaders()));
        FetchResponse response = this.networkSession.getNetworkClient().fetch(new FetchOptions.Builder(String.join((CharSequence)"", this.networkSession.getBaseUrls().getBaseUrl(), "/2.0/webhooks"), "GET").params(queryParamsMap).headers(headersMap).responseFormat(ResponseFormat.JSON).auth(this.auth).networkSession(this.networkSession).build());
        return JsonManager.deserialize(response.getData(), Webhooks.class);
    }

    public Webhook createWebhook(CreateWebhookRequestBody requestBody) {
        return this.createWebhook(requestBody, new CreateWebhookHeaders());
    }

    public Webhook createWebhook(CreateWebhookRequestBody requestBody, CreateWebhookHeaders headers) {
        Map<String, String> headersMap = UtilsManager.prepareParams(UtilsManager.mergeMaps(UtilsManager.mapOf(new Entry[0]), headers.getExtraHeaders()));
        FetchResponse response = this.networkSession.getNetworkClient().fetch(new FetchOptions.Builder(String.join((CharSequence)"", this.networkSession.getBaseUrls().getBaseUrl(), "/2.0/webhooks"), "POST").headers(headersMap).data(JsonManager.serialize(requestBody)).contentType("application/json").responseFormat(ResponseFormat.JSON).auth(this.auth).networkSession(this.networkSession).build());
        return JsonManager.deserialize(response.getData(), Webhook.class);
    }

    public Webhook getWebhookById(String webhookId) {
        return this.getWebhookById(webhookId, new GetWebhookByIdHeaders());
    }

    public Webhook getWebhookById(String webhookId, GetWebhookByIdHeaders headers) {
        Map<String, String> headersMap = UtilsManager.prepareParams(UtilsManager.mergeMaps(UtilsManager.mapOf(new Entry[0]), headers.getExtraHeaders()));
        FetchResponse response = this.networkSession.getNetworkClient().fetch(new FetchOptions.Builder(String.join((CharSequence)"", this.networkSession.getBaseUrls().getBaseUrl(), "/2.0/webhooks/", UtilsManager.convertToString(webhookId)), "GET").headers(headersMap).responseFormat(ResponseFormat.JSON).auth(this.auth).networkSession(this.networkSession).build());
        return JsonManager.deserialize(response.getData(), Webhook.class);
    }

    public Webhook updateWebhookById(String webhookId) {
        return this.updateWebhookById(webhookId, new UpdateWebhookByIdRequestBody(), new UpdateWebhookByIdHeaders());
    }

    public Webhook updateWebhookById(String webhookId, UpdateWebhookByIdRequestBody requestBody) {
        return this.updateWebhookById(webhookId, requestBody, new UpdateWebhookByIdHeaders());
    }

    public Webhook updateWebhookById(String webhookId, UpdateWebhookByIdHeaders headers) {
        return this.updateWebhookById(webhookId, new UpdateWebhookByIdRequestBody(), headers);
    }

    public Webhook updateWebhookById(String webhookId, UpdateWebhookByIdRequestBody requestBody, UpdateWebhookByIdHeaders headers) {
        Map<String, String> headersMap = UtilsManager.prepareParams(UtilsManager.mergeMaps(UtilsManager.mapOf(new Entry[0]), headers.getExtraHeaders()));
        FetchResponse response = this.networkSession.getNetworkClient().fetch(new FetchOptions.Builder(String.join((CharSequence)"", this.networkSession.getBaseUrls().getBaseUrl(), "/2.0/webhooks/", UtilsManager.convertToString(webhookId)), "PUT").headers(headersMap).data(JsonManager.serialize(requestBody)).contentType("application/json").responseFormat(ResponseFormat.JSON).auth(this.auth).networkSession(this.networkSession).build());
        return JsonManager.deserialize(response.getData(), Webhook.class);
    }

    public void deleteWebhookById(String webhookId) {
        this.deleteWebhookById(webhookId, new DeleteWebhookByIdHeaders());
    }

    public void deleteWebhookById(String webhookId, DeleteWebhookByIdHeaders headers) {
        Map<String, String> headersMap = UtilsManager.prepareParams(UtilsManager.mergeMaps(UtilsManager.mapOf(new Entry[0]), headers.getExtraHeaders()));
        FetchResponse response = this.networkSession.getNetworkClient().fetch(new FetchOptions.Builder(String.join((CharSequence)"", this.networkSession.getBaseUrls().getBaseUrl(), "/2.0/webhooks/", UtilsManager.convertToString(webhookId)), "DELETE").headers(headersMap).responseFormat(ResponseFormat.NO_CONTENT).auth(this.auth).networkSession(this.networkSession).build());
    }

    public static boolean validateMessage(String body, Map<String, String> headers, String primaryKey) {
        return WebhooksManager.validateMessage(body, headers, primaryKey, null, 600);
    }

    public static boolean validateMessage(String body, Map<String, String> headers, String primaryKey, String secondaryKey) {
        return WebhooksManager.validateMessage(body, headers, primaryKey, secondaryKey, 600);
    }

    public static boolean validateMessage(String body, Map<String, String> headers, String primaryKey, Integer maxAge) {
        return WebhooksManager.validateMessage(body, headers, primaryKey, null, maxAge);
    }

    public static boolean validateMessage(String body, Map<String, String> headers, String primaryKey, String secondaryKey, Integer maxAge) {
        OffsetDateTime deliveryTimestamp = UtilsManager.dateTimeFromString(headers.get("box-delivery-timestamp"));
        long currentEpoch = UtilsManager.getEpochTimeInSeconds();
        if (currentEpoch - (long)maxAge.intValue() > UtilsManager.dateTimeToEpochSeconds(deliveryTimestamp) || UtilsManager.dateTimeToEpochSeconds(deliveryTimestamp) > currentEpoch) {
            return false;
        }
        if (primaryKey != null && headers.get("box-signature-primary") != null && UtilsManager.compareSignatures(UtilsManager.computeWebhookSignature(body, headers, primaryKey, false), headers.get("box-signature-primary"))) {
            return true;
        }
        if (primaryKey != null && headers.get("box-signature-primary") != null && UtilsManager.compareSignatures(UtilsManager.computeWebhookSignature(body, headers, primaryKey, true), headers.get("box-signature-primary"))) {
            return true;
        }
        if (secondaryKey != null && headers.get("box-signature-secondary") != null && UtilsManager.compareSignatures(UtilsManager.computeWebhookSignature(body, headers, secondaryKey, false), headers.get("box-signature-secondary"))) {
            return true;
        }
        return secondaryKey != null && headers.get("box-signature-secondary") != null && UtilsManager.compareSignatures(UtilsManager.computeWebhookSignature(body, headers, secondaryKey, true), headers.get("box-signature-secondary"));
    }

    public Authentication getAuth() {
        return this.auth;
    }

    public NetworkSession getNetworkSession() {
        return this.networkSession;
    }

    public static class Builder {
        protected Authentication auth;
        protected NetworkSession networkSession = new NetworkSession();

        public Builder auth(Authentication auth) {
            this.auth = auth;
            return this;
        }

        public Builder networkSession(NetworkSession networkSession) {
            this.networkSession = networkSession;
            return this;
        }

        public WebhooksManager build() {
            return new WebhooksManager(this);
        }
    }
}

