/*
 * Decompiled with CFR 0.152.
 */
package com.box.sdkgen.managers.storagepolicyassignments;

import com.box.sdkgen.internal.utils.Entry;
import com.box.sdkgen.internal.utils.UtilsManager;
import com.box.sdkgen.managers.storagepolicyassignments.CreateStoragePolicyAssignmentHeaders;
import com.box.sdkgen.managers.storagepolicyassignments.CreateStoragePolicyAssignmentRequestBody;
import com.box.sdkgen.managers.storagepolicyassignments.DeleteStoragePolicyAssignmentByIdHeaders;
import com.box.sdkgen.managers.storagepolicyassignments.GetStoragePolicyAssignmentByIdHeaders;
import com.box.sdkgen.managers.storagepolicyassignments.GetStoragePolicyAssignmentsHeaders;
import com.box.sdkgen.managers.storagepolicyassignments.GetStoragePolicyAssignmentsQueryParams;
import com.box.sdkgen.managers.storagepolicyassignments.UpdateStoragePolicyAssignmentByIdHeaders;
import com.box.sdkgen.managers.storagepolicyassignments.UpdateStoragePolicyAssignmentByIdRequestBody;
import com.box.sdkgen.networking.auth.Authentication;
import com.box.sdkgen.networking.fetchoptions.FetchOptions;
import com.box.sdkgen.networking.fetchoptions.ResponseFormat;
import com.box.sdkgen.networking.fetchresponse.FetchResponse;
import com.box.sdkgen.networking.network.NetworkSession;
import com.box.sdkgen.schemas.storagepolicyassignment.StoragePolicyAssignment;
import com.box.sdkgen.schemas.storagepolicyassignments.StoragePolicyAssignments;
import com.box.sdkgen.serialization.json.JsonManager;
import java.util.Map;

public class StoragePolicyAssignmentsManager {
    public Authentication auth;
    public NetworkSession networkSession;

    public StoragePolicyAssignmentsManager() {
        this.networkSession = new NetworkSession();
    }

    protected StoragePolicyAssignmentsManager(Builder builder) {
        this.auth = builder.auth;
        this.networkSession = builder.networkSession;
    }

    public StoragePolicyAssignments getStoragePolicyAssignments(GetStoragePolicyAssignmentsQueryParams queryParams) {
        return this.getStoragePolicyAssignments(queryParams, new GetStoragePolicyAssignmentsHeaders());
    }

    public StoragePolicyAssignments getStoragePolicyAssignments(GetStoragePolicyAssignmentsQueryParams queryParams, GetStoragePolicyAssignmentsHeaders headers) {
        Map<String, String> queryParamsMap = UtilsManager.prepareParams(UtilsManager.mapOf(UtilsManager.entryOf("marker", UtilsManager.convertToString(queryParams.getMarker())), UtilsManager.entryOf("resolved_for_type", UtilsManager.convertToString(queryParams.getResolvedForType())), UtilsManager.entryOf("resolved_for_id", UtilsManager.convertToString(queryParams.getResolvedForId()))));
        Map<String, String> headersMap = UtilsManager.prepareParams(UtilsManager.mergeMaps(UtilsManager.mapOf(new Entry[0]), headers.getExtraHeaders()));
        FetchResponse response = this.networkSession.getNetworkClient().fetch(new FetchOptions.Builder(String.join((CharSequence)"", this.networkSession.getBaseUrls().getBaseUrl(), "/2.0/storage_policy_assignments"), "GET").params(queryParamsMap).headers(headersMap).responseFormat(ResponseFormat.JSON).auth(this.auth).networkSession(this.networkSession).build());
        return JsonManager.deserialize(response.getData(), StoragePolicyAssignments.class);
    }

    public StoragePolicyAssignment createStoragePolicyAssignment(CreateStoragePolicyAssignmentRequestBody requestBody) {
        return this.createStoragePolicyAssignment(requestBody, new CreateStoragePolicyAssignmentHeaders());
    }

    public StoragePolicyAssignment createStoragePolicyAssignment(CreateStoragePolicyAssignmentRequestBody requestBody, CreateStoragePolicyAssignmentHeaders headers) {
        Map<String, String> headersMap = UtilsManager.prepareParams(UtilsManager.mergeMaps(UtilsManager.mapOf(new Entry[0]), headers.getExtraHeaders()));
        FetchResponse response = this.networkSession.getNetworkClient().fetch(new FetchOptions.Builder(String.join((CharSequence)"", this.networkSession.getBaseUrls().getBaseUrl(), "/2.0/storage_policy_assignments"), "POST").headers(headersMap).data(JsonManager.serialize(requestBody)).contentType("application/json").responseFormat(ResponseFormat.JSON).auth(this.auth).networkSession(this.networkSession).build());
        return JsonManager.deserialize(response.getData(), StoragePolicyAssignment.class);
    }

    public StoragePolicyAssignment getStoragePolicyAssignmentById(String storagePolicyAssignmentId) {
        return this.getStoragePolicyAssignmentById(storagePolicyAssignmentId, new GetStoragePolicyAssignmentByIdHeaders());
    }

    public StoragePolicyAssignment getStoragePolicyAssignmentById(String storagePolicyAssignmentId, GetStoragePolicyAssignmentByIdHeaders headers) {
        Map<String, String> headersMap = UtilsManager.prepareParams(UtilsManager.mergeMaps(UtilsManager.mapOf(new Entry[0]), headers.getExtraHeaders()));
        FetchResponse response = this.networkSession.getNetworkClient().fetch(new FetchOptions.Builder(String.join((CharSequence)"", this.networkSession.getBaseUrls().getBaseUrl(), "/2.0/storage_policy_assignments/", UtilsManager.convertToString(storagePolicyAssignmentId)), "GET").headers(headersMap).responseFormat(ResponseFormat.JSON).auth(this.auth).networkSession(this.networkSession).build());
        return JsonManager.deserialize(response.getData(), StoragePolicyAssignment.class);
    }

    public StoragePolicyAssignment updateStoragePolicyAssignmentById(String storagePolicyAssignmentId, UpdateStoragePolicyAssignmentByIdRequestBody requestBody) {
        return this.updateStoragePolicyAssignmentById(storagePolicyAssignmentId, requestBody, new UpdateStoragePolicyAssignmentByIdHeaders());
    }

    public StoragePolicyAssignment updateStoragePolicyAssignmentById(String storagePolicyAssignmentId, UpdateStoragePolicyAssignmentByIdRequestBody requestBody, UpdateStoragePolicyAssignmentByIdHeaders headers) {
        Map<String, String> headersMap = UtilsManager.prepareParams(UtilsManager.mergeMaps(UtilsManager.mapOf(new Entry[0]), headers.getExtraHeaders()));
        FetchResponse response = this.networkSession.getNetworkClient().fetch(new FetchOptions.Builder(String.join((CharSequence)"", this.networkSession.getBaseUrls().getBaseUrl(), "/2.0/storage_policy_assignments/", UtilsManager.convertToString(storagePolicyAssignmentId)), "PUT").headers(headersMap).data(JsonManager.serialize(requestBody)).contentType("application/json").responseFormat(ResponseFormat.JSON).auth(this.auth).networkSession(this.networkSession).build());
        return JsonManager.deserialize(response.getData(), StoragePolicyAssignment.class);
    }

    public void deleteStoragePolicyAssignmentById(String storagePolicyAssignmentId) {
        this.deleteStoragePolicyAssignmentById(storagePolicyAssignmentId, new DeleteStoragePolicyAssignmentByIdHeaders());
    }

    public void deleteStoragePolicyAssignmentById(String storagePolicyAssignmentId, DeleteStoragePolicyAssignmentByIdHeaders headers) {
        Map<String, String> headersMap = UtilsManager.prepareParams(UtilsManager.mergeMaps(UtilsManager.mapOf(new Entry[0]), headers.getExtraHeaders()));
        FetchResponse response = this.networkSession.getNetworkClient().fetch(new FetchOptions.Builder(String.join((CharSequence)"", this.networkSession.getBaseUrls().getBaseUrl(), "/2.0/storage_policy_assignments/", UtilsManager.convertToString(storagePolicyAssignmentId)), "DELETE").headers(headersMap).responseFormat(ResponseFormat.NO_CONTENT).auth(this.auth).networkSession(this.networkSession).build());
    }

    public Authentication getAuth() {
        return this.auth;
    }

    public NetworkSession getNetworkSession() {
        return this.networkSession;
    }

    public static class Builder {
        protected Authentication auth;
        protected NetworkSession networkSession = new NetworkSession();

        public Builder auth(Authentication auth) {
            this.auth = auth;
            return this;
        }

        public Builder networkSession(NetworkSession networkSession) {
            this.networkSession = networkSession;
            return this;
        }

        public StoragePolicyAssignmentsManager build() {
            return new StoragePolicyAssignmentsManager(this);
        }
    }
}

