/*
 * Decompiled with CFR 0.152.
 */
package com.box.sdkgen.managers.legalholdpolicies;

import com.box.sdkgen.internal.utils.Entry;
import com.box.sdkgen.internal.utils.UtilsManager;
import com.box.sdkgen.managers.legalholdpolicies.CreateLegalHoldPolicyHeaders;
import com.box.sdkgen.managers.legalholdpolicies.CreateLegalHoldPolicyRequestBody;
import com.box.sdkgen.managers.legalholdpolicies.DeleteLegalHoldPolicyByIdHeaders;
import com.box.sdkgen.managers.legalholdpolicies.GetLegalHoldPoliciesHeaders;
import com.box.sdkgen.managers.legalholdpolicies.GetLegalHoldPoliciesQueryParams;
import com.box.sdkgen.managers.legalholdpolicies.GetLegalHoldPolicyByIdHeaders;
import com.box.sdkgen.managers.legalholdpolicies.UpdateLegalHoldPolicyByIdHeaders;
import com.box.sdkgen.managers.legalholdpolicies.UpdateLegalHoldPolicyByIdRequestBody;
import com.box.sdkgen.networking.auth.Authentication;
import com.box.sdkgen.networking.fetchoptions.FetchOptions;
import com.box.sdkgen.networking.fetchoptions.ResponseFormat;
import com.box.sdkgen.networking.fetchresponse.FetchResponse;
import com.box.sdkgen.networking.network.NetworkSession;
import com.box.sdkgen.schemas.legalholdpolicies.LegalHoldPolicies;
import com.box.sdkgen.schemas.legalholdpolicy.LegalHoldPolicy;
import com.box.sdkgen.serialization.json.JsonManager;
import java.util.Map;

public class LegalHoldPoliciesManager {
    public Authentication auth;
    public NetworkSession networkSession;

    public LegalHoldPoliciesManager() {
        this.networkSession = new NetworkSession();
    }

    protected LegalHoldPoliciesManager(Builder builder) {
        this.auth = builder.auth;
        this.networkSession = builder.networkSession;
    }

    public LegalHoldPolicies getLegalHoldPolicies() {
        return this.getLegalHoldPolicies(new GetLegalHoldPoliciesQueryParams(), new GetLegalHoldPoliciesHeaders());
    }

    public LegalHoldPolicies getLegalHoldPolicies(GetLegalHoldPoliciesQueryParams queryParams) {
        return this.getLegalHoldPolicies(queryParams, new GetLegalHoldPoliciesHeaders());
    }

    public LegalHoldPolicies getLegalHoldPolicies(GetLegalHoldPoliciesHeaders headers) {
        return this.getLegalHoldPolicies(new GetLegalHoldPoliciesQueryParams(), headers);
    }

    public LegalHoldPolicies getLegalHoldPolicies(GetLegalHoldPoliciesQueryParams queryParams, GetLegalHoldPoliciesHeaders headers) {
        Map<String, String> queryParamsMap = UtilsManager.prepareParams(UtilsManager.mapOf(UtilsManager.entryOf("policy_name", UtilsManager.convertToString(queryParams.getPolicyName())), UtilsManager.entryOf("fields", UtilsManager.convertToString(queryParams.getFields())), UtilsManager.entryOf("marker", UtilsManager.convertToString(queryParams.getMarker())), UtilsManager.entryOf("limit", UtilsManager.convertToString(queryParams.getLimit()))));
        Map<String, String> headersMap = UtilsManager.prepareParams(UtilsManager.mergeMaps(UtilsManager.mapOf(new Entry[0]), headers.getExtraHeaders()));
        FetchResponse response = this.networkSession.getNetworkClient().fetch(new FetchOptions.Builder(String.join((CharSequence)"", this.networkSession.getBaseUrls().getBaseUrl(), "/2.0/legal_hold_policies"), "GET").params(queryParamsMap).headers(headersMap).responseFormat(ResponseFormat.JSON).auth(this.auth).networkSession(this.networkSession).build());
        return JsonManager.deserialize(response.getData(), LegalHoldPolicies.class);
    }

    public LegalHoldPolicy createLegalHoldPolicy(CreateLegalHoldPolicyRequestBody requestBody) {
        return this.createLegalHoldPolicy(requestBody, new CreateLegalHoldPolicyHeaders());
    }

    public LegalHoldPolicy createLegalHoldPolicy(CreateLegalHoldPolicyRequestBody requestBody, CreateLegalHoldPolicyHeaders headers) {
        Map<String, String> headersMap = UtilsManager.prepareParams(UtilsManager.mergeMaps(UtilsManager.mapOf(new Entry[0]), headers.getExtraHeaders()));
        FetchResponse response = this.networkSession.getNetworkClient().fetch(new FetchOptions.Builder(String.join((CharSequence)"", this.networkSession.getBaseUrls().getBaseUrl(), "/2.0/legal_hold_policies"), "POST").headers(headersMap).data(JsonManager.serialize(requestBody)).contentType("application/json").responseFormat(ResponseFormat.JSON).auth(this.auth).networkSession(this.networkSession).build());
        return JsonManager.deserialize(response.getData(), LegalHoldPolicy.class);
    }

    public LegalHoldPolicy getLegalHoldPolicyById(String legalHoldPolicyId) {
        return this.getLegalHoldPolicyById(legalHoldPolicyId, new GetLegalHoldPolicyByIdHeaders());
    }

    public LegalHoldPolicy getLegalHoldPolicyById(String legalHoldPolicyId, GetLegalHoldPolicyByIdHeaders headers) {
        Map<String, String> headersMap = UtilsManager.prepareParams(UtilsManager.mergeMaps(UtilsManager.mapOf(new Entry[0]), headers.getExtraHeaders()));
        FetchResponse response = this.networkSession.getNetworkClient().fetch(new FetchOptions.Builder(String.join((CharSequence)"", this.networkSession.getBaseUrls().getBaseUrl(), "/2.0/legal_hold_policies/", UtilsManager.convertToString(legalHoldPolicyId)), "GET").headers(headersMap).responseFormat(ResponseFormat.JSON).auth(this.auth).networkSession(this.networkSession).build());
        return JsonManager.deserialize(response.getData(), LegalHoldPolicy.class);
    }

    public LegalHoldPolicy updateLegalHoldPolicyById(String legalHoldPolicyId) {
        return this.updateLegalHoldPolicyById(legalHoldPolicyId, new UpdateLegalHoldPolicyByIdRequestBody(), new UpdateLegalHoldPolicyByIdHeaders());
    }

    public LegalHoldPolicy updateLegalHoldPolicyById(String legalHoldPolicyId, UpdateLegalHoldPolicyByIdRequestBody requestBody) {
        return this.updateLegalHoldPolicyById(legalHoldPolicyId, requestBody, new UpdateLegalHoldPolicyByIdHeaders());
    }

    public LegalHoldPolicy updateLegalHoldPolicyById(String legalHoldPolicyId, UpdateLegalHoldPolicyByIdHeaders headers) {
        return this.updateLegalHoldPolicyById(legalHoldPolicyId, new UpdateLegalHoldPolicyByIdRequestBody(), headers);
    }

    public LegalHoldPolicy updateLegalHoldPolicyById(String legalHoldPolicyId, UpdateLegalHoldPolicyByIdRequestBody requestBody, UpdateLegalHoldPolicyByIdHeaders headers) {
        Map<String, String> headersMap = UtilsManager.prepareParams(UtilsManager.mergeMaps(UtilsManager.mapOf(new Entry[0]), headers.getExtraHeaders()));
        FetchResponse response = this.networkSession.getNetworkClient().fetch(new FetchOptions.Builder(String.join((CharSequence)"", this.networkSession.getBaseUrls().getBaseUrl(), "/2.0/legal_hold_policies/", UtilsManager.convertToString(legalHoldPolicyId)), "PUT").headers(headersMap).data(JsonManager.serialize(requestBody)).contentType("application/json").responseFormat(ResponseFormat.JSON).auth(this.auth).networkSession(this.networkSession).build());
        return JsonManager.deserialize(response.getData(), LegalHoldPolicy.class);
    }

    public void deleteLegalHoldPolicyById(String legalHoldPolicyId) {
        this.deleteLegalHoldPolicyById(legalHoldPolicyId, new DeleteLegalHoldPolicyByIdHeaders());
    }

    public void deleteLegalHoldPolicyById(String legalHoldPolicyId, DeleteLegalHoldPolicyByIdHeaders headers) {
        Map<String, String> headersMap = UtilsManager.prepareParams(UtilsManager.mergeMaps(UtilsManager.mapOf(new Entry[0]), headers.getExtraHeaders()));
        FetchResponse response = this.networkSession.getNetworkClient().fetch(new FetchOptions.Builder(String.join((CharSequence)"", this.networkSession.getBaseUrls().getBaseUrl(), "/2.0/legal_hold_policies/", UtilsManager.convertToString(legalHoldPolicyId)), "DELETE").headers(headersMap).responseFormat(ResponseFormat.NO_CONTENT).auth(this.auth).networkSession(this.networkSession).build());
    }

    public Authentication getAuth() {
        return this.auth;
    }

    public NetworkSession getNetworkSession() {
        return this.networkSession;
    }

    public static class Builder {
        protected Authentication auth;
        protected NetworkSession networkSession = new NetworkSession();

        public Builder auth(Authentication auth) {
            this.auth = auth;
            return this;
        }

        public Builder networkSession(NetworkSession networkSession) {
            this.networkSession = networkSession;
            return this;
        }

        public LegalHoldPoliciesManager build() {
            return new LegalHoldPoliciesManager(this);
        }
    }
}

