/*
 * Decompiled with CFR 0.152.
 */
package com.box.sdkgen.internal.utils;

import com.box.sdkgen.internal.utils.DefaultPrivateKeyDecryptor;
import com.box.sdkgen.internal.utils.JwtAlgorithm;
import com.box.sdkgen.internal.utils.PrivateKeyDecryptor;
import com.box.sdkgen.serialization.json.EnumWrapper;

public class JwtSignOptions {
    protected JwtAlgorithm algorithm;
    protected String audience;
    protected String issuer;
    protected String subject;
    protected String jwtid;
    protected String keyid;
    protected PrivateKeyDecryptor privateKeyDecryptor;

    public JwtSignOptions(JwtAlgorithm algorithm, String audience, String issuer, String subject, String jwtid, String keyid) {
        this(algorithm, audience, issuer, subject, jwtid, keyid, (PrivateKeyDecryptor)new DefaultPrivateKeyDecryptor());
    }

    public JwtSignOptions(EnumWrapper<JwtAlgorithm> algorithm, String audience, String issuer, String subject, String jwtid, String keyid) {
        this(algorithm, audience, issuer, subject, jwtid, keyid, (PrivateKeyDecryptor)new DefaultPrivateKeyDecryptor());
    }

    public JwtSignOptions(JwtAlgorithm algorithm, String audience, String issuer, String subject, String jwtid, String keyid, PrivateKeyDecryptor privateKeyDecryptor) {
        this.algorithm = algorithm;
        this.audience = audience;
        this.issuer = issuer;
        this.subject = subject;
        this.jwtid = jwtid;
        this.keyid = keyid;
        this.privateKeyDecryptor = privateKeyDecryptor;
    }

    public JwtSignOptions(EnumWrapper<JwtAlgorithm> algorithm, String audience, String issuer, String subject, String jwtid, String keyid, PrivateKeyDecryptor privateKeyDecryptor) {
        this.algorithm = algorithm.getEnumValue();
        this.audience = audience;
        this.issuer = issuer;
        this.subject = subject;
        this.jwtid = jwtid;
        this.keyid = keyid;
        this.privateKeyDecryptor = privateKeyDecryptor;
    }

    public JwtAlgorithm getAlgorithm() {
        return this.algorithm;
    }

    public String getAudience() {
        return this.audience;
    }

    public String getIssuer() {
        return this.issuer;
    }

    public String getSubject() {
        return this.subject;
    }

    public String getJwtid() {
        return this.jwtid;
    }

    public String getKeyid() {
        return this.keyid;
    }

    public PrivateKeyDecryptor getPrivateKeyDecryptor() {
        return this.privateKeyDecryptor;
    }
}

