/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.applicationinsights.implementation;

import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.SimpleResponse;
import com.azure.core.util.Context;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.applicationinsights.ApplicationInsightsManager;
import com.azure.resourcemanager.applicationinsights.fluent.WorkbooksClient;
import com.azure.resourcemanager.applicationinsights.fluent.models.WorkbookInner;
import com.azure.resourcemanager.applicationinsights.implementation.Utils;
import com.azure.resourcemanager.applicationinsights.implementation.WorkbookImpl;
import com.azure.resourcemanager.applicationinsights.models.CategoryType;
import com.azure.resourcemanager.applicationinsights.models.Workbook;
import com.azure.resourcemanager.applicationinsights.models.Workbooks;
import java.util.List;

public final class WorkbooksImpl
implements Workbooks {
    private static final ClientLogger LOGGER = new ClientLogger(WorkbooksImpl.class);
    private final WorkbooksClient innerClient;
    private final ApplicationInsightsManager serviceManager;

    public WorkbooksImpl(WorkbooksClient innerClient, ApplicationInsightsManager serviceManager) {
        this.innerClient = innerClient;
        this.serviceManager = serviceManager;
    }

    @Override
    public PagedIterable<Workbook> list(CategoryType category) {
        PagedIterable<WorkbookInner> inner = this.serviceClient().list(category);
        return Utils.mapPage(inner, inner1 -> new WorkbookImpl((WorkbookInner)((Object)inner1), this.manager()));
    }

    @Override
    public PagedIterable<Workbook> list(CategoryType category, List<String> tags, Boolean canFetchContent, Context context) {
        PagedIterable<WorkbookInner> inner = this.serviceClient().list(category, tags, canFetchContent, context);
        return Utils.mapPage(inner, inner1 -> new WorkbookImpl((WorkbookInner)((Object)inner1), this.manager()));
    }

    @Override
    public PagedIterable<Workbook> listByResourceGroup(String resourceGroupName, CategoryType category) {
        PagedIterable<WorkbookInner> inner = this.serviceClient().listByResourceGroup(resourceGroupName, category);
        return Utils.mapPage(inner, inner1 -> new WorkbookImpl((WorkbookInner)((Object)inner1), this.manager()));
    }

    @Override
    public PagedIterable<Workbook> listByResourceGroup(String resourceGroupName, CategoryType category, List<String> tags, String sourceId, Boolean canFetchContent, Context context) {
        PagedIterable<WorkbookInner> inner = this.serviceClient().listByResourceGroup(resourceGroupName, category, tags, sourceId, canFetchContent, context);
        return Utils.mapPage(inner, inner1 -> new WorkbookImpl((WorkbookInner)((Object)inner1), this.manager()));
    }

    @Override
    public Workbook getByResourceGroup(String resourceGroupName, String resourceName) {
        WorkbookInner inner = this.serviceClient().getByResourceGroup(resourceGroupName, resourceName);
        if (inner != null) {
            return new WorkbookImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public Response<Workbook> getByResourceGroupWithResponse(String resourceGroupName, String resourceName, Boolean canFetchContent, Context context) {
        Response<WorkbookInner> inner = this.serviceClient().getByResourceGroupWithResponse(resourceGroupName, resourceName, canFetchContent, context);
        if (inner != null) {
            return new SimpleResponse(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(), (Object)new WorkbookImpl((WorkbookInner)((Object)inner.getValue()), this.manager()));
        }
        return null;
    }

    @Override
    public void deleteByResourceGroup(String resourceGroupName, String resourceName) {
        this.serviceClient().delete(resourceGroupName, resourceName);
    }

    @Override
    public Response<Void> deleteWithResponse(String resourceGroupName, String resourceName, Context context) {
        return this.serviceClient().deleteWithResponse(resourceGroupName, resourceName, context);
    }

    @Override
    public PagedIterable<Workbook> revisionsList(String resourceGroupName, String resourceName) {
        PagedIterable<WorkbookInner> inner = this.serviceClient().revisionsList(resourceGroupName, resourceName);
        return Utils.mapPage(inner, inner1 -> new WorkbookImpl((WorkbookInner)((Object)inner1), this.manager()));
    }

    @Override
    public PagedIterable<Workbook> revisionsList(String resourceGroupName, String resourceName, Context context) {
        PagedIterable<WorkbookInner> inner = this.serviceClient().revisionsList(resourceGroupName, resourceName, context);
        return Utils.mapPage(inner, inner1 -> new WorkbookImpl((WorkbookInner)((Object)inner1), this.manager()));
    }

    @Override
    public Workbook revisionGet(String resourceGroupName, String resourceName, String revisionId) {
        WorkbookInner inner = this.serviceClient().revisionGet(resourceGroupName, resourceName, revisionId);
        if (inner != null) {
            return new WorkbookImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public Response<Workbook> revisionGetWithResponse(String resourceGroupName, String resourceName, String revisionId, Context context) {
        Response<WorkbookInner> inner = this.serviceClient().revisionGetWithResponse(resourceGroupName, resourceName, revisionId, context);
        if (inner != null) {
            return new SimpleResponse(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(), (Object)new WorkbookImpl((WorkbookInner)((Object)inner.getValue()), this.manager()));
        }
        return null;
    }

    @Override
    public Workbook getById(String id) {
        String resourceGroupName = Utils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String resourceName = Utils.getValueFromIdByName(id, "workbooks");
        if (resourceName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'workbooks'.", id)));
        }
        Boolean localCanFetchContent = null;
        return (Workbook)this.getByResourceGroupWithResponse(resourceGroupName, resourceName, localCanFetchContent, Context.NONE).getValue();
    }

    @Override
    public Response<Workbook> getByIdWithResponse(String id, Boolean canFetchContent, Context context) {
        String resourceGroupName = Utils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String resourceName = Utils.getValueFromIdByName(id, "workbooks");
        if (resourceName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'workbooks'.", id)));
        }
        return this.getByResourceGroupWithResponse(resourceGroupName, resourceName, canFetchContent, context);
    }

    @Override
    public void deleteById(String id) {
        String resourceGroupName = Utils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String resourceName = Utils.getValueFromIdByName(id, "workbooks");
        if (resourceName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'workbooks'.", id)));
        }
        this.deleteWithResponse(resourceGroupName, resourceName, Context.NONE);
    }

    @Override
    public Response<Void> deleteByIdWithResponse(String id, Context context) {
        String resourceGroupName = Utils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String resourceName = Utils.getValueFromIdByName(id, "workbooks");
        if (resourceName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'workbooks'.", id)));
        }
        return this.deleteWithResponse(resourceGroupName, resourceName, context);
    }

    private WorkbooksClient serviceClient() {
        return this.innerClient;
    }

    private ApplicationInsightsManager manager() {
        return this.serviceManager;
    }

    @Override
    public WorkbookImpl define(String name) {
        return new WorkbookImpl(name, this.manager());
    }
}

