/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.applicationinsights.implementation;

import com.azure.core.annotation.BodyParam;
import com.azure.core.annotation.Delete;
import com.azure.core.annotation.ExpectedResponses;
import com.azure.core.annotation.Get;
import com.azure.core.annotation.HeaderParam;
import com.azure.core.annotation.Headers;
import com.azure.core.annotation.Host;
import com.azure.core.annotation.HostParam;
import com.azure.core.annotation.Patch;
import com.azure.core.annotation.PathParam;
import com.azure.core.annotation.Post;
import com.azure.core.annotation.QueryParam;
import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceInterface;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.annotation.UnexpectedResponseExceptionType;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.rest.PagedFlux;
import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.PagedResponse;
import com.azure.core.http.rest.PagedResponseBase;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.RestProxy;
import com.azure.core.management.exception.ManagementException;
import com.azure.core.util.Context;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.serializer.SerializerAdapter;
import com.azure.resourcemanager.applicationinsights.fluent.WorkItemConfigurationsClient;
import com.azure.resourcemanager.applicationinsights.fluent.models.WorkItemConfigurationInner;
import com.azure.resourcemanager.applicationinsights.implementation.ApplicationInsightsManagementClientImpl;
import com.azure.resourcemanager.applicationinsights.models.WorkItemConfigurationErrorException;
import com.azure.resourcemanager.applicationinsights.models.WorkItemConfigurationsListResult;
import com.azure.resourcemanager.applicationinsights.models.WorkItemCreateConfiguration;
import reactor.core.publisher.Mono;

public final class WorkItemConfigurationsClientImpl
implements WorkItemConfigurationsClient {
    private final WorkItemConfigurationsService service;
    private final ApplicationInsightsManagementClientImpl client;

    WorkItemConfigurationsClientImpl(ApplicationInsightsManagementClientImpl client) {
        this.service = (WorkItemConfigurationsService)RestProxy.create(WorkItemConfigurationsService.class, (HttpPipeline)client.getHttpPipeline(), (SerializerAdapter)client.getSerializerAdapter());
        this.client = client;
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<WorkItemConfigurationInner>> listSinglePageAsync(String resourceGroupName, String resourceName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceName is required and cannot be null."));
        }
        String apiVersion = "2015-05-01";
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.list(this.client.getEndpoint(), resourceGroupName, "2015-05-01", this.client.getSubscriptionId(), resourceName, "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((WorkItemConfigurationsListResult)res.getValue()).value(), null, null)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<WorkItemConfigurationInner>> listSinglePageAsync(String resourceGroupName, String resourceName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceName is required and cannot be null."));
        }
        String apiVersion = "2015-05-01";
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.list(this.client.getEndpoint(), resourceGroupName, "2015-05-01", this.client.getSubscriptionId(), resourceName, "application/json", context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((WorkItemConfigurationsListResult)res.getValue()).value(), null, null));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    private PagedFlux<WorkItemConfigurationInner> listAsync(String resourceGroupName, String resourceName) {
        return new PagedFlux(() -> this.listSinglePageAsync(resourceGroupName, resourceName));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    private PagedFlux<WorkItemConfigurationInner> listAsync(String resourceGroupName, String resourceName, Context context) {
        return new PagedFlux(() -> this.listSinglePageAsync(resourceGroupName, resourceName, context));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<WorkItemConfigurationInner> list(String resourceGroupName, String resourceName) {
        return new PagedIterable(this.listAsync(resourceGroupName, resourceName));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<WorkItemConfigurationInner> list(String resourceGroupName, String resourceName, Context context) {
        return new PagedIterable(this.listAsync(resourceGroupName, resourceName, context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<WorkItemConfigurationInner>> createWithResponseAsync(String resourceGroupName, String resourceName, WorkItemCreateConfiguration workItemConfigurationProperties) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceName is required and cannot be null."));
        }
        if (workItemConfigurationProperties == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter workItemConfigurationProperties is required and cannot be null."));
        }
        workItemConfigurationProperties.validate();
        String apiVersion = "2015-05-01";
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.create(this.client.getEndpoint(), resourceGroupName, "2015-05-01", this.client.getSubscriptionId(), resourceName, workItemConfigurationProperties, "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<WorkItemConfigurationInner>> createWithResponseAsync(String resourceGroupName, String resourceName, WorkItemCreateConfiguration workItemConfigurationProperties, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceName is required and cannot be null."));
        }
        if (workItemConfigurationProperties == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter workItemConfigurationProperties is required and cannot be null."));
        }
        workItemConfigurationProperties.validate();
        String apiVersion = "2015-05-01";
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.create(this.client.getEndpoint(), resourceGroupName, "2015-05-01", this.client.getSubscriptionId(), resourceName, workItemConfigurationProperties, "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<WorkItemConfigurationInner> createAsync(String resourceGroupName, String resourceName, WorkItemCreateConfiguration workItemConfigurationProperties) {
        return this.createWithResponseAsync(resourceGroupName, resourceName, workItemConfigurationProperties).flatMap(res -> Mono.justOrEmpty((Object)((WorkItemConfigurationInner)res.getValue())));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public WorkItemConfigurationInner create(String resourceGroupName, String resourceName, WorkItemCreateConfiguration workItemConfigurationProperties) {
        return (WorkItemConfigurationInner)this.createAsync(resourceGroupName, resourceName, workItemConfigurationProperties).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<WorkItemConfigurationInner> createWithResponse(String resourceGroupName, String resourceName, WorkItemCreateConfiguration workItemConfigurationProperties, Context context) {
        return (Response)this.createWithResponseAsync(resourceGroupName, resourceName, workItemConfigurationProperties, context).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<WorkItemConfigurationInner>> getDefaultWithResponseAsync(String resourceGroupName, String resourceName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceName is required and cannot be null."));
        }
        String apiVersion = "2015-05-01";
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.getDefault(this.client.getEndpoint(), resourceGroupName, "2015-05-01", this.client.getSubscriptionId(), resourceName, "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<WorkItemConfigurationInner>> getDefaultWithResponseAsync(String resourceGroupName, String resourceName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceName is required and cannot be null."));
        }
        String apiVersion = "2015-05-01";
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.getDefault(this.client.getEndpoint(), resourceGroupName, "2015-05-01", this.client.getSubscriptionId(), resourceName, "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<WorkItemConfigurationInner> getDefaultAsync(String resourceGroupName, String resourceName) {
        return this.getDefaultWithResponseAsync(resourceGroupName, resourceName).flatMap(res -> Mono.justOrEmpty((Object)((WorkItemConfigurationInner)res.getValue())));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public WorkItemConfigurationInner getDefault(String resourceGroupName, String resourceName) {
        return (WorkItemConfigurationInner)this.getDefaultAsync(resourceGroupName, resourceName).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<WorkItemConfigurationInner> getDefaultWithResponse(String resourceGroupName, String resourceName, Context context) {
        return (Response)this.getDefaultWithResponseAsync(resourceGroupName, resourceName, context).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Void>> deleteWithResponseAsync(String resourceGroupName, String resourceName, String workItemConfigId) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceName is required and cannot be null."));
        }
        if (workItemConfigId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter workItemConfigId is required and cannot be null."));
        }
        String apiVersion = "2015-05-01";
        return FluxUtil.withContext(context -> this.service.delete(this.client.getEndpoint(), resourceGroupName, "2015-05-01", this.client.getSubscriptionId(), resourceName, workItemConfigId, (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Void>> deleteWithResponseAsync(String resourceGroupName, String resourceName, String workItemConfigId, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceName is required and cannot be null."));
        }
        if (workItemConfigId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter workItemConfigId is required and cannot be null."));
        }
        String apiVersion = "2015-05-01";
        context = this.client.mergeContext(context);
        return this.service.delete(this.client.getEndpoint(), resourceGroupName, "2015-05-01", this.client.getSubscriptionId(), resourceName, workItemConfigId, context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Void> deleteAsync(String resourceGroupName, String resourceName, String workItemConfigId) {
        return this.deleteWithResponseAsync(resourceGroupName, resourceName, workItemConfigId).flatMap(ignored -> Mono.empty());
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public void delete(String resourceGroupName, String resourceName, String workItemConfigId) {
        this.deleteAsync(resourceGroupName, resourceName, workItemConfigId).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Void> deleteWithResponse(String resourceGroupName, String resourceName, String workItemConfigId, Context context) {
        return (Response)this.deleteWithResponseAsync(resourceGroupName, resourceName, workItemConfigId, context).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<WorkItemConfigurationInner>> getItemWithResponseAsync(String resourceGroupName, String resourceName, String workItemConfigId) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceName is required and cannot be null."));
        }
        if (workItemConfigId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter workItemConfigId is required and cannot be null."));
        }
        String apiVersion = "2015-05-01";
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.getItem(this.client.getEndpoint(), resourceGroupName, "2015-05-01", this.client.getSubscriptionId(), resourceName, workItemConfigId, "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<WorkItemConfigurationInner>> getItemWithResponseAsync(String resourceGroupName, String resourceName, String workItemConfigId, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceName is required and cannot be null."));
        }
        if (workItemConfigId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter workItemConfigId is required and cannot be null."));
        }
        String apiVersion = "2015-05-01";
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.getItem(this.client.getEndpoint(), resourceGroupName, "2015-05-01", this.client.getSubscriptionId(), resourceName, workItemConfigId, "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<WorkItemConfigurationInner> getItemAsync(String resourceGroupName, String resourceName, String workItemConfigId) {
        return this.getItemWithResponseAsync(resourceGroupName, resourceName, workItemConfigId).flatMap(res -> Mono.justOrEmpty((Object)((WorkItemConfigurationInner)res.getValue())));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public WorkItemConfigurationInner getItem(String resourceGroupName, String resourceName, String workItemConfigId) {
        return (WorkItemConfigurationInner)this.getItemAsync(resourceGroupName, resourceName, workItemConfigId).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<WorkItemConfigurationInner> getItemWithResponse(String resourceGroupName, String resourceName, String workItemConfigId, Context context) {
        return (Response)this.getItemWithResponseAsync(resourceGroupName, resourceName, workItemConfigId, context).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<WorkItemConfigurationInner>> updateItemWithResponseAsync(String resourceGroupName, String resourceName, String workItemConfigId, WorkItemCreateConfiguration workItemConfigurationProperties) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceName is required and cannot be null."));
        }
        if (workItemConfigId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter workItemConfigId is required and cannot be null."));
        }
        if (workItemConfigurationProperties == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter workItemConfigurationProperties is required and cannot be null."));
        }
        workItemConfigurationProperties.validate();
        String apiVersion = "2015-05-01";
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.updateItem(this.client.getEndpoint(), resourceGroupName, "2015-05-01", this.client.getSubscriptionId(), resourceName, workItemConfigId, workItemConfigurationProperties, "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<WorkItemConfigurationInner>> updateItemWithResponseAsync(String resourceGroupName, String resourceName, String workItemConfigId, WorkItemCreateConfiguration workItemConfigurationProperties, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceName is required and cannot be null."));
        }
        if (workItemConfigId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter workItemConfigId is required and cannot be null."));
        }
        if (workItemConfigurationProperties == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter workItemConfigurationProperties is required and cannot be null."));
        }
        workItemConfigurationProperties.validate();
        String apiVersion = "2015-05-01";
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.updateItem(this.client.getEndpoint(), resourceGroupName, "2015-05-01", this.client.getSubscriptionId(), resourceName, workItemConfigId, workItemConfigurationProperties, "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<WorkItemConfigurationInner> updateItemAsync(String resourceGroupName, String resourceName, String workItemConfigId, WorkItemCreateConfiguration workItemConfigurationProperties) {
        return this.updateItemWithResponseAsync(resourceGroupName, resourceName, workItemConfigId, workItemConfigurationProperties).flatMap(res -> Mono.justOrEmpty((Object)((WorkItemConfigurationInner)res.getValue())));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public WorkItemConfigurationInner updateItem(String resourceGroupName, String resourceName, String workItemConfigId, WorkItemCreateConfiguration workItemConfigurationProperties) {
        return (WorkItemConfigurationInner)this.updateItemAsync(resourceGroupName, resourceName, workItemConfigId, workItemConfigurationProperties).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<WorkItemConfigurationInner> updateItemWithResponse(String resourceGroupName, String resourceName, String workItemConfigId, WorkItemCreateConfiguration workItemConfigurationProperties, Context context) {
        return (Response)this.updateItemWithResponseAsync(resourceGroupName, resourceName, workItemConfigId, workItemConfigurationProperties, context).block();
    }

    @Host(value="{$host}")
    @ServiceInterface(name="ApplicationInsightsM")
    private static interface WorkItemConfigurationsService {
        @Headers(value={"Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Insights/components/{resourceName}/WorkItemConfigs")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=WorkItemConfigurationErrorException.class)
        public Mono<Response<WorkItemConfigurationsListResult>> list(@HostParam(value="$host") String var1, @PathParam(value="resourceGroupName") String var2, @QueryParam(value="api-version") String var3, @PathParam(value="subscriptionId") String var4, @PathParam(value="resourceName") String var5, @HeaderParam(value="Accept") String var6, Context var7);

        @Headers(value={"Content-Type: application/json"})
        @Post(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Insights/components/{resourceName}/WorkItemConfigs")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<WorkItemConfigurationInner>> create(@HostParam(value="$host") String var1, @PathParam(value="resourceGroupName") String var2, @QueryParam(value="api-version") String var3, @PathParam(value="subscriptionId") String var4, @PathParam(value="resourceName") String var5, @BodyParam(value="application/json") WorkItemCreateConfiguration var6, @HeaderParam(value="Accept") String var7, Context var8);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Insights/components/{resourceName}/DefaultWorkItemConfig")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<WorkItemConfigurationInner>> getDefault(@HostParam(value="$host") String var1, @PathParam(value="resourceGroupName") String var2, @QueryParam(value="api-version") String var3, @PathParam(value="subscriptionId") String var4, @PathParam(value="resourceName") String var5, @HeaderParam(value="Accept") String var6, Context var7);

        @Headers(value={"Accept: application/json;q=0.9", "Content-Type: application/json"})
        @Delete(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Insights/components/{resourceName}/WorkItemConfigs/{workItemConfigId}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<Void>> delete(@HostParam(value="$host") String var1, @PathParam(value="resourceGroupName") String var2, @QueryParam(value="api-version") String var3, @PathParam(value="subscriptionId") String var4, @PathParam(value="resourceName") String var5, @PathParam(value="workItemConfigId") String var6, Context var7);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Insights/components/{resourceName}/WorkItemConfigs/{workItemConfigId}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<WorkItemConfigurationInner>> getItem(@HostParam(value="$host") String var1, @PathParam(value="resourceGroupName") String var2, @QueryParam(value="api-version") String var3, @PathParam(value="subscriptionId") String var4, @PathParam(value="resourceName") String var5, @PathParam(value="workItemConfigId") String var6, @HeaderParam(value="Accept") String var7, Context var8);

        @Headers(value={"Content-Type: application/json"})
        @Patch(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Insights/components/{resourceName}/WorkItemConfigs/{workItemConfigId}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<WorkItemConfigurationInner>> updateItem(@HostParam(value="$host") String var1, @PathParam(value="resourceGroupName") String var2, @QueryParam(value="api-version") String var3, @PathParam(value="subscriptionId") String var4, @PathParam(value="resourceName") String var5, @PathParam(value="workItemConfigId") String var6, @BodyParam(value="application/json") WorkItemCreateConfiguration var7, @HeaderParam(value="Accept") String var8, Context var9);
    }
}

