/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.applicationinsights.implementation;

import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.SimpleResponse;
import com.azure.core.util.Context;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.applicationinsights.ApplicationInsightsManager;
import com.azure.resourcemanager.applicationinsights.fluent.ComponentsClient;
import com.azure.resourcemanager.applicationinsights.fluent.models.ApplicationInsightsComponentInner;
import com.azure.resourcemanager.applicationinsights.fluent.models.ComponentPurgeResponseInner;
import com.azure.resourcemanager.applicationinsights.fluent.models.ComponentPurgeStatusResponseInner;
import com.azure.resourcemanager.applicationinsights.implementation.ApplicationInsightsComponentImpl;
import com.azure.resourcemanager.applicationinsights.implementation.ComponentPurgeResponseImpl;
import com.azure.resourcemanager.applicationinsights.implementation.ComponentPurgeStatusResponseImpl;
import com.azure.resourcemanager.applicationinsights.implementation.Utils;
import com.azure.resourcemanager.applicationinsights.models.ApplicationInsightsComponent;
import com.azure.resourcemanager.applicationinsights.models.ComponentPurgeBody;
import com.azure.resourcemanager.applicationinsights.models.ComponentPurgeResponse;
import com.azure.resourcemanager.applicationinsights.models.ComponentPurgeStatusResponse;
import com.azure.resourcemanager.applicationinsights.models.Components;

public final class ComponentsImpl
implements Components {
    private static final ClientLogger LOGGER = new ClientLogger(ComponentsImpl.class);
    private final ComponentsClient innerClient;
    private final ApplicationInsightsManager serviceManager;

    public ComponentsImpl(ComponentsClient innerClient, ApplicationInsightsManager serviceManager) {
        this.innerClient = innerClient;
        this.serviceManager = serviceManager;
    }

    @Override
    public PagedIterable<ApplicationInsightsComponent> list() {
        PagedIterable<ApplicationInsightsComponentInner> inner = this.serviceClient().list();
        return Utils.mapPage(inner, inner1 -> new ApplicationInsightsComponentImpl((ApplicationInsightsComponentInner)((Object)inner1), this.manager()));
    }

    @Override
    public PagedIterable<ApplicationInsightsComponent> list(Context context) {
        PagedIterable<ApplicationInsightsComponentInner> inner = this.serviceClient().list(context);
        return Utils.mapPage(inner, inner1 -> new ApplicationInsightsComponentImpl((ApplicationInsightsComponentInner)((Object)inner1), this.manager()));
    }

    @Override
    public PagedIterable<ApplicationInsightsComponent> listByResourceGroup(String resourceGroupName) {
        PagedIterable<ApplicationInsightsComponentInner> inner = this.serviceClient().listByResourceGroup(resourceGroupName);
        return Utils.mapPage(inner, inner1 -> new ApplicationInsightsComponentImpl((ApplicationInsightsComponentInner)((Object)inner1), this.manager()));
    }

    @Override
    public PagedIterable<ApplicationInsightsComponent> listByResourceGroup(String resourceGroupName, Context context) {
        PagedIterable<ApplicationInsightsComponentInner> inner = this.serviceClient().listByResourceGroup(resourceGroupName, context);
        return Utils.mapPage(inner, inner1 -> new ApplicationInsightsComponentImpl((ApplicationInsightsComponentInner)((Object)inner1), this.manager()));
    }

    @Override
    public void deleteByResourceGroup(String resourceGroupName, String resourceName) {
        this.serviceClient().delete(resourceGroupName, resourceName);
    }

    @Override
    public Response<Void> deleteWithResponse(String resourceGroupName, String resourceName, Context context) {
        return this.serviceClient().deleteWithResponse(resourceGroupName, resourceName, context);
    }

    @Override
    public ApplicationInsightsComponent getByResourceGroup(String resourceGroupName, String resourceName) {
        ApplicationInsightsComponentInner inner = this.serviceClient().getByResourceGroup(resourceGroupName, resourceName);
        if (inner != null) {
            return new ApplicationInsightsComponentImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public Response<ApplicationInsightsComponent> getByResourceGroupWithResponse(String resourceGroupName, String resourceName, Context context) {
        Response<ApplicationInsightsComponentInner> inner = this.serviceClient().getByResourceGroupWithResponse(resourceGroupName, resourceName, context);
        if (inner != null) {
            return new SimpleResponse(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(), (Object)new ApplicationInsightsComponentImpl((ApplicationInsightsComponentInner)((Object)inner.getValue()), this.manager()));
        }
        return null;
    }

    @Override
    public ComponentPurgeResponse purge(String resourceGroupName, String resourceName, ComponentPurgeBody body) {
        ComponentPurgeResponseInner inner = this.serviceClient().purge(resourceGroupName, resourceName, body);
        if (inner != null) {
            return new ComponentPurgeResponseImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public Response<ComponentPurgeResponse> purgeWithResponse(String resourceGroupName, String resourceName, ComponentPurgeBody body, Context context) {
        Response<ComponentPurgeResponseInner> inner = this.serviceClient().purgeWithResponse(resourceGroupName, resourceName, body, context);
        if (inner != null) {
            return new SimpleResponse(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(), (Object)new ComponentPurgeResponseImpl((ComponentPurgeResponseInner)inner.getValue(), this.manager()));
        }
        return null;
    }

    @Override
    public ComponentPurgeStatusResponse getPurgeStatus(String resourceGroupName, String resourceName, String purgeId) {
        ComponentPurgeStatusResponseInner inner = this.serviceClient().getPurgeStatus(resourceGroupName, resourceName, purgeId);
        if (inner != null) {
            return new ComponentPurgeStatusResponseImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public Response<ComponentPurgeStatusResponse> getPurgeStatusWithResponse(String resourceGroupName, String resourceName, String purgeId, Context context) {
        Response<ComponentPurgeStatusResponseInner> inner = this.serviceClient().getPurgeStatusWithResponse(resourceGroupName, resourceName, purgeId, context);
        if (inner != null) {
            return new SimpleResponse(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(), (Object)new ComponentPurgeStatusResponseImpl((ComponentPurgeStatusResponseInner)inner.getValue(), this.manager()));
        }
        return null;
    }

    @Override
    public ApplicationInsightsComponent getById(String id) {
        String resourceGroupName = Utils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String resourceName = Utils.getValueFromIdByName(id, "components");
        if (resourceName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'components'.", id)));
        }
        return (ApplicationInsightsComponent)this.getByResourceGroupWithResponse(resourceGroupName, resourceName, Context.NONE).getValue();
    }

    @Override
    public Response<ApplicationInsightsComponent> getByIdWithResponse(String id, Context context) {
        String resourceGroupName = Utils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String resourceName = Utils.getValueFromIdByName(id, "components");
        if (resourceName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'components'.", id)));
        }
        return this.getByResourceGroupWithResponse(resourceGroupName, resourceName, context);
    }

    @Override
    public void deleteById(String id) {
        String resourceGroupName = Utils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String resourceName = Utils.getValueFromIdByName(id, "components");
        if (resourceName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'components'.", id)));
        }
        this.deleteWithResponse(resourceGroupName, resourceName, Context.NONE);
    }

    @Override
    public Response<Void> deleteByIdWithResponse(String id, Context context) {
        String resourceGroupName = Utils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String resourceName = Utils.getValueFromIdByName(id, "components");
        if (resourceName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'components'.", id)));
        }
        return this.deleteWithResponse(resourceGroupName, resourceName, context);
    }

    private ComponentsClient serviceClient() {
        return this.innerClient;
    }

    private ApplicationInsightsManager manager() {
        return this.serviceManager;
    }

    @Override
    public ApplicationInsightsComponentImpl define(String name) {
        return new ApplicationInsightsComponentImpl(name, this.manager());
    }
}

