/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.applicationinsights.implementation;

import com.azure.core.annotation.BodyParam;
import com.azure.core.annotation.Delete;
import com.azure.core.annotation.ExpectedResponses;
import com.azure.core.annotation.Get;
import com.azure.core.annotation.HeaderParam;
import com.azure.core.annotation.Headers;
import com.azure.core.annotation.Host;
import com.azure.core.annotation.HostParam;
import com.azure.core.annotation.Patch;
import com.azure.core.annotation.PathParam;
import com.azure.core.annotation.Put;
import com.azure.core.annotation.QueryParam;
import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceInterface;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.annotation.UnexpectedResponseExceptionType;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.RestProxy;
import com.azure.core.management.exception.ManagementException;
import com.azure.core.util.Context;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.serializer.SerializerAdapter;
import com.azure.resourcemanager.applicationinsights.fluent.ComponentLinkedStorageAccountsOperationsClient;
import com.azure.resourcemanager.applicationinsights.fluent.models.ComponentLinkedStorageAccountsInner;
import com.azure.resourcemanager.applicationinsights.implementation.ApplicationInsightsManagementClientImpl;
import com.azure.resourcemanager.applicationinsights.models.ComponentLinkedStorageAccountsPatch;
import com.azure.resourcemanager.applicationinsights.models.StorageType;
import reactor.core.publisher.Mono;

public final class ComponentLinkedStorageAccountsOperationsClientImpl
implements ComponentLinkedStorageAccountsOperationsClient {
    private final ComponentLinkedStorageAccountsOperationsService service;
    private final ApplicationInsightsManagementClientImpl client;

    ComponentLinkedStorageAccountsOperationsClientImpl(ApplicationInsightsManagementClientImpl client) {
        this.service = (ComponentLinkedStorageAccountsOperationsService)RestProxy.create(ComponentLinkedStorageAccountsOperationsService.class, (HttpPipeline)client.getHttpPipeline(), (SerializerAdapter)client.getSerializerAdapter());
        this.client = client;
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<ComponentLinkedStorageAccountsInner>> getWithResponseAsync(String resourceGroupName, String resourceName, StorageType storageType) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceName is required and cannot be null."));
        }
        if (storageType == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter storageType is required and cannot be null."));
        }
        String apiVersion = "2020-03-01-preview";
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.get(this.client.getEndpoint(), resourceGroupName, "2020-03-01-preview", this.client.getSubscriptionId(), resourceName, storageType, "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<ComponentLinkedStorageAccountsInner>> getWithResponseAsync(String resourceGroupName, String resourceName, StorageType storageType, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceName is required and cannot be null."));
        }
        if (storageType == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter storageType is required and cannot be null."));
        }
        String apiVersion = "2020-03-01-preview";
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.get(this.client.getEndpoint(), resourceGroupName, "2020-03-01-preview", this.client.getSubscriptionId(), resourceName, storageType, "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<ComponentLinkedStorageAccountsInner> getAsync(String resourceGroupName, String resourceName, StorageType storageType) {
        return this.getWithResponseAsync(resourceGroupName, resourceName, storageType).flatMap(res -> Mono.justOrEmpty((Object)((Object)((ComponentLinkedStorageAccountsInner)((Object)((Object)res.getValue()))))));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public ComponentLinkedStorageAccountsInner get(String resourceGroupName, String resourceName, StorageType storageType) {
        return (ComponentLinkedStorageAccountsInner)((Object)this.getAsync(resourceGroupName, resourceName, storageType).block());
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<ComponentLinkedStorageAccountsInner> getWithResponse(String resourceGroupName, String resourceName, StorageType storageType, Context context) {
        return (Response)this.getWithResponseAsync(resourceGroupName, resourceName, storageType, context).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<ComponentLinkedStorageAccountsInner>> createAndUpdateWithResponseAsync(String resourceGroupName, String resourceName, StorageType storageType, ComponentLinkedStorageAccountsInner linkedStorageAccountsProperties) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceName is required and cannot be null."));
        }
        if (storageType == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter storageType is required and cannot be null."));
        }
        if (linkedStorageAccountsProperties == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter linkedStorageAccountsProperties is required and cannot be null."));
        }
        linkedStorageAccountsProperties.validate();
        String apiVersion = "2020-03-01-preview";
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.createAndUpdate(this.client.getEndpoint(), resourceGroupName, "2020-03-01-preview", this.client.getSubscriptionId(), resourceName, storageType, linkedStorageAccountsProperties, "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<ComponentLinkedStorageAccountsInner>> createAndUpdateWithResponseAsync(String resourceGroupName, String resourceName, StorageType storageType, ComponentLinkedStorageAccountsInner linkedStorageAccountsProperties, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceName is required and cannot be null."));
        }
        if (storageType == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter storageType is required and cannot be null."));
        }
        if (linkedStorageAccountsProperties == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter linkedStorageAccountsProperties is required and cannot be null."));
        }
        linkedStorageAccountsProperties.validate();
        String apiVersion = "2020-03-01-preview";
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.createAndUpdate(this.client.getEndpoint(), resourceGroupName, "2020-03-01-preview", this.client.getSubscriptionId(), resourceName, storageType, linkedStorageAccountsProperties, "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<ComponentLinkedStorageAccountsInner> createAndUpdateAsync(String resourceGroupName, String resourceName, StorageType storageType, ComponentLinkedStorageAccountsInner linkedStorageAccountsProperties) {
        return this.createAndUpdateWithResponseAsync(resourceGroupName, resourceName, storageType, linkedStorageAccountsProperties).flatMap(res -> Mono.justOrEmpty((Object)((Object)((ComponentLinkedStorageAccountsInner)((Object)((Object)res.getValue()))))));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public ComponentLinkedStorageAccountsInner createAndUpdate(String resourceGroupName, String resourceName, StorageType storageType, ComponentLinkedStorageAccountsInner linkedStorageAccountsProperties) {
        return (ComponentLinkedStorageAccountsInner)((Object)this.createAndUpdateAsync(resourceGroupName, resourceName, storageType, linkedStorageAccountsProperties).block());
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<ComponentLinkedStorageAccountsInner> createAndUpdateWithResponse(String resourceGroupName, String resourceName, StorageType storageType, ComponentLinkedStorageAccountsInner linkedStorageAccountsProperties, Context context) {
        return (Response)this.createAndUpdateWithResponseAsync(resourceGroupName, resourceName, storageType, linkedStorageAccountsProperties, context).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<ComponentLinkedStorageAccountsInner>> updateWithResponseAsync(String resourceGroupName, String resourceName, StorageType storageType, ComponentLinkedStorageAccountsPatch linkedStorageAccountsProperties) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceName is required and cannot be null."));
        }
        if (storageType == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter storageType is required and cannot be null."));
        }
        if (linkedStorageAccountsProperties == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter linkedStorageAccountsProperties is required and cannot be null."));
        }
        linkedStorageAccountsProperties.validate();
        String apiVersion = "2020-03-01-preview";
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.update(this.client.getEndpoint(), resourceGroupName, "2020-03-01-preview", this.client.getSubscriptionId(), resourceName, storageType, linkedStorageAccountsProperties, "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<ComponentLinkedStorageAccountsInner>> updateWithResponseAsync(String resourceGroupName, String resourceName, StorageType storageType, ComponentLinkedStorageAccountsPatch linkedStorageAccountsProperties, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceName is required and cannot be null."));
        }
        if (storageType == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter storageType is required and cannot be null."));
        }
        if (linkedStorageAccountsProperties == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter linkedStorageAccountsProperties is required and cannot be null."));
        }
        linkedStorageAccountsProperties.validate();
        String apiVersion = "2020-03-01-preview";
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.update(this.client.getEndpoint(), resourceGroupName, "2020-03-01-preview", this.client.getSubscriptionId(), resourceName, storageType, linkedStorageAccountsProperties, "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<ComponentLinkedStorageAccountsInner> updateAsync(String resourceGroupName, String resourceName, StorageType storageType, ComponentLinkedStorageAccountsPatch linkedStorageAccountsProperties) {
        return this.updateWithResponseAsync(resourceGroupName, resourceName, storageType, linkedStorageAccountsProperties).flatMap(res -> Mono.justOrEmpty((Object)((Object)((ComponentLinkedStorageAccountsInner)((Object)((Object)res.getValue()))))));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public ComponentLinkedStorageAccountsInner update(String resourceGroupName, String resourceName, StorageType storageType, ComponentLinkedStorageAccountsPatch linkedStorageAccountsProperties) {
        return (ComponentLinkedStorageAccountsInner)((Object)this.updateAsync(resourceGroupName, resourceName, storageType, linkedStorageAccountsProperties).block());
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<ComponentLinkedStorageAccountsInner> updateWithResponse(String resourceGroupName, String resourceName, StorageType storageType, ComponentLinkedStorageAccountsPatch linkedStorageAccountsProperties, Context context) {
        return (Response)this.updateWithResponseAsync(resourceGroupName, resourceName, storageType, linkedStorageAccountsProperties, context).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Void>> deleteWithResponseAsync(String resourceGroupName, String resourceName, StorageType storageType) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceName is required and cannot be null."));
        }
        if (storageType == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter storageType is required and cannot be null."));
        }
        String apiVersion = "2020-03-01-preview";
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.delete(this.client.getEndpoint(), resourceGroupName, "2020-03-01-preview", this.client.getSubscriptionId(), resourceName, storageType, "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Void>> deleteWithResponseAsync(String resourceGroupName, String resourceName, StorageType storageType, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceName is required and cannot be null."));
        }
        if (storageType == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter storageType is required and cannot be null."));
        }
        String apiVersion = "2020-03-01-preview";
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.delete(this.client.getEndpoint(), resourceGroupName, "2020-03-01-preview", this.client.getSubscriptionId(), resourceName, storageType, "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Void> deleteAsync(String resourceGroupName, String resourceName, StorageType storageType) {
        return this.deleteWithResponseAsync(resourceGroupName, resourceName, storageType).flatMap(ignored -> Mono.empty());
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public void delete(String resourceGroupName, String resourceName, StorageType storageType) {
        this.deleteAsync(resourceGroupName, resourceName, storageType).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Void> deleteWithResponse(String resourceGroupName, String resourceName, StorageType storageType, Context context) {
        return (Response)this.deleteWithResponseAsync(resourceGroupName, resourceName, storageType, context).block();
    }

    @Host(value="{$host}")
    @ServiceInterface(name="ApplicationInsightsM")
    private static interface ComponentLinkedStorageAccountsOperationsService {
        @Headers(value={"Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/microsoft.insights/components/{resourceName}/linkedStorageAccounts/{storageType}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<ComponentLinkedStorageAccountsInner>> get(@HostParam(value="$host") String var1, @PathParam(value="resourceGroupName") String var2, @QueryParam(value="api-version") String var3, @PathParam(value="subscriptionId") String var4, @PathParam(value="resourceName") String var5, @PathParam(value="storageType") StorageType var6, @HeaderParam(value="Accept") String var7, Context var8);

        @Headers(value={"Content-Type: application/json"})
        @Put(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/microsoft.insights/components/{resourceName}/linkedStorageAccounts/{storageType}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<ComponentLinkedStorageAccountsInner>> createAndUpdate(@HostParam(value="$host") String var1, @PathParam(value="resourceGroupName") String var2, @QueryParam(value="api-version") String var3, @PathParam(value="subscriptionId") String var4, @PathParam(value="resourceName") String var5, @PathParam(value="storageType") StorageType var6, @BodyParam(value="application/json") ComponentLinkedStorageAccountsInner var7, @HeaderParam(value="Accept") String var8, Context var9);

        @Headers(value={"Content-Type: application/json"})
        @Patch(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/microsoft.insights/components/{resourceName}/linkedStorageAccounts/{storageType}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<ComponentLinkedStorageAccountsInner>> update(@HostParam(value="$host") String var1, @PathParam(value="resourceGroupName") String var2, @QueryParam(value="api-version") String var3, @PathParam(value="subscriptionId") String var4, @PathParam(value="resourceName") String var5, @PathParam(value="storageType") StorageType var6, @BodyParam(value="application/json") ComponentLinkedStorageAccountsPatch var7, @HeaderParam(value="Accept") String var8, Context var9);

        @Headers(value={"Content-Type: application/json"})
        @Delete(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/microsoft.insights/components/{resourceName}/linkedStorageAccounts/{storageType}")
        @ExpectedResponses(value={200, 204})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<Void>> delete(@HostParam(value="$host") String var1, @PathParam(value="resourceGroupName") String var2, @QueryParam(value="api-version") String var3, @PathParam(value="subscriptionId") String var4, @PathParam(value="resourceName") String var5, @PathParam(value="storageType") StorageType var6, @HeaderParam(value="Accept") String var7, Context var8);
    }
}

