/*
 * Decompiled with CFR 0.152.
 */
package com.azure.storage.common.policy;

import com.azure.core.http.HttpPipelineCallContext;
import com.azure.core.http.HttpPipelineNextPolicy;
import com.azure.core.http.HttpPipelineNextSyncPolicy;
import com.azure.core.http.HttpPipelinePosition;
import com.azure.core.http.HttpResponse;
import com.azure.core.http.policy.HttpPipelinePolicy;
import com.azure.core.util.UrlBuilder;
import java.net.URL;
import java.time.Duration;
import reactor.core.publisher.Mono;

public final class ServiceTimeoutPolicy
implements HttpPipelinePolicy {
    private final boolean applyTimeout;
    private final String timeoutInSeconds;

    public ServiceTimeoutPolicy(Duration timeout) {
        if (timeout == null) {
            this.applyTimeout = false;
            this.timeoutInSeconds = null;
        } else {
            long tempTimeoutInSeconds = timeout.getSeconds();
            if (tempTimeoutInSeconds <= 0L) {
                this.applyTimeout = false;
                this.timeoutInSeconds = null;
            } else {
                this.applyTimeout = true;
                this.timeoutInSeconds = String.valueOf(tempTimeoutInSeconds);
            }
        }
    }

    public Mono<HttpResponse> process(HttpPipelineCallContext context, HttpPipelineNextPolicy next) {
        if (this.applyTimeout) {
            String httpRequest = ServiceTimeoutPolicy.setTimeoutParameter(context, this.timeoutInSeconds);
            context.getHttpRequest().setUrl(httpRequest);
        }
        return next.process();
    }

    public HttpResponse processSync(HttpPipelineCallContext context, HttpPipelineNextSyncPolicy next) {
        if (this.applyTimeout) {
            String httpRequest = ServiceTimeoutPolicy.setTimeoutParameter(context, this.timeoutInSeconds);
            context.getHttpRequest().setUrl(httpRequest);
        }
        return next.processSync();
    }

    static String setTimeoutParameter(HttpPipelineCallContext context, String timeoutInSeconds) {
        UrlBuilder urlBuilder = UrlBuilder.parse((URL)context.getHttpRequest().getUrl());
        urlBuilder.setQueryParameter("timeout", timeoutInSeconds);
        return urlBuilder.toString();
    }

    public HttpPipelinePosition getPipelinePosition() {
        return HttpPipelinePosition.PER_CALL;
    }
}

