/*
 * Decompiled with CFR 0.152.
 */
package com.azure.data.tables.models;

import com.azure.core.util.CoreUtils;
import com.azure.data.tables.models.TableServiceRetentionPolicy;
import com.azure.xml.XmlReader;
import com.azure.xml.XmlSerializable;
import com.azure.xml.XmlToken;
import com.azure.xml.XmlWriter;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;

public final class TableServiceLogging
implements XmlSerializable<TableServiceLogging> {
    private String analyticsVersion;
    private boolean deleteLogged;
    private boolean readLogged;
    private boolean writeLogged;
    private TableServiceRetentionPolicy retentionPolicy;

    public String getAnalyticsVersion() {
        return this.analyticsVersion;
    }

    public TableServiceLogging setAnalyticsVersion(String analyticsVersion) {
        this.analyticsVersion = analyticsVersion;
        return this;
    }

    public boolean isDeleteLogged() {
        return this.deleteLogged;
    }

    public TableServiceLogging setDeleteLogged(boolean deleteLogged) {
        this.deleteLogged = deleteLogged;
        return this;
    }

    public boolean isReadLogged() {
        return this.readLogged;
    }

    public TableServiceLogging setReadLogged(boolean readLogged) {
        this.readLogged = readLogged;
        return this;
    }

    public boolean isWriteLogged() {
        return this.writeLogged;
    }

    public TableServiceLogging setWriteLogged(boolean writeLogged) {
        this.writeLogged = writeLogged;
        return this;
    }

    public TableServiceRetentionPolicy getRetentionPolicy() {
        return this.retentionPolicy;
    }

    public TableServiceLogging setRetentionPolicy(TableServiceRetentionPolicy retentionPolicy) {
        this.retentionPolicy = retentionPolicy;
        return this;
    }

    public XmlWriter toXml(XmlWriter xmlWriter) throws XMLStreamException {
        return this.toXml(xmlWriter, null);
    }

    public XmlWriter toXml(XmlWriter xmlWriter, String rootElementName) throws XMLStreamException {
        rootElementName = CoreUtils.isNullOrEmpty((CharSequence)rootElementName) ? "Logging" : rootElementName;
        xmlWriter.writeStartElement(rootElementName);
        xmlWriter.writeStringElement("Version", this.analyticsVersion);
        xmlWriter.writeBooleanElement("Delete", this.deleteLogged);
        xmlWriter.writeBooleanElement("Read", this.readLogged);
        xmlWriter.writeBooleanElement("Write", this.writeLogged);
        xmlWriter.writeXml((XmlSerializable)this.retentionPolicy, "RetentionPolicy");
        return xmlWriter.writeEndElement();
    }

    public static TableServiceLogging fromXml(XmlReader xmlReader) throws XMLStreamException {
        return TableServiceLogging.fromXml(xmlReader, null);
    }

    public static TableServiceLogging fromXml(XmlReader xmlReader, String rootElementName) throws XMLStreamException {
        String finalRootElementName = CoreUtils.isNullOrEmpty((CharSequence)rootElementName) ? "Logging" : rootElementName;
        return (TableServiceLogging)xmlReader.readObject(finalRootElementName, reader -> {
            TableServiceLogging deserializedTableServiceLogging = new TableServiceLogging();
            while (reader.nextElement() != XmlToken.END_ELEMENT) {
                QName elementName = reader.getElementName();
                if ("Version".equals(elementName.getLocalPart())) {
                    deserializedTableServiceLogging.analyticsVersion = reader.getStringElement();
                    continue;
                }
                if ("Delete".equals(elementName.getLocalPart())) {
                    deserializedTableServiceLogging.deleteLogged = reader.getBooleanElement();
                    continue;
                }
                if ("Read".equals(elementName.getLocalPart())) {
                    deserializedTableServiceLogging.readLogged = reader.getBooleanElement();
                    continue;
                }
                if ("Write".equals(elementName.getLocalPart())) {
                    deserializedTableServiceLogging.writeLogged = reader.getBooleanElement();
                    continue;
                }
                if ("RetentionPolicy".equals(elementName.getLocalPart())) {
                    deserializedTableServiceLogging.retentionPolicy = TableServiceRetentionPolicy.fromXml(reader, "RetentionPolicy");
                    continue;
                }
                reader.skipElement();
            }
            return deserializedTableServiceLogging;
        });
    }
}

