// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.data.tables.implementation.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * Table service OData error.
 */
@Fluent
public final class TableServiceOdataError implements JsonSerializable<TableServiceOdataError> {
    /*
     * The service error code.
     */
    private String code;

    /*
     * The service error message.
     */
    private TableServiceOdataErrorMessage message;

    /**
     * Creates an instance of TableServiceOdataError class.
     */
    public TableServiceOdataError() {
    }

    /**
     * Get the code property: The service error code.
     * 
     * @return the code value.
     */
    public String getCode() {
        return this.code;
    }

    /**
     * Set the code property: The service error code.
     * 
     * @param code the code value to set.
     * @return the TableServiceOdataError object itself.
     */
    public TableServiceOdataError setCode(String code) {
        this.code = code;
        return this;
    }

    /**
     * Get the message property: The service error message.
     * 
     * @return the message value.
     */
    public TableServiceOdataErrorMessage getMessage() {
        return this.message;
    }

    /**
     * Set the message property: The service error message.
     * 
     * @param message the message value to set.
     * @return the TableServiceOdataError object itself.
     */
    public TableServiceOdataError setMessage(TableServiceOdataErrorMessage message) {
        this.message = message;
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("code", this.code);
        jsonWriter.writeJsonField("message", this.message);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of TableServiceOdataError from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of TableServiceOdataError if the JsonReader was pointing to an instance of it, or null if it
     * was pointing to JSON null.
     * @throws IOException If an error occurs while reading the TableServiceOdataError.
     */
    public static TableServiceOdataError fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            TableServiceOdataError deserializedTableServiceOdataError = new TableServiceOdataError();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("code".equals(fieldName)) {
                    deserializedTableServiceOdataError.code = reader.getString();
                } else if ("message".equals(fieldName)) {
                    deserializedTableServiceOdataError.message = TableServiceOdataErrorMessage.fromJson(reader);
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedTableServiceOdataError;
        });
    }
}
