/*
 * Decompiled with CFR 0.152.
 */
package com.android.ide.common.rendering.api;

import com.android.ide.common.rendering.api.ResourceValue;
import com.android.layoutlib.api.IResourceValue;
import com.android.layoutlib.api.IStyleResourceValue;
import com.android.resources.ResourceType;
import com.android.util.Pair;
import java.util.HashMap;

public final class StyleResourceValue
extends ResourceValue
implements IStyleResourceValue {
    private String mParentStyle = null;
    private HashMap<Pair<String, Boolean>, ResourceValue> mItems = new HashMap();

    public StyleResourceValue(ResourceType type, String name, boolean isFramework) {
        super(type, name, isFramework);
    }

    public StyleResourceValue(ResourceType type, String name, String parentStyle, boolean isFramework) {
        super(type, name, isFramework);
        this.mParentStyle = parentStyle;
    }

    @Override
    public String getParentStyle() {
        return this.mParentStyle;
    }

    @Deprecated
    public ResourceValue findValue(String name) {
        return this.mItems.get(Pair.of(name, this.isFramework()));
    }

    public ResourceValue findValue(String name, boolean isFrameworkAttr) {
        return this.mItems.get(Pair.of(name, isFrameworkAttr));
    }

    public void addValue(ResourceValue value, boolean isFrameworkAttr) {
        this.mItems.put(Pair.of(value.getName(), isFrameworkAttr), value);
    }

    @Override
    public void replaceWith(ResourceValue value) {
        assert (value instanceof StyleResourceValue);
        super.replaceWith(value);
        if (value instanceof StyleResourceValue) {
            this.mItems.clear();
            this.mItems.putAll(((StyleResourceValue)value).mItems);
        }
    }

    @Override
    @Deprecated
    public IResourceValue findItem(String name) {
        return this.mItems.get(name);
    }
}

