/*
 * Decompiled with CFR 0.152.
 */
package net.spy.memcached.util;

import java.util.HashMap;
import java.util.Map;
import net.spy.memcached.MemcachedNode;
import net.spy.memcached.util.KetamaNodeLocatorConfiguration;

public class DefaultKetamaNodeLocatorConfiguration
implements KetamaNodeLocatorConfiguration {
    private final int numReps = 160;
    protected Map<MemcachedNode, String> socketAddresses = new HashMap<MemcachedNode, String>();

    protected String getSocketAddressForNode(MemcachedNode node) {
        String result = this.socketAddresses.get(node);
        if (result == null) {
            result = String.valueOf(node.getSocketAddress());
            if (result.startsWith("/")) {
                result = result.substring(1);
            }
            this.socketAddresses.put(node, result);
        }
        return result;
    }

    public int getNodeRepetitions() {
        return 160;
    }

    public String getKeyForNode(MemcachedNode node, int repetition) {
        return this.getSocketAddressForNode(node) + "-" + repetition;
    }
}

