/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.waf.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.protocol.json.SdkJsonProtocolFactory;
import com.amazonaws.protocol.json.StructuredJsonGenerator;
import com.amazonaws.services.waf.model.GetSampledRequestsRequest;
import com.amazonaws.services.waf.model.transform.TimeWindowJsonMarshaller;
import com.amazonaws.transform.Marshaller;
import java.io.ByteArrayInputStream;
import java.io.InputStream;

public class GetSampledRequestsRequestMarshaller
implements Marshaller<Request<GetSampledRequestsRequest>, GetSampledRequestsRequest> {
    private final SdkJsonProtocolFactory protocolFactory;

    public GetSampledRequestsRequestMarshaller(SdkJsonProtocolFactory protocolFactory) {
        this.protocolFactory = protocolFactory;
    }

    public Request<GetSampledRequestsRequest> marshall(GetSampledRequestsRequest getSampledRequestsRequest) {
        if (getSampledRequestsRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)getSampledRequestsRequest, "AWSWAF");
        request.addHeader("X-Amz-Target", "AWSWAF_20150824.GetSampledRequests");
        request.setHttpMethod(HttpMethodName.POST);
        request.setResourcePath("");
        try {
            StructuredJsonGenerator jsonGenerator = this.protocolFactory.createGenerator();
            jsonGenerator.writeStartObject();
            if (getSampledRequestsRequest.getWebAclId() != null) {
                jsonGenerator.writeFieldName("WebAclId").writeValue(getSampledRequestsRequest.getWebAclId());
            }
            if (getSampledRequestsRequest.getRuleId() != null) {
                jsonGenerator.writeFieldName("RuleId").writeValue(getSampledRequestsRequest.getRuleId());
            }
            if (getSampledRequestsRequest.getTimeWindow() != null) {
                jsonGenerator.writeFieldName("TimeWindow");
                TimeWindowJsonMarshaller.getInstance().marshall(getSampledRequestsRequest.getTimeWindow(), jsonGenerator);
            }
            if (getSampledRequestsRequest.getMaxItems() != null) {
                jsonGenerator.writeFieldName("MaxItems").writeValue(getSampledRequestsRequest.getMaxItems().longValue());
            }
            jsonGenerator.writeEndObject();
            byte[] content = jsonGenerator.getBytes();
            request.setContent((InputStream)new ByteArrayInputStream(content));
            request.addHeader("Content-Length", Integer.toString(content.length));
            request.addHeader("Content-Type", this.protocolFactory.getContentType());
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

