/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.s3control.model.transform;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.services.s3control.model.CreateAccessGrantsInstanceRequest;
import com.amazonaws.services.s3control.model.Tag;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringInputStream;
import com.amazonaws.util.StringUtils;
import com.amazonaws.util.XMLWriter;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.util.List;

public class CreateAccessGrantsInstanceRequestMarshaller
implements Marshaller<Request<CreateAccessGrantsInstanceRequest>, CreateAccessGrantsInstanceRequest> {
    public Request<CreateAccessGrantsInstanceRequest> marshall(CreateAccessGrantsInstanceRequest createAccessGrantsInstanceRequest) {
        if (createAccessGrantsInstanceRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)createAccessGrantsInstanceRequest, "AWSS3Control");
        request.setHttpMethod(HttpMethodName.POST);
        if (createAccessGrantsInstanceRequest.getAccountId() != null) {
            request.addHeader("x-amz-account-id", StringUtils.fromString((String)createAccessGrantsInstanceRequest.getAccountId()));
        }
        String uriResourcePath = "/v20180820/accessgrantsinstance";
        request.setResourcePath(uriResourcePath);
        try {
            StringWriter stringWriter = new StringWriter();
            XMLWriter xmlWriter = new XMLWriter((Writer)stringWriter, "http://awss3control.amazonaws.com/doc/2018-08-20/");
            xmlWriter.startElement("CreateAccessGrantsInstanceRequest");
            if (createAccessGrantsInstanceRequest != null) {
                List<Tag> createAccessGrantsInstanceRequestTagsList;
                if (createAccessGrantsInstanceRequest.getIdentityCenterArn() != null) {
                    xmlWriter.startElement("IdentityCenterArn").value(createAccessGrantsInstanceRequest.getIdentityCenterArn()).endElement();
                }
                if ((createAccessGrantsInstanceRequestTagsList = createAccessGrantsInstanceRequest.getTags()) != null) {
                    xmlWriter.startElement("Tags");
                    for (Tag createAccessGrantsInstanceRequestTagsListValue : createAccessGrantsInstanceRequestTagsList) {
                        xmlWriter.startElement("Tag");
                        if (createAccessGrantsInstanceRequestTagsListValue.getKey() != null) {
                            xmlWriter.startElement("Key").value(createAccessGrantsInstanceRequestTagsListValue.getKey()).endElement();
                        }
                        if (createAccessGrantsInstanceRequestTagsListValue.getValue() != null) {
                            xmlWriter.startElement("Value").value(createAccessGrantsInstanceRequestTagsListValue.getValue()).endElement();
                        }
                        xmlWriter.endElement();
                    }
                    xmlWriter.endElement();
                }
            }
            xmlWriter.endElement();
            request.setContent((InputStream)new StringInputStream(stringWriter.getBuffer().toString()));
            request.addHeader("Content-Length", Integer.toString(stringWriter.getBuffer().toString().getBytes(StringUtils.UTF8).length));
            if (!request.getHeaders().containsKey("Content-Type")) {
                request.addHeader("Content-Type", "application/xml");
            }
        }
        catch (Throwable t) {
            throw new SdkClientException("Unable to marshall request to XML: " + t.getMessage(), t);
        }
        return request;
    }
}

