/*
 * Copyright 2020-2025 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */
package com.amazonaws.services.route53recoveryreadiness;

import javax.annotation.Generated;

import com.amazonaws.services.route53recoveryreadiness.model.*;
import com.amazonaws.*;

/**
 * Abstract implementation of {@code AWSRoute53RecoveryReadiness}. Convenient method forms pass through to the
 * corresponding overload that takes a request object, which throws an {@code UnsupportedOperationException}.
 */
@Generated("com.amazonaws:aws-java-sdk-code-generator")
public class AbstractAWSRoute53RecoveryReadiness implements AWSRoute53RecoveryReadiness {

    protected AbstractAWSRoute53RecoveryReadiness() {
    }

    @Override
    public CreateCellResult createCell(CreateCellRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public CreateCrossAccountAuthorizationResult createCrossAccountAuthorization(CreateCrossAccountAuthorizationRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public CreateReadinessCheckResult createReadinessCheck(CreateReadinessCheckRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public CreateRecoveryGroupResult createRecoveryGroup(CreateRecoveryGroupRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public CreateResourceSetResult createResourceSet(CreateResourceSetRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DeleteCellResult deleteCell(DeleteCellRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DeleteCrossAccountAuthorizationResult deleteCrossAccountAuthorization(DeleteCrossAccountAuthorizationRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DeleteReadinessCheckResult deleteReadinessCheck(DeleteReadinessCheckRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DeleteRecoveryGroupResult deleteRecoveryGroup(DeleteRecoveryGroupRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DeleteResourceSetResult deleteResourceSet(DeleteResourceSetRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public GetArchitectureRecommendationsResult getArchitectureRecommendations(GetArchitectureRecommendationsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public GetCellResult getCell(GetCellRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public GetCellReadinessSummaryResult getCellReadinessSummary(GetCellReadinessSummaryRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public GetReadinessCheckResult getReadinessCheck(GetReadinessCheckRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public GetReadinessCheckResourceStatusResult getReadinessCheckResourceStatus(GetReadinessCheckResourceStatusRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public GetReadinessCheckStatusResult getReadinessCheckStatus(GetReadinessCheckStatusRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public GetRecoveryGroupResult getRecoveryGroup(GetRecoveryGroupRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public GetRecoveryGroupReadinessSummaryResult getRecoveryGroupReadinessSummary(GetRecoveryGroupReadinessSummaryRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public GetResourceSetResult getResourceSet(GetResourceSetRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListCellsResult listCells(ListCellsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListCrossAccountAuthorizationsResult listCrossAccountAuthorizations(ListCrossAccountAuthorizationsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListReadinessChecksResult listReadinessChecks(ListReadinessChecksRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListRecoveryGroupsResult listRecoveryGroups(ListRecoveryGroupsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListResourceSetsResult listResourceSets(ListResourceSetsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListRulesResult listRules(ListRulesRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListTagsForResourcesResult listTagsForResources(ListTagsForResourcesRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public TagResourceResult tagResource(TagResourceRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public UntagResourceResult untagResource(UntagResourceRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public UpdateCellResult updateCell(UpdateCellRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public UpdateReadinessCheckResult updateReadinessCheck(UpdateReadinessCheckRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public UpdateRecoveryGroupResult updateRecoveryGroup(UpdateRecoveryGroupRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public UpdateResourceSetResult updateResourceSet(UpdateResourceSetRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public void shutdown() {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public com.amazonaws.ResponseMetadata getCachedResponseMetadata(com.amazonaws.AmazonWebServiceRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

}
