/*
 * Copyright 2020-2025 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */
package com.amazonaws.services.personalize.model;

import java.io.Serializable;
import javax.annotation.Generated;

import com.amazonaws.AmazonWebServiceRequest;

/**
 * 
 * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/personalize-2018-05-22/CreateCampaign" target="_top">AWS API
 *      Documentation</a>
 */
@Generated("com.amazonaws:aws-java-sdk-code-generator")
public class CreateCampaignRequest extends com.amazonaws.AmazonWebServiceRequest implements Serializable, Cloneable {

    /**
     * <p>
     * A name for the new campaign. The campaign name must be unique within your account.
     * </p>
     */
    private String name;
    /**
     * <p>
     * The Amazon Resource Name (ARN) of the trained model to deploy with the campaign. To specify the latest solution
     * version of your solution, specify the ARN of your <i>solution</i> in <code>SolutionArn/$LATEST</code> format. You
     * must use this format if you set <code>syncWithLatestSolutionVersion</code> to <code>True</code> in the <a
     * href="https://docs.aws.amazon.com/personalize/latest/dg/API_CampaignConfig.html">CampaignConfig</a>.
     * </p>
     * <p>
     * To deploy a model that isn't the latest solution version of your solution, specify the ARN of the solution
     * version.
     * </p>
     * <p>
     * For more information about automatic campaign updates, see <a href=
     * "https://docs.aws.amazon.com/personalize/latest/dg/campaigns.html#create-campaign-automatic-latest-sv-update"
     * >Enabling automatic campaign updates</a>.
     * </p>
     */
    private String solutionVersionArn;
    /**
     * <p>
     * Specifies the requested minimum provisioned transactions (recommendations) per second that Amazon Personalize
     * will support. A high <code>minProvisionedTPS</code> will increase your bill. We recommend starting with 1 for
     * <code>minProvisionedTPS</code> (the default). Track your usage using Amazon CloudWatch metrics, and increase the
     * <code>minProvisionedTPS</code> as necessary.
     * </p>
     */
    private Integer minProvisionedTPS;
    /**
     * <p>
     * The configuration details of a campaign.
     * </p>
     */
    private CampaignConfig campaignConfig;
    /**
     * <p>
     * A list of <a href="https://docs.aws.amazon.com/personalize/latest/dg/tagging-resources.html">tags</a> to apply to
     * the campaign.
     * </p>
     */
    private java.util.List<Tag> tags;

    /**
     * <p>
     * A name for the new campaign. The campaign name must be unique within your account.
     * </p>
     * 
     * @param name
     *        A name for the new campaign. The campaign name must be unique within your account.
     */

    public void setName(String name) {
        this.name = name;
    }

    /**
     * <p>
     * A name for the new campaign. The campaign name must be unique within your account.
     * </p>
     * 
     * @return A name for the new campaign. The campaign name must be unique within your account.
     */

    public String getName() {
        return this.name;
    }

    /**
     * <p>
     * A name for the new campaign. The campaign name must be unique within your account.
     * </p>
     * 
     * @param name
     *        A name for the new campaign. The campaign name must be unique within your account.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public CreateCampaignRequest withName(String name) {
        setName(name);
        return this;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the trained model to deploy with the campaign. To specify the latest solution
     * version of your solution, specify the ARN of your <i>solution</i> in <code>SolutionArn/$LATEST</code> format. You
     * must use this format if you set <code>syncWithLatestSolutionVersion</code> to <code>True</code> in the <a
     * href="https://docs.aws.amazon.com/personalize/latest/dg/API_CampaignConfig.html">CampaignConfig</a>.
     * </p>
     * <p>
     * To deploy a model that isn't the latest solution version of your solution, specify the ARN of the solution
     * version.
     * </p>
     * <p>
     * For more information about automatic campaign updates, see <a href=
     * "https://docs.aws.amazon.com/personalize/latest/dg/campaigns.html#create-campaign-automatic-latest-sv-update"
     * >Enabling automatic campaign updates</a>.
     * </p>
     * 
     * @param solutionVersionArn
     *        The Amazon Resource Name (ARN) of the trained model to deploy with the campaign. To specify the latest
     *        solution version of your solution, specify the ARN of your <i>solution</i> in
     *        <code>SolutionArn/$LATEST</code> format. You must use this format if you set
     *        <code>syncWithLatestSolutionVersion</code> to <code>True</code> in the <a
     *        href="https://docs.aws.amazon.com/personalize/latest/dg/API_CampaignConfig.html">CampaignConfig</a>. </p>
     *        <p>
     *        To deploy a model that isn't the latest solution version of your solution, specify the ARN of the solution
     *        version.
     *        </p>
     *        <p>
     *        For more information about automatic campaign updates, see <a href=
     *        "https://docs.aws.amazon.com/personalize/latest/dg/campaigns.html#create-campaign-automatic-latest-sv-update"
     *        >Enabling automatic campaign updates</a>.
     */

    public void setSolutionVersionArn(String solutionVersionArn) {
        this.solutionVersionArn = solutionVersionArn;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the trained model to deploy with the campaign. To specify the latest solution
     * version of your solution, specify the ARN of your <i>solution</i> in <code>SolutionArn/$LATEST</code> format. You
     * must use this format if you set <code>syncWithLatestSolutionVersion</code> to <code>True</code> in the <a
     * href="https://docs.aws.amazon.com/personalize/latest/dg/API_CampaignConfig.html">CampaignConfig</a>.
     * </p>
     * <p>
     * To deploy a model that isn't the latest solution version of your solution, specify the ARN of the solution
     * version.
     * </p>
     * <p>
     * For more information about automatic campaign updates, see <a href=
     * "https://docs.aws.amazon.com/personalize/latest/dg/campaigns.html#create-campaign-automatic-latest-sv-update"
     * >Enabling automatic campaign updates</a>.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the trained model to deploy with the campaign. To specify the latest
     *         solution version of your solution, specify the ARN of your <i>solution</i> in
     *         <code>SolutionArn/$LATEST</code> format. You must use this format if you set
     *         <code>syncWithLatestSolutionVersion</code> to <code>True</code> in the <a
     *         href="https://docs.aws.amazon.com/personalize/latest/dg/API_CampaignConfig.html">CampaignConfig</a>. </p>
     *         <p>
     *         To deploy a model that isn't the latest solution version of your solution, specify the ARN of the
     *         solution version.
     *         </p>
     *         <p>
     *         For more information about automatic campaign updates, see <a href=
     *         "https://docs.aws.amazon.com/personalize/latest/dg/campaigns.html#create-campaign-automatic-latest-sv-update"
     *         >Enabling automatic campaign updates</a>.
     */

    public String getSolutionVersionArn() {
        return this.solutionVersionArn;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the trained model to deploy with the campaign. To specify the latest solution
     * version of your solution, specify the ARN of your <i>solution</i> in <code>SolutionArn/$LATEST</code> format. You
     * must use this format if you set <code>syncWithLatestSolutionVersion</code> to <code>True</code> in the <a
     * href="https://docs.aws.amazon.com/personalize/latest/dg/API_CampaignConfig.html">CampaignConfig</a>.
     * </p>
     * <p>
     * To deploy a model that isn't the latest solution version of your solution, specify the ARN of the solution
     * version.
     * </p>
     * <p>
     * For more information about automatic campaign updates, see <a href=
     * "https://docs.aws.amazon.com/personalize/latest/dg/campaigns.html#create-campaign-automatic-latest-sv-update"
     * >Enabling automatic campaign updates</a>.
     * </p>
     * 
     * @param solutionVersionArn
     *        The Amazon Resource Name (ARN) of the trained model to deploy with the campaign. To specify the latest
     *        solution version of your solution, specify the ARN of your <i>solution</i> in
     *        <code>SolutionArn/$LATEST</code> format. You must use this format if you set
     *        <code>syncWithLatestSolutionVersion</code> to <code>True</code> in the <a
     *        href="https://docs.aws.amazon.com/personalize/latest/dg/API_CampaignConfig.html">CampaignConfig</a>. </p>
     *        <p>
     *        To deploy a model that isn't the latest solution version of your solution, specify the ARN of the solution
     *        version.
     *        </p>
     *        <p>
     *        For more information about automatic campaign updates, see <a href=
     *        "https://docs.aws.amazon.com/personalize/latest/dg/campaigns.html#create-campaign-automatic-latest-sv-update"
     *        >Enabling automatic campaign updates</a>.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public CreateCampaignRequest withSolutionVersionArn(String solutionVersionArn) {
        setSolutionVersionArn(solutionVersionArn);
        return this;
    }

    /**
     * <p>
     * Specifies the requested minimum provisioned transactions (recommendations) per second that Amazon Personalize
     * will support. A high <code>minProvisionedTPS</code> will increase your bill. We recommend starting with 1 for
     * <code>minProvisionedTPS</code> (the default). Track your usage using Amazon CloudWatch metrics, and increase the
     * <code>minProvisionedTPS</code> as necessary.
     * </p>
     * 
     * @param minProvisionedTPS
     *        Specifies the requested minimum provisioned transactions (recommendations) per second that Amazon
     *        Personalize will support. A high <code>minProvisionedTPS</code> will increase your bill. We recommend
     *        starting with 1 for <code>minProvisionedTPS</code> (the default). Track your usage using Amazon CloudWatch
     *        metrics, and increase the <code>minProvisionedTPS</code> as necessary.
     */

    public void setMinProvisionedTPS(Integer minProvisionedTPS) {
        this.minProvisionedTPS = minProvisionedTPS;
    }

    /**
     * <p>
     * Specifies the requested minimum provisioned transactions (recommendations) per second that Amazon Personalize
     * will support. A high <code>minProvisionedTPS</code> will increase your bill. We recommend starting with 1 for
     * <code>minProvisionedTPS</code> (the default). Track your usage using Amazon CloudWatch metrics, and increase the
     * <code>minProvisionedTPS</code> as necessary.
     * </p>
     * 
     * @return Specifies the requested minimum provisioned transactions (recommendations) per second that Amazon
     *         Personalize will support. A high <code>minProvisionedTPS</code> will increase your bill. We recommend
     *         starting with 1 for <code>minProvisionedTPS</code> (the default). Track your usage using Amazon
     *         CloudWatch metrics, and increase the <code>minProvisionedTPS</code> as necessary.
     */

    public Integer getMinProvisionedTPS() {
        return this.minProvisionedTPS;
    }

    /**
     * <p>
     * Specifies the requested minimum provisioned transactions (recommendations) per second that Amazon Personalize
     * will support. A high <code>minProvisionedTPS</code> will increase your bill. We recommend starting with 1 for
     * <code>minProvisionedTPS</code> (the default). Track your usage using Amazon CloudWatch metrics, and increase the
     * <code>minProvisionedTPS</code> as necessary.
     * </p>
     * 
     * @param minProvisionedTPS
     *        Specifies the requested minimum provisioned transactions (recommendations) per second that Amazon
     *        Personalize will support. A high <code>minProvisionedTPS</code> will increase your bill. We recommend
     *        starting with 1 for <code>minProvisionedTPS</code> (the default). Track your usage using Amazon CloudWatch
     *        metrics, and increase the <code>minProvisionedTPS</code> as necessary.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public CreateCampaignRequest withMinProvisionedTPS(Integer minProvisionedTPS) {
        setMinProvisionedTPS(minProvisionedTPS);
        return this;
    }

    /**
     * <p>
     * The configuration details of a campaign.
     * </p>
     * 
     * @param campaignConfig
     *        The configuration details of a campaign.
     */

    public void setCampaignConfig(CampaignConfig campaignConfig) {
        this.campaignConfig = campaignConfig;
    }

    /**
     * <p>
     * The configuration details of a campaign.
     * </p>
     * 
     * @return The configuration details of a campaign.
     */

    public CampaignConfig getCampaignConfig() {
        return this.campaignConfig;
    }

    /**
     * <p>
     * The configuration details of a campaign.
     * </p>
     * 
     * @param campaignConfig
     *        The configuration details of a campaign.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public CreateCampaignRequest withCampaignConfig(CampaignConfig campaignConfig) {
        setCampaignConfig(campaignConfig);
        return this;
    }

    /**
     * <p>
     * A list of <a href="https://docs.aws.amazon.com/personalize/latest/dg/tagging-resources.html">tags</a> to apply to
     * the campaign.
     * </p>
     * 
     * @return A list of <a href="https://docs.aws.amazon.com/personalize/latest/dg/tagging-resources.html">tags</a> to
     *         apply to the campaign.
     */

    public java.util.List<Tag> getTags() {
        return tags;
    }

    /**
     * <p>
     * A list of <a href="https://docs.aws.amazon.com/personalize/latest/dg/tagging-resources.html">tags</a> to apply to
     * the campaign.
     * </p>
     * 
     * @param tags
     *        A list of <a href="https://docs.aws.amazon.com/personalize/latest/dg/tagging-resources.html">tags</a> to
     *        apply to the campaign.
     */

    public void setTags(java.util.Collection<Tag> tags) {
        if (tags == null) {
            this.tags = null;
            return;
        }

        this.tags = new java.util.ArrayList<Tag>(tags);
    }

    /**
     * <p>
     * A list of <a href="https://docs.aws.amazon.com/personalize/latest/dg/tagging-resources.html">tags</a> to apply to
     * the campaign.
     * </p>
     * <p>
     * <b>NOTE:</b> This method appends the values to the existing list (if any). Use
     * {@link #setTags(java.util.Collection)} or {@link #withTags(java.util.Collection)} if you want to override the
     * existing values.
     * </p>
     * 
     * @param tags
     *        A list of <a href="https://docs.aws.amazon.com/personalize/latest/dg/tagging-resources.html">tags</a> to
     *        apply to the campaign.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public CreateCampaignRequest withTags(Tag... tags) {
        if (this.tags == null) {
            setTags(new java.util.ArrayList<Tag>(tags.length));
        }
        for (Tag ele : tags) {
            this.tags.add(ele);
        }
        return this;
    }

    /**
     * <p>
     * A list of <a href="https://docs.aws.amazon.com/personalize/latest/dg/tagging-resources.html">tags</a> to apply to
     * the campaign.
     * </p>
     * 
     * @param tags
     *        A list of <a href="https://docs.aws.amazon.com/personalize/latest/dg/tagging-resources.html">tags</a> to
     *        apply to the campaign.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public CreateCampaignRequest withTags(java.util.Collection<Tag> tags) {
        setTags(tags);
        return this;
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     *
     * @return A string representation of this object.
     *
     * @see java.lang.Object#toString()
     */
    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (getName() != null)
            sb.append("Name: ").append(getName()).append(",");
        if (getSolutionVersionArn() != null)
            sb.append("SolutionVersionArn: ").append(getSolutionVersionArn()).append(",");
        if (getMinProvisionedTPS() != null)
            sb.append("MinProvisionedTPS: ").append(getMinProvisionedTPS()).append(",");
        if (getCampaignConfig() != null)
            sb.append("CampaignConfig: ").append(getCampaignConfig()).append(",");
        if (getTags() != null)
            sb.append("Tags: ").append(getTags());
        sb.append("}");
        return sb.toString();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj)
            return true;
        if (obj == null)
            return false;

        if (obj instanceof CreateCampaignRequest == false)
            return false;
        CreateCampaignRequest other = (CreateCampaignRequest) obj;
        if (other.getName() == null ^ this.getName() == null)
            return false;
        if (other.getName() != null && other.getName().equals(this.getName()) == false)
            return false;
        if (other.getSolutionVersionArn() == null ^ this.getSolutionVersionArn() == null)
            return false;
        if (other.getSolutionVersionArn() != null && other.getSolutionVersionArn().equals(this.getSolutionVersionArn()) == false)
            return false;
        if (other.getMinProvisionedTPS() == null ^ this.getMinProvisionedTPS() == null)
            return false;
        if (other.getMinProvisionedTPS() != null && other.getMinProvisionedTPS().equals(this.getMinProvisionedTPS()) == false)
            return false;
        if (other.getCampaignConfig() == null ^ this.getCampaignConfig() == null)
            return false;
        if (other.getCampaignConfig() != null && other.getCampaignConfig().equals(this.getCampaignConfig()) == false)
            return false;
        if (other.getTags() == null ^ this.getTags() == null)
            return false;
        if (other.getTags() != null && other.getTags().equals(this.getTags()) == false)
            return false;
        return true;
    }

    @Override
    public int hashCode() {
        final int prime = 31;
        int hashCode = 1;

        hashCode = prime * hashCode + ((getName() == null) ? 0 : getName().hashCode());
        hashCode = prime * hashCode + ((getSolutionVersionArn() == null) ? 0 : getSolutionVersionArn().hashCode());
        hashCode = prime * hashCode + ((getMinProvisionedTPS() == null) ? 0 : getMinProvisionedTPS().hashCode());
        hashCode = prime * hashCode + ((getCampaignConfig() == null) ? 0 : getCampaignConfig().hashCode());
        hashCode = prime * hashCode + ((getTags() == null) ? 0 : getTags().hashCode());
        return hashCode;
    }

    @Override
    public CreateCampaignRequest clone() {
        return (CreateCampaignRequest) super.clone();
    }

}
