/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.personalize.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.personalize.model.SolutionConfig;
import java.util.Map;

@SdkInternalApi
public class SolutionConfigMarshaller {
    private static final MarshallingInfo<String> EVENTVALUETHRESHOLD_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("eventValueThreshold").build();
    private static final MarshallingInfo<StructuredPojo> HPOCONFIG_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("hpoConfig").build();
    private static final MarshallingInfo<Map> ALGORITHMHYPERPARAMETERS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.MAP).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("algorithmHyperParameters").build();
    private static final MarshallingInfo<Map> FEATURETRANSFORMATIONPARAMETERS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.MAP).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("featureTransformationParameters").build();
    private static final MarshallingInfo<StructuredPojo> AUTOMLCONFIG_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("autoMLConfig").build();
    private static final MarshallingInfo<StructuredPojo> OPTIMIZATIONOBJECTIVE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("optimizationObjective").build();
    private static final SolutionConfigMarshaller instance = new SolutionConfigMarshaller();

    public static SolutionConfigMarshaller getInstance() {
        return instance;
    }

    public void marshall(SolutionConfig solutionConfig, ProtocolMarshaller protocolMarshaller) {
        if (solutionConfig == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)solutionConfig.getEventValueThreshold(), EVENTVALUETHRESHOLD_BINDING);
            protocolMarshaller.marshall((Object)solutionConfig.getHpoConfig(), HPOCONFIG_BINDING);
            protocolMarshaller.marshall(solutionConfig.getAlgorithmHyperParameters(), ALGORITHMHYPERPARAMETERS_BINDING);
            protocolMarshaller.marshall(solutionConfig.getFeatureTransformationParameters(), FEATURETRANSFORMATIONPARAMETERS_BINDING);
            protocolMarshaller.marshall((Object)solutionConfig.getAutoMLConfig(), AUTOMLCONFIG_BINDING);
            protocolMarshaller.marshall((Object)solutionConfig.getOptimizationObjective(), OPTIMIZATIONOBJECTIVE_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

