/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.nimblestudio.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.nimblestudio.model.StreamingSessionStorageMode;
import com.amazonaws.services.nimblestudio.model.StreamingSessionStorageRoot;
import com.amazonaws.services.nimblestudio.model.transform.StreamConfigurationSessionStorageMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class StreamConfigurationSessionStorage
implements Serializable,
Cloneable,
StructuredPojo {
    private List<String> mode;
    private StreamingSessionStorageRoot root;

    public List<String> getMode() {
        return this.mode;
    }

    public void setMode(Collection<String> mode) {
        if (mode == null) {
            this.mode = null;
            return;
        }
        this.mode = new ArrayList<String>(mode);
    }

    public StreamConfigurationSessionStorage withMode(String ... mode) {
        if (this.mode == null) {
            this.setMode(new ArrayList<String>(mode.length));
        }
        for (String ele : mode) {
            this.mode.add(ele);
        }
        return this;
    }

    public StreamConfigurationSessionStorage withMode(Collection<String> mode) {
        this.setMode(mode);
        return this;
    }

    public StreamConfigurationSessionStorage withMode(StreamingSessionStorageMode ... mode) {
        ArrayList<String> modeCopy = new ArrayList<String>(mode.length);
        for (StreamingSessionStorageMode value : mode) {
            modeCopy.add(value.toString());
        }
        if (this.getMode() == null) {
            this.setMode(modeCopy);
        } else {
            this.getMode().addAll(modeCopy);
        }
        return this;
    }

    public void setRoot(StreamingSessionStorageRoot root) {
        this.root = root;
    }

    public StreamingSessionStorageRoot getRoot() {
        return this.root;
    }

    public StreamConfigurationSessionStorage withRoot(StreamingSessionStorageRoot root) {
        this.setRoot(root);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getMode() != null) {
            sb.append("Mode: ").append(this.getMode()).append(",");
        }
        if (this.getRoot() != null) {
            sb.append("Root: ").append(this.getRoot());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StreamConfigurationSessionStorage)) {
            return false;
        }
        StreamConfigurationSessionStorage other = (StreamConfigurationSessionStorage)obj;
        if (other.getMode() == null ^ this.getMode() == null) {
            return false;
        }
        if (other.getMode() != null && !other.getMode().equals(this.getMode())) {
            return false;
        }
        if (other.getRoot() == null ^ this.getRoot() == null) {
            return false;
        }
        return other.getRoot() == null || other.getRoot().equals(this.getRoot());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getMode() == null ? 0 : this.getMode().hashCode());
        hashCode = 31 * hashCode + (this.getRoot() == null ? 0 : this.getRoot().hashCode());
        return hashCode;
    }

    public StreamConfigurationSessionStorage clone() {
        try {
            return (StreamConfigurationSessionStorage)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        StreamConfigurationSessionStorageMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

