/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.networkmonitor.model;

import com.amazonaws.AmazonWebServiceResult;
import com.amazonaws.ResponseMetadata;
import com.amazonaws.services.networkmonitor.model.MonitorSummary;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class ListMonitorsResult
extends AmazonWebServiceResult<ResponseMetadata>
implements Serializable,
Cloneable {
    private List<MonitorSummary> monitors;
    private String nextToken;

    public List<MonitorSummary> getMonitors() {
        return this.monitors;
    }

    public void setMonitors(Collection<MonitorSummary> monitors) {
        if (monitors == null) {
            this.monitors = null;
            return;
        }
        this.monitors = new ArrayList<MonitorSummary>(monitors);
    }

    public ListMonitorsResult withMonitors(MonitorSummary ... monitors) {
        if (this.monitors == null) {
            this.setMonitors(new ArrayList<MonitorSummary>(monitors.length));
        }
        for (MonitorSummary ele : monitors) {
            this.monitors.add(ele);
        }
        return this;
    }

    public ListMonitorsResult withMonitors(Collection<MonitorSummary> monitors) {
        this.setMonitors(monitors);
        return this;
    }

    public void setNextToken(String nextToken) {
        this.nextToken = nextToken;
    }

    public String getNextToken() {
        return this.nextToken;
    }

    public ListMonitorsResult withNextToken(String nextToken) {
        this.setNextToken(nextToken);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getMonitors() != null) {
            sb.append("Monitors: ").append(this.getMonitors()).append(",");
        }
        if (this.getNextToken() != null) {
            sb.append("NextToken: ").append(this.getNextToken());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListMonitorsResult)) {
            return false;
        }
        ListMonitorsResult other = (ListMonitorsResult)obj;
        if (other.getMonitors() == null ^ this.getMonitors() == null) {
            return false;
        }
        if (other.getMonitors() != null && !other.getMonitors().equals(this.getMonitors())) {
            return false;
        }
        if (other.getNextToken() == null ^ this.getNextToken() == null) {
            return false;
        }
        return other.getNextToken() == null || other.getNextToken().equals(this.getNextToken());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getMonitors() == null ? 0 : this.getMonitors().hashCode());
        hashCode = 31 * hashCode + (this.getNextToken() == null ? 0 : this.getNextToken().hashCode());
        return hashCode;
    }

    public ListMonitorsResult clone() {
        try {
            return (ListMonitorsResult)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }
}

