/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.marketplacemetering;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.ClientConfiguration;
import com.amazonaws.annotation.ThreadSafe;
import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.auth.DefaultAWSCredentialsProviderChain;
import com.amazonaws.client.AwsAsyncClientParams;
import com.amazonaws.client.AwsSyncClientParams;
import com.amazonaws.handlers.AsyncHandler;
import com.amazonaws.services.marketplacemetering.AWSMarketplaceMeteringAsync;
import com.amazonaws.services.marketplacemetering.AWSMarketplaceMeteringAsyncClientBuilder;
import com.amazonaws.services.marketplacemetering.AWSMarketplaceMeteringClient;
import com.amazonaws.services.marketplacemetering.model.BatchMeterUsageRequest;
import com.amazonaws.services.marketplacemetering.model.BatchMeterUsageResult;
import com.amazonaws.services.marketplacemetering.model.MeterUsageRequest;
import com.amazonaws.services.marketplacemetering.model.MeterUsageResult;
import com.amazonaws.services.marketplacemetering.model.ResolveCustomerRequest;
import com.amazonaws.services.marketplacemetering.model.ResolveCustomerResult;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;

@ThreadSafe
public class AWSMarketplaceMeteringAsyncClient
extends AWSMarketplaceMeteringClient
implements AWSMarketplaceMeteringAsync {
    private static final int DEFAULT_THREAD_POOL_SIZE = 50;
    private final ExecutorService executorService;

    @Deprecated
    public AWSMarketplaceMeteringAsyncClient() {
        this((AWSCredentialsProvider)DefaultAWSCredentialsProviderChain.getInstance());
    }

    @Deprecated
    public AWSMarketplaceMeteringAsyncClient(ClientConfiguration clientConfiguration) {
        this((AWSCredentialsProvider)DefaultAWSCredentialsProviderChain.getInstance(), clientConfiguration, Executors.newFixedThreadPool(clientConfiguration.getMaxConnections()));
    }

    @Deprecated
    public AWSMarketplaceMeteringAsyncClient(AWSCredentials awsCredentials) {
        this(awsCredentials, Executors.newFixedThreadPool(50));
    }

    @Deprecated
    public AWSMarketplaceMeteringAsyncClient(AWSCredentials awsCredentials, ExecutorService executorService) {
        this(awsCredentials, configFactory.getConfig(), executorService);
    }

    @Deprecated
    public AWSMarketplaceMeteringAsyncClient(AWSCredentials awsCredentials, ClientConfiguration clientConfiguration, ExecutorService executorService) {
        super(awsCredentials, clientConfiguration);
        this.executorService = executorService;
    }

    @Deprecated
    public AWSMarketplaceMeteringAsyncClient(AWSCredentialsProvider awsCredentialsProvider) {
        this(awsCredentialsProvider, Executors.newFixedThreadPool(50));
    }

    @Deprecated
    public AWSMarketplaceMeteringAsyncClient(AWSCredentialsProvider awsCredentialsProvider, ClientConfiguration clientConfiguration) {
        this(awsCredentialsProvider, clientConfiguration, Executors.newFixedThreadPool(clientConfiguration.getMaxConnections()));
    }

    @Deprecated
    public AWSMarketplaceMeteringAsyncClient(AWSCredentialsProvider awsCredentialsProvider, ExecutorService executorService) {
        this(awsCredentialsProvider, configFactory.getConfig(), executorService);
    }

    @Deprecated
    public AWSMarketplaceMeteringAsyncClient(AWSCredentialsProvider awsCredentialsProvider, ClientConfiguration clientConfiguration, ExecutorService executorService) {
        super(awsCredentialsProvider, clientConfiguration);
        this.executorService = executorService;
    }

    public static AWSMarketplaceMeteringAsyncClientBuilder asyncBuilder() {
        return AWSMarketplaceMeteringAsyncClientBuilder.standard();
    }

    AWSMarketplaceMeteringAsyncClient(AwsAsyncClientParams asyncClientParams) {
        super((AwsSyncClientParams)asyncClientParams);
        this.executorService = asyncClientParams.getExecutor();
    }

    public ExecutorService getExecutorService() {
        return this.executorService;
    }

    @Override
    public Future<BatchMeterUsageResult> batchMeterUsageAsync(BatchMeterUsageRequest request) {
        return this.batchMeterUsageAsync(request, null);
    }

    @Override
    public Future<BatchMeterUsageResult> batchMeterUsageAsync(final BatchMeterUsageRequest request, final AsyncHandler<BatchMeterUsageRequest, BatchMeterUsageResult> asyncHandler) {
        return this.executorService.submit(new Callable<BatchMeterUsageResult>(){

            @Override
            public BatchMeterUsageResult call() throws Exception {
                BatchMeterUsageResult result;
                try {
                    result = AWSMarketplaceMeteringAsyncClient.this.batchMeterUsage(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)request, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<MeterUsageResult> meterUsageAsync(MeterUsageRequest request) {
        return this.meterUsageAsync(request, null);
    }

    @Override
    public Future<MeterUsageResult> meterUsageAsync(final MeterUsageRequest request, final AsyncHandler<MeterUsageRequest, MeterUsageResult> asyncHandler) {
        return this.executorService.submit(new Callable<MeterUsageResult>(){

            @Override
            public MeterUsageResult call() throws Exception {
                MeterUsageResult result;
                try {
                    result = AWSMarketplaceMeteringAsyncClient.this.meterUsage(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)request, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ResolveCustomerResult> resolveCustomerAsync(ResolveCustomerRequest request) {
        return this.resolveCustomerAsync(request, null);
    }

    @Override
    public Future<ResolveCustomerResult> resolveCustomerAsync(final ResolveCustomerRequest request, final AsyncHandler<ResolveCustomerRequest, ResolveCustomerResult> asyncHandler) {
        return this.executorService.submit(new Callable<ResolveCustomerResult>(){

            @Override
            public ResolveCustomerResult call() throws Exception {
                ResolveCustomerResult result;
                try {
                    result = AWSMarketplaceMeteringAsyncClient.this.resolveCustomer(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)request, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public void shutdown() {
        super.shutdown();
        this.executorService.shutdownNow();
    }
}

