/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.elasticmapreduce.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.protocol.json.StructuredJsonGenerator;
import com.amazonaws.services.elasticmapreduce.model.StepConfig;
import com.amazonaws.services.elasticmapreduce.model.transform.HadoopJarStepConfigJsonMarshaller;

public class StepConfigJsonMarshaller {
    private static StepConfigJsonMarshaller instance;

    public void marshall(StepConfig stepConfig, StructuredJsonGenerator jsonGenerator) {
        if (stepConfig == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        try {
            jsonGenerator.writeStartObject();
            if (stepConfig.getName() != null) {
                jsonGenerator.writeFieldName("Name").writeValue(stepConfig.getName());
            }
            if (stepConfig.getActionOnFailure() != null) {
                jsonGenerator.writeFieldName("ActionOnFailure").writeValue(stepConfig.getActionOnFailure());
            }
            if (stepConfig.getHadoopJarStep() != null) {
                jsonGenerator.writeFieldName("HadoopJarStep");
                HadoopJarStepConfigJsonMarshaller.getInstance().marshall(stepConfig.getHadoopJarStep(), jsonGenerator);
            }
            jsonGenerator.writeEndObject();
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
    }

    public static StepConfigJsonMarshaller getInstance() {
        if (instance == null) {
            instance = new StepConfigJsonMarshaller();
        }
        return instance;
    }
}

