/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.elasticloadbalancingv2.model.transform;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.services.elasticloadbalancingv2.model.CreateTrustStoreRequest;
import com.amazonaws.services.elasticloadbalancingv2.model.Tag;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;
import java.util.List;

public class CreateTrustStoreRequestMarshaller
implements Marshaller<Request<CreateTrustStoreRequest>, CreateTrustStoreRequest> {
    public Request<CreateTrustStoreRequest> marshall(CreateTrustStoreRequest createTrustStoreRequest) {
        if (createTrustStoreRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)createTrustStoreRequest, "AmazonElasticLoadBalancing");
        request.addParameter("Action", "CreateTrustStore");
        request.addParameter("Version", "2015-12-01");
        request.setHttpMethod(HttpMethodName.POST);
        if (createTrustStoreRequest.getName() != null) {
            request.addParameter("Name", StringUtils.fromString((String)createTrustStoreRequest.getName()));
        }
        if (createTrustStoreRequest.getCaCertificatesBundleS3Bucket() != null) {
            request.addParameter("CaCertificatesBundleS3Bucket", StringUtils.fromString((String)createTrustStoreRequest.getCaCertificatesBundleS3Bucket()));
        }
        if (createTrustStoreRequest.getCaCertificatesBundleS3Key() != null) {
            request.addParameter("CaCertificatesBundleS3Key", StringUtils.fromString((String)createTrustStoreRequest.getCaCertificatesBundleS3Key()));
        }
        if (createTrustStoreRequest.getCaCertificatesBundleS3ObjectVersion() != null) {
            request.addParameter("CaCertificatesBundleS3ObjectVersion", StringUtils.fromString((String)createTrustStoreRequest.getCaCertificatesBundleS3ObjectVersion()));
        }
        if (createTrustStoreRequest.getTags() != null) {
            List<Tag> tagsList = createTrustStoreRequest.getTags();
            if (tagsList.isEmpty()) {
                request.addParameter("Tags", "");
            } else {
                int tagsListIndex = 1;
                for (Tag tagsListValue : tagsList) {
                    if (tagsListValue != null) {
                        if (tagsListValue.getKey() != null) {
                            request.addParameter("Tags.member." + tagsListIndex + ".Key", StringUtils.fromString((String)tagsListValue.getKey()));
                        }
                        if (tagsListValue.getValue() != null) {
                            request.addParameter("Tags.member." + tagsListIndex + ".Value", StringUtils.fromString((String)tagsListValue.getValue()));
                        }
                    }
                    ++tagsListIndex;
                }
            }
        }
        return request;
    }
}

