/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.eks.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.eks.model.NodegroupIssueCode;
import com.amazonaws.services.eks.model.transform.IssueMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class Issue
implements Serializable,
Cloneable,
StructuredPojo {
    private String code;
    private String message;
    private List<String> resourceIds;

    public void setCode(String code) {
        this.code = code;
    }

    public String getCode() {
        return this.code;
    }

    public Issue withCode(String code) {
        this.setCode(code);
        return this;
    }

    public Issue withCode(NodegroupIssueCode code) {
        this.code = code.toString();
        return this;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public String getMessage() {
        return this.message;
    }

    public Issue withMessage(String message) {
        this.setMessage(message);
        return this;
    }

    public List<String> getResourceIds() {
        return this.resourceIds;
    }

    public void setResourceIds(Collection<String> resourceIds) {
        if (resourceIds == null) {
            this.resourceIds = null;
            return;
        }
        this.resourceIds = new ArrayList<String>(resourceIds);
    }

    public Issue withResourceIds(String ... resourceIds) {
        if (this.resourceIds == null) {
            this.setResourceIds(new ArrayList<String>(resourceIds.length));
        }
        for (String ele : resourceIds) {
            this.resourceIds.add(ele);
        }
        return this;
    }

    public Issue withResourceIds(Collection<String> resourceIds) {
        this.setResourceIds(resourceIds);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getCode() != null) {
            sb.append("Code: ").append(this.getCode()).append(",");
        }
        if (this.getMessage() != null) {
            sb.append("Message: ").append(this.getMessage()).append(",");
        }
        if (this.getResourceIds() != null) {
            sb.append("ResourceIds: ").append(this.getResourceIds());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Issue)) {
            return false;
        }
        Issue other = (Issue)obj;
        if (other.getCode() == null ^ this.getCode() == null) {
            return false;
        }
        if (other.getCode() != null && !other.getCode().equals(this.getCode())) {
            return false;
        }
        if (other.getMessage() == null ^ this.getMessage() == null) {
            return false;
        }
        if (other.getMessage() != null && !other.getMessage().equals(this.getMessage())) {
            return false;
        }
        if (other.getResourceIds() == null ^ this.getResourceIds() == null) {
            return false;
        }
        return other.getResourceIds() == null || other.getResourceIds().equals(this.getResourceIds());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getCode() == null ? 0 : this.getCode().hashCode());
        hashCode = 31 * hashCode + (this.getMessage() == null ? 0 : this.getMessage().hashCode());
        hashCode = 31 * hashCode + (this.getResourceIds() == null ? 0 : this.getResourceIds().hashCode());
        return hashCode;
    }

    public Issue clone() {
        try {
            return (Issue)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        IssueMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

